// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
// originframetype ORIGIN_FRAME_GAME_UI=null
// integer bj_MAX_PLAYER_SLOTS=0
// rect bj_mapInitialPlayableArea=null
string array Colors_hexs
integer Colors_decs=0
hashtable ErrorHandling_HT=null
framehandle Framehandle_GAME_UI=null
real GameTimer_currentTime=0.
boolean MagicFunctions_compiletime=false
rect MapBounds_playableMapRect=null
rect MapBounds_boundRect=null
integer ObjectRecycler_objectLists=0
player Player_localPlayer=null
hashtable Table_ht=null
integer TypeCasting_typecastdata=0
hashtable hashtable_compiletime=null
hashtable hashtable_compiletime_32=null
integer array Table_nextFree
integer Table_firstFree=0
integer Table_maxIndex=0
integer array Table_typeId
integer array SEntry_nextFree
integer SEntry_firstFree=0
integer SEntry_maxIndex=0
integer array Stack_nextFree
integer Stack_firstFree=0
integer Stack_maxIndex=0
integer array Stack_typeId
integer array SEntry_elem
integer array SEntry_prev
integer array Stack_dummy
integer array Stack_top
integer array Stack_size
code ref_function_init_AbilityIds=null
code ref_function_init_Real=null
code ref_function_init_Integer=null
code ref_function_init_Angle=null
code ref_function_init_String=null
code ref_function_init_Vectors=null
code ref_function_init_Destructable=null
code ref_function_init_Player=null
code ref_function_init_Basics=null
code ref_function_init_MagicFunctions=null
code ref_function_init_Table=null
code ref_function_init_Playercolor=null
code ref_function_init_Maths=null
code ref_function_init_Colors=null
code ref_function_init_Printing=null
code ref_function_init_GameTimer=null
code ref_function_init_ErrorHandling=null
code ref_function_init_HashList=null
code ref_function_init_Matrices=null
code ref_function_init_Quaternion=null
code ref_function_init_Framehandle=null
code ref_function_init_Group=null
code ref_function_init_Lightning=null
code ref_function_init_WeatherEffects=null
code ref_function_init_TypeCasting=null
code ref_function_init_EventHelper=null
code ref_function_init_MapBounds=null
code ref_function_init_ObjectRecycler=null
code ref_function_code__startPeriodic_GameTimer=null
endglobals
function Loglevel_getTag takes integer this returns string
	if this == 0 then
		return "|cffADADADtrace|r"
	elseif this == 1 then
		return "|cff2685DCdebug|r"
	elseif this == 2 then
		return "|cffFFCC00info|r"
	elseif this == 3 then
		return "|cffF47E3Ewarning|r"
	else
		return "|cffFB2700error|r"
	endif
endfunction

function compileError takes string msg returns nothing
endfunction

function error takes string msg returns nothing
	local integer hash
	local player showTo
	if MagicFunctions_compiletime then
		call compileError("ERROR: " + msg)
	else
		set hash = StringHash(msg)
		if HaveSavedInteger(ErrorHandling_HT, -1, hash) then
			if LoadInteger(ErrorHandling_HT, -1, hash) + 60 < GameTimer_currentTime then
				set msg = msg + ""
				set showTo = Player_localPlayer
				if 2 <= 4 then
					call DisplayTimedTextToPlayer(showTo, 0., 0., 45., Loglevel_getTag(4) + " - " + msg)
				endif
				call SaveInteger(ErrorHandling_HT, -1, hash, R2I(GameTimer_currentTime))
				call SaveBoolean(ErrorHandling_HT, -1, hash, false)
			elseif HaveSavedBoolean(ErrorHandling_HT, -1, hash) then
				if  not LoadBoolean(ErrorHandling_HT, -1, hash) then
					set showTo = Player_localPlayer
					if 2 <= 4 then
						call DisplayTimedTextToPlayer(showTo, 0., 0., 45., Loglevel_getTag(4) + " - " + "|cffFF3A29Excessive repeating errors are being omitted")
					endif
					call SaveBoolean(ErrorHandling_HT, -1, hash, true)
				endif
			else
				set showTo = Player_localPlayer
				if 2 <= 4 then
					call DisplayTimedTextToPlayer(showTo, 0., 0., 45., Loglevel_getTag(4) + " - " + "|cffFF3A29Excessive repeating errors are being omitted")
				endif
				call SaveBoolean(ErrorHandling_HT, -1, hash, true)
			endif
		else
			call SaveInteger(ErrorHandling_HT, -1, hash, R2I(GameTimer_currentTime))
			set msg = "Message: " + msg + ""
			set showTo = Player_localPlayer
			if 2 <= 4 then
				call DisplayTimedTextToPlayer(showTo, 0., 0., 45., Loglevel_getTag(4) + " - " + msg)
			endif
		endif
		call I2S(1 / 0)
	endif
endfunction

function initCompiletimeState_0 takes nothing returns nothing
	call InitHashtable()
	call InitHashtable()
	set hashtable_compiletime_32 = InitHashtable()
	set hashtable_compiletime = InitHashtable()
	call SaveInteger(hashtable_compiletime_32, 1, -242600650, 0)
	call SaveInteger(hashtable_compiletime_32, 1, 1132341824, 1)
	call SaveInteger(hashtable_compiletime_32, 1, -647782241, 2)
	call SaveInteger(hashtable_compiletime_32, 1, -854572045, 3)
	call SaveInteger(hashtable_compiletime_32, 1, -680649701, 4)
	call SaveInteger(hashtable_compiletime_32, 1, -943650483, 5)
	call SaveInteger(hashtable_compiletime_32, 1, -671760605, 6)
	call SaveInteger(hashtable_compiletime_32, 1, 349230650, 7)
	call SaveInteger(hashtable_compiletime_32, 1, -1894922563, 8)
	call SaveInteger(hashtable_compiletime_32, 1, -1474492777, 9)
	call SaveInteger(hashtable_compiletime_32, 1, -1587459251, 10)
	call SaveInteger(hashtable_compiletime_32, 1, -1676716706, 11)
	call SaveInteger(hashtable_compiletime_32, 1, -1559655710, 12)
	call SaveInteger(hashtable_compiletime_32, 1, -1663695754, 13)
	call SaveInteger(hashtable_compiletime_32, 1, 597637742, 14)
	call SaveInteger(hashtable_compiletime_32, 1, 789744696, 15)
	call SaveStr(hashtable_compiletime_32, 2, 0, "")
endfunction

function code__startPeriodic_GameTimer takes nothing returns nothing
	set GameTimer_currentTime = GameTimer_currentTime + 0.030
endfunction

function init_AbilityIds takes nothing returns boolean
	return true
endfunction

function init_Angle takes nothing returns boolean
	return true
endfunction

function init_Basics takes nothing returns boolean
	return true
endfunction

function dispatch_Table_Table_Table_saveInt takes integer this, integer parentKey, integer value returns nothing
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveInt")
		else
			call error("Called Table.saveInt on invalid object.")
		endif
	endif
	call SaveInteger(Table_ht, this, parentKey, value)
endfunction

function new_Table takes nothing returns integer
	local integer this
	if Table_firstFree == 0 then
		if Table_maxIndex < 32768 then
			set Table_maxIndex = Table_maxIndex + 1
			set this = Table_maxIndex
			set Table_typeId[this] = 15
		else
			call error("Out of memory: Could not create Table.")
			set this = 0
		endif
	else
		set Table_firstFree = Table_firstFree - 1
		set this = Table_nextFree[Table_firstFree]
		set Table_typeId[this] = 15
	endif
	return this
endfunction

function init_Colors takes nothing returns boolean
	local integer firstpart
	set Colors_hexs[0] = "0"
	set Colors_hexs[1] = "1"
	set Colors_hexs[2] = "2"
	set Colors_hexs[3] = "3"
	set Colors_hexs[4] = "4"
	set Colors_hexs[5] = "5"
	set Colors_hexs[6] = "6"
	set Colors_hexs[7] = "7"
	set Colors_hexs[8] = "8"
	set Colors_hexs[9] = "9"
	set Colors_hexs[10] = "A"
	set Colors_hexs[11] = "B"
	set Colors_hexs[12] = "C"
	set Colors_hexs[13] = "D"
	set Colors_hexs[14] = "E"
	set Colors_hexs[15] = "F"
	set Colors_decs = new_Table()
	set firstpart = 0
	loop
		exitwhen firstpart > 15
		call dispatch_Table_Table_Table_saveInt(Colors_decs, StringHash(Colors_hexs[firstpart]), firstpart)
		set firstpart = firstpart + 1
	endloop
	return true
endfunction

function init_Destructable takes nothing returns boolean
	return true
endfunction

function init_ErrorHandling takes nothing returns boolean
	set ErrorHandling_HT = hashtable_compiletime
	return true
endfunction

function new_HashMap takes nothing returns integer
	local integer this
	if Table_firstFree == 0 then
		if Table_maxIndex < 32768 then
			set Table_maxIndex = Table_maxIndex + 1
			set this = Table_maxIndex
			set Table_typeId[this] = 16
		else
			call error("Out of memory: Could not create HashMap.")
			set this = 0
		endif
	else
		set Table_firstFree = Table_firstFree - 1
		set this = Table_nextFree[Table_firstFree]
		set Table_typeId[this] = 16
	endif
	return this
endfunction

function init_EventHelper takes nothing returns boolean
	call new_HashMap()
	call new_HashMap()
	call new_Table()
	return true
endfunction

function verifyFrameNameLength takes string name returns boolean
	if StringLength(name) > 560 then
		call error("Trying to address frame with exceeding maximum frame name length (" + I2S(560) + ") for: " + name)
		return false
	endif
	return true
endfunction

function init_Framehandle takes nothing returns boolean
	local framehandle owner
	set Framehandle_GAME_UI = BlzGetOriginFrame(ORIGIN_FRAME_GAME_UI, 0)
	set owner = Framehandle_GAME_UI
	call verifyFrameNameLength("SetMousePositionCage")
	set owner = BlzCreateFrameByType("FRAME", "SetMousePositionCage", owner, null, 0)
	call BlzFrameSetSize(owner, 0.0001, 0.0001)
	return true
endfunction

function init_GameTimer takes nothing returns boolean
	call TimerStart(CreateTimer(), 100000., false, null)
	call TimerStart(CreateTimer(), 0.030, true, ref_function_code__startPeriodic_GameTimer)
	return true
endfunction

function init_Group takes nothing returns boolean
	call CreateGroup()
	return true
endfunction

function init_HashList takes nothing returns boolean
	return true
endfunction

function init_Integer takes nothing returns boolean
	return true
endfunction

function init_Lightning takes nothing returns boolean
	return true
endfunction

function init_MagicFunctions takes nothing returns boolean
	set MagicFunctions_compiletime = false
	return true
endfunction

function initMapBounds takes nothing returns nothing
	local rect cond_result
	local region receiver
	if MagicFunctions_compiletime then
		set cond_result = Rect(-1024., -1024., 1024., 1024.)
	else
		set cond_result = bj_mapInitialPlayableArea
	endif
	set MapBounds_playableMapRect = cond_result
	set receiver = CreateRegion()
	call RegionAddRect(receiver, MapBounds_playableMapRect)
	if MagicFunctions_compiletime then
		set cond_result = Rect(-1536., -1536., 1536., 1536.)
	else
		set cond_result = GetWorldBounds()
	endif
	set MapBounds_boundRect = cond_result
	set receiver = CreateRegion()
	call RegionAddRect(receiver, MapBounds_boundRect)
	call GetRectMinX(MapBounds_playableMapRect)
	call GetRectMinY(MapBounds_playableMapRect)
	call GetRectMaxX(MapBounds_playableMapRect)
	call GetRectMaxY(MapBounds_playableMapRect)
	call GetRectMinX(MapBounds_boundRect)
	call GetRectMinY(MapBounds_boundRect)
	call GetRectMaxX(MapBounds_boundRect)
	call GetRectMaxY(MapBounds_boundRect)
endfunction

function init_MapBounds takes nothing returns boolean
	call initMapBounds()
	return true
endfunction

function init_Maths takes nothing returns boolean
	return true
endfunction

function init_Matrices takes nothing returns boolean
	return true
endfunction

function dispatch_Stack_Stack_Stack_pop takes integer this returns integer
	local integer wval
	if Stack_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Stack.pop")
		else
			call error("Called Stack.pop on invalid object.")
		endif
	endif
	set wval = Stack_top[this]
	set Stack_top[this] = SEntry_prev[Stack_top[this]]
	set Stack_size[this] = Stack_size[this] - 1
	return SEntry_elem[wval]
endfunction

function dispatch_Table_Table_Table_hasInt takes integer this, integer parentKey returns boolean
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.hasInt")
		else
			call error("Called Table.hasInt on invalid object.")
		endif
	endif
	return HaveSavedInteger(Table_ht, this, parentKey)
endfunction

function dispatch_Table_Table_Table_loadInt takes integer this, integer parentKey returns integer
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.loadInt")
		else
			call error("Called Table.loadInt on invalid object.")
		endif
	endif
	return LoadInteger(Table_ht, this, parentKey)
endfunction

function construct_Stack takes integer this returns nothing
	local integer this_1
	set Stack_size[this] = 0
	if SEntry_firstFree == 0 then
		if SEntry_maxIndex < 32768 then
			set SEntry_maxIndex = SEntry_maxIndex + 1
			set this_1 = SEntry_maxIndex
		else
			call error("Out of memory: Could not create SEntry.")
			set this_1 = 0
		endif
	else
		set SEntry_firstFree = SEntry_firstFree - 1
		set this_1 = SEntry_nextFree[SEntry_firstFree]
	endif
	set SEntry_elem[this_1] = 0
	set SEntry_prev[this_1] = 0
	set Stack_dummy[this] = this_1
	set Stack_top[this] = Stack_dummy[this]
endfunction

function new_Stack takes nothing returns integer
	local integer this
	if Stack_firstFree == 0 then
		if Stack_maxIndex < 32768 then
			set Stack_maxIndex = Stack_maxIndex + 1
			set this = Stack_maxIndex
			set Stack_typeId[this] = 12
		else
			call error("Out of memory: Could not create Stack.")
			set this = 0
		endif
	else
		set Stack_firstFree = Stack_firstFree - 1
		set this = Stack_nextFree[Stack_firstFree]
		set Stack_typeId[this] = 12
	endif
	call construct_Stack(this)
	return this
endfunction

function unitFromIndex takes integer index returns unit
	local integer this = TypeCasting_typecastdata
	local fogstate value = ConvertFogState(index)
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveFogState")
		else
			call error("Called Table.saveFogState on invalid object.")
		endif
	endif
	call SaveFogStateHandle(Table_ht, this, 0, value)
	set index = TypeCasting_typecastdata
	if Table_typeId[index] == 0 then
		if index == 0 then
			call error("Nullpointer exception when calling Table.loadUnit")
		else
			call error("Called Table.loadUnit on invalid object.")
		endif
	endif
	return LoadUnitHandle(Table_ht, index, 0)
endfunction

function getUnit takes player p, integer id, real pos_x, real pos_y, real facing_radians returns unit
	local unit receiver
	if dispatch_Table_Table_Table_hasInt(ObjectRecycler_objectLists, id) then
		set receiver = unitFromIndex(dispatch_Stack_Stack_Stack_pop(dispatch_Table_Table_Table_loadInt(ObjectRecycler_objectLists, id)))
		call SetUnitFacing(receiver, facing_radians * 57.295779513)
		call ShowUnit(receiver, true)
		return receiver
	else
		call dispatch_Table_Table_Table_saveInt(ObjectRecycler_objectLists, id, new_Stack())
		return CreateUnit(p, id, pos_x, pos_y, facing_radians * 57.295779513)
	endif
endfunction

function new_SEntry takes integer elem, integer prev returns integer
	local integer this
	if SEntry_firstFree == 0 then
		if SEntry_maxIndex < 32768 then
			set SEntry_maxIndex = SEntry_maxIndex + 1
			set this = SEntry_maxIndex
		else
			call error("Out of memory: Could not create SEntry.")
			set this = 0
		endif
	else
		set SEntry_firstFree = SEntry_firstFree - 1
		set this = SEntry_nextFree[SEntry_firstFree]
	endif
	set SEntry_elem[this] = elem
	set SEntry_prev[this] = prev
	return this
endfunction

function dispatch_Stack_Stack_Stack_push takes integer this, integer elem returns nothing
	if Stack_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Stack.push")
		else
			call error("Called Stack.push on invalid object.")
		endif
	endif
	set Stack_top[this] = new_SEntry(elem, Stack_top[this])
	set Stack_size[this] = Stack_size[this] + 1
endfunction

function unit_recycle takes unit this returns nothing
	local integer id = GetUnitTypeId(this)
	if dispatch_Table_Table_Table_hasInt(ObjectRecycler_objectLists, id) then
		set id = dispatch_Table_Table_Table_loadInt(ObjectRecycler_objectLists, id)
		call dispatch_Stack_Stack_Stack_push(id, GetHandleId(this))
		call ShowUnit(this, false)
		call SetUnitPosition(this, 1., 2.)
	else
		call error("trying to recycle a unit not created by 'getUnit'!")
	endif
endfunction

function init_ObjectRecycler takes nothing returns boolean
	set ObjectRecycler_objectLists = new_Table()
	call unit_recycle(getUnit(Player(0), 0, 0., 0., 0.))
	return true
endfunction

function init_Player takes nothing returns boolean
	local integer i
	local integer temp
	set Player_localPlayer = GetLocalPlayer()
	set i = 0
	set temp = bj_MAX_PLAYER_SLOTS - 1
	loop
		exitwhen i > temp
		set i = i + 1
	endloop
	return true
endfunction

function init_Playercolor takes nothing returns boolean
	return true
endfunction

function init_Printing takes nothing returns boolean
	return true
endfunction

function init_Quaternion takes nothing returns boolean
	return true
endfunction

function init_Real takes nothing returns boolean
	return true
endfunction

function init_String takes nothing returns boolean
	return true
endfunction

function init_Table takes nothing returns boolean
	set Table_ht = hashtable_compiletime_32
	return true
endfunction

function init_TypeCasting takes nothing returns boolean
	local integer this
	set TypeCasting_typecastdata = new_Table()
	set this = TypeCasting_typecastdata
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveString")
		else
			call error("Called Table.saveString on invalid object.")
		endif
	endif
	call SaveStr(Table_ht, this, 0, "")
	return true
endfunction

function init_Vectors takes nothing returns boolean
	call Location(0., 0.)
	return true
endfunction

function init_WeatherEffects takes nothing returns boolean
	return true
endfunction

function initGlobals takes nothing returns nothing
	set ref_function_init_AbilityIds = function init_AbilityIds
	set ref_function_init_Real = function init_Real
	set ref_function_init_Integer = function init_Integer
	set ref_function_init_Angle = function init_Angle
	set ref_function_init_String = function init_String
	set ref_function_init_Vectors = function init_Vectors
	set ref_function_init_Destructable = function init_Destructable
	set ref_function_init_Player = function init_Player
	set ref_function_init_Basics = function init_Basics
	set ref_function_init_MagicFunctions = function init_MagicFunctions
	set ref_function_init_Table = function init_Table
	set ref_function_init_Playercolor = function init_Playercolor
	set ref_function_init_Maths = function init_Maths
	set ref_function_init_Colors = function init_Colors
	set ref_function_init_Printing = function init_Printing
	set ref_function_init_GameTimer = function init_GameTimer
	set ref_function_init_ErrorHandling = function init_ErrorHandling
	set ref_function_init_HashList = function init_HashList
	set ref_function_init_Matrices = function init_Matrices
	set ref_function_init_Quaternion = function init_Quaternion
	set ref_function_init_Framehandle = function init_Framehandle
	set ref_function_init_Group = function init_Group
	set ref_function_init_Lightning = function init_Lightning
	set ref_function_init_WeatherEffects = function init_WeatherEffects
	set ref_function_init_TypeCasting = function init_TypeCasting
	set ref_function_init_EventHelper = function init_EventHelper
	set ref_function_init_MapBounds = function init_MapBounds
	set ref_function_init_ObjectRecycler = function init_ObjectRecycler
	set ref_function_code__startPeriodic_GameTimer = function code__startPeriodic_GameTimer
endfunction

function main takes nothing returns nothing
	local trigger initTrig
	call initGlobals()
	call ExecuteFunc("initCompiletimeState_0")
	set initTrig = CreateTrigger()
	call TriggerAddCondition(initTrig, Condition(ref_function_init_AbilityIds))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package AbilityIds.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Real))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Real.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Integer))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Integer.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Angle))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Angle.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_String))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package String.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Vectors))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Vectors.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Destructable))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Destructable.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Player))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Player.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Basics))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Basics.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_MagicFunctions))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package MagicFunctions.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Table))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Table.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Playercolor))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Playercolor.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Maths))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Maths.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Colors))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Colors.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Printing))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Printing.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_GameTimer))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package GameTimer.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_ErrorHandling))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package ErrorHandling.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_HashList))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package HashList.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Matrices))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Matrices.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Quaternion))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Quaternion.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Framehandle))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Framehandle.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Group))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Group.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Lightning))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Lightning.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_WeatherEffects))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package WeatherEffects.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_TypeCasting))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package TypeCasting.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_EventHelper))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package EventHelper.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_MapBounds))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package MapBounds.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_ObjectRecycler))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package ObjectRecycler.")
	endif
	call TriggerClearConditions(initTrig)
	call DestroyTrigger(initTrig)
endfunction

function config takes nothing returns nothing
endfunction

