//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaWhileImpl implements LuaWhile{
    LuaWhileImpl(LuaExpr cond, LuaStatements body) {
        if (cond == null)
            throw new IllegalArgumentException("Element cond must not be null.");
        if (body == null)
            throw new IllegalArgumentException("Element body must not be null.");
        this.cond = cond;
        this.body = body;
        cond.setParent(this);
        body.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaExpr cond;
    public void setCond(LuaExpr cond) {
        if (cond == null) throw new IllegalArgumentException();
        this.cond.setParent(null);
        cond.setParent(this);
        this.cond = cond;
    } 
    public LuaExpr getCond() { return cond; }

    private LuaStatements body;
    public void setBody(LuaStatements body) {
        if (body == null) throw new IllegalArgumentException();
        this.body.setParent(null);
        body.setParent(this);
        this.body = body;
    } 
    public LuaStatements getBody() { return body; }

    public Element get(int i) {
        switch (i) {
            case 0: return cond;
            case 1: return body;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = cond; setCond((LuaExpr) newElem); return oldElem;
            case 1: oldElem = body; setBody((LuaStatements) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.cond);
        action.accept(this.body);
    }
    public int size() {
        return 2;
    }
    @Override public LuaWhile copy() {
        LuaWhile result = new LuaWhileImpl((LuaExpr) this.cond.copy(), (LuaStatements) this.body.copy());
        return result;
    }

    @Override public LuaWhile copyWithRefs() {
        LuaWhile res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        cond.clearAttributes();
        body.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaWhile(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaWhile(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaWhile(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaWhile(this);
    }

    @Override public String toString() {
        return "LuaWhile(" + cond + ", " +body+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaWhile) {
            LuaWhile o = (LuaWhile) e;
            return this.cond.structuralEquals(o.getCond())
                && this.body.structuralEquals(o.getBody());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaWhile)this, sb, indent);
    }
}
