//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaVariableImpl implements LuaVariable{
    LuaVariableImpl(String name, LuaExprOpt initialValue) {
        if (name == null)
            throw new IllegalArgumentException("Element name must not be null.");
        if (initialValue == null)
            throw new IllegalArgumentException("Element initialValue must not be null.");
        this.name = name;
        this.initialValue = initialValue;
        initialValue.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private String name;
    public void setName(String name) {
        if (name == null) throw new IllegalArgumentException();
        this.name = name;
    } 
    public String getName() { return name; }

    private LuaExprOpt initialValue;
    public void setInitialValue(LuaExprOpt initialValue) {
        if (initialValue == null) throw new IllegalArgumentException();
        this.initialValue.setParent(null);
        initialValue.setParent(this);
        this.initialValue = initialValue;
    } 
    public LuaExprOpt getInitialValue() { return initialValue; }

    public Element get(int i) {
        switch (i) {
            case 0: return initialValue;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = initialValue; setInitialValue((LuaExprOpt) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.initialValue);
    }
    public int size() {
        return 1;
    }
    @Override public LuaVariable copy() {
        LuaVariable result = new LuaVariableImpl(name, (LuaExprOpt) this.initialValue.copy());
        return result;
    }

    @Override public LuaVariable copyWithRefs() {
        LuaVariable res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        initialValue.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaDefinition.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }
    @Override public void match(LuaDefinition.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaVariable(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaVariable(this);
    }

    @Override public String toString() {
        return "LuaVariable(" + name + ", " +initialValue+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaVariable) {
            LuaVariable o = (LuaVariable) e;
            return java.util.Objects.equals(name, o.getName())
                && this.initialValue.structuralEquals(o.getInitialValue());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaVariable)this, sb, indent);
    }
}
