//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaExprUnaryImpl implements LuaExprUnary{
    LuaExprUnaryImpl(LuaOpUnary opU, LuaExpr right) {
        if (opU == null)
            throw new IllegalArgumentException("Element opU must not be null.");
        if (right == null)
            throw new IllegalArgumentException("Element right must not be null.");
        this.opU = opU;
        this.right = right;
        opU.setParent(this);
        right.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaOpUnary opU;
    public void setOpU(LuaOpUnary opU) {
        if (opU == null) throw new IllegalArgumentException();
        this.opU.setParent(null);
        opU.setParent(this);
        this.opU = opU;
    } 
    public LuaOpUnary getOpU() { return opU; }

    private LuaExpr right;
    public void setRight(LuaExpr right) {
        if (right == null) throw new IllegalArgumentException();
        this.right.setParent(null);
        right.setParent(this);
        this.right = right;
    } 
    public LuaExpr getRight() { return right; }

    public Element get(int i) {
        switch (i) {
            case 0: return opU;
            case 1: return right;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = opU; setOpU((LuaOpUnary) newElem); return oldElem;
            case 1: oldElem = right; setRight((LuaExpr) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.opU);
        action.accept(this.right);
    }
    public int size() {
        return 2;
    }
    @Override public LuaExprUnary copy() {
        LuaExprUnary result = new LuaExprUnaryImpl((LuaOpUnary) this.opU.copy(), (LuaExpr) this.right.copy());
        return result;
    }

    @Override public LuaExprUnary copyWithRefs() {
        LuaExprUnary res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        opU.clearAttributes();
        right.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }
    @Override public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }
    @Override public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override public String toString() {
        return "LuaExprUnary(" + opU + ", " +right+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprUnary) {
            LuaExprUnary o = (LuaExprUnary) e;
            return this.opU.structuralEquals(o.getOpU())
                && this.right.structuralEquals(o.getRight());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaExprUnary)this, sb, indent);
    }
}
