//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaExprMethodCallImpl implements LuaExprMethodCall{
    LuaExprMethodCallImpl(LuaExpr receiver, LuaMethod method, LuaExprlist arguments) {
        if (receiver == null)
            throw new IllegalArgumentException("Element receiver must not be null.");
        if (method == null)
            throw new IllegalArgumentException("Element method must not be null.");
        if (arguments == null)
            throw new IllegalArgumentException("Element arguments must not be null.");
        this.receiver = receiver;
        this.method = method;
        this.arguments = arguments;
        receiver.setParent(this);
        arguments.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaExpr receiver;
    public void setReceiver(LuaExpr receiver) {
        if (receiver == null) throw new IllegalArgumentException();
        this.receiver.setParent(null);
        receiver.setParent(this);
        this.receiver = receiver;
    } 
    public LuaExpr getReceiver() { return receiver; }

    private LuaMethod method;
    public void setMethod(LuaMethod method) {
        if (method == null) throw new IllegalArgumentException();
        this.method = method;
    } 
    public LuaMethod getMethod() { return method; }

    private LuaExprlist arguments;
    public void setArguments(LuaExprlist arguments) {
        if (arguments == null) throw new IllegalArgumentException();
        this.arguments.setParent(null);
        arguments.setParent(this);
        this.arguments = arguments;
    } 
    public LuaExprlist getArguments() { return arguments; }

    public Element get(int i) {
        switch (i) {
            case 0: return receiver;
            case 1: return arguments;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = receiver; setReceiver((LuaExpr) newElem); return oldElem;
            case 1: oldElem = arguments; setArguments((LuaExprlist) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.receiver);
        action.accept(this.arguments);
    }
    public int size() {
        return 2;
    }
    @Override public LuaExprMethodCall copy() {
        LuaExprMethodCall result = new LuaExprMethodCallImpl((LuaExpr) this.receiver.copy(), method, (LuaExprlist) this.arguments.copy());
        return result;
    }

    @Override public LuaExprMethodCall copyWithRefs() {
        LuaExprMethodCall res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        receiver.clearAttributes();
        arguments.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprMethodCall(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprMethodCall(this);
    }

    @Override public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprMethodCall(this);
    }
    @Override public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprMethodCall(this);
    }

    @Override public <T> T match(LuaCallExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprMethodCall(this);
    }
    @Override public void match(LuaCallExpr.MatcherVoid matcher) {
        matcher.case_LuaExprMethodCall(this);
    }

    @Override public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprMethodCall(this);
    }
    @Override public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprMethodCall(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprMethodCall(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprMethodCall(this);
    }

    @Override public String toString() {
        return "LuaExprMethodCall(" + receiver + ", " +method + ", " +arguments+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprMethodCall) {
            LuaExprMethodCall o = (LuaExprMethodCall) e;
            return this.receiver.structuralEquals(o.getReceiver())
                && this.method == o.getMethod()
                && this.arguments.structuralEquals(o.getArguments());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaExprMethodCall)this, sb, indent);
    }
}
