//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaExprArrayAccessImpl implements LuaExprArrayAccess{
    LuaExprArrayAccessImpl(LuaExpr left, LuaExprlist indexes) {
        if (left == null)
            throw new IllegalArgumentException("Element left must not be null.");
        if (indexes == null)
            throw new IllegalArgumentException("Element indexes must not be null.");
        this.left = left;
        this.indexes = indexes;
        left.setParent(this);
        indexes.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaExpr left;
    public void setLeft(LuaExpr left) {
        if (left == null) throw new IllegalArgumentException();
        this.left.setParent(null);
        left.setParent(this);
        this.left = left;
    } 
    public LuaExpr getLeft() { return left; }

    private LuaExprlist indexes;
    public void setIndexes(LuaExprlist indexes) {
        if (indexes == null) throw new IllegalArgumentException();
        this.indexes.setParent(null);
        indexes.setParent(this);
        this.indexes = indexes;
    } 
    public LuaExprlist getIndexes() { return indexes; }

    public Element get(int i) {
        switch (i) {
            case 0: return left;
            case 1: return indexes;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = left; setLeft((LuaExpr) newElem); return oldElem;
            case 1: oldElem = indexes; setIndexes((LuaExprlist) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.left);
        action.accept(this.indexes);
    }
    public int size() {
        return 2;
    }
    @Override public LuaExprArrayAccess copy() {
        LuaExprArrayAccess result = new LuaExprArrayAccessImpl((LuaExpr) this.left.copy(), (LuaExprlist) this.indexes.copy());
        return result;
    }

    @Override public LuaExprArrayAccess copyWithRefs() {
        LuaExprArrayAccess res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        left.clearAttributes();
        indexes.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }
    @Override public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }
    @Override public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprArrayAccess(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprArrayAccess(this);
    }

    @Override public String toString() {
        return "LuaExprArrayAccess(" + left + ", " +indexes+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprArrayAccess) {
            LuaExprArrayAccess o = (LuaExprArrayAccess) e;
            return this.left.structuralEquals(o.getLeft())
                && this.indexes.structuralEquals(o.getIndexes());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaExprArrayAccess)this, sb, indent);
    }
}
