//generated by abstract-syntax-gen
package de.peeeq.wurstscript.ast;
import java.util.*;

import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

abstract class AsgList<T> implements List<T> {
	
	private ArrayList<T> list = new ArrayList<T>();
	
	abstract protected void other_setParentToThis(T t);
	abstract protected void other_clearParent(T t);
	
	public boolean add(T t) {
		other_setParentToThis(t);
		return list.add(t);
	}

	public void addFront(T t) { add(0, t); }
	public List<T> removeAll() {
		List<T> result = new ArrayList<T>(list);
		for (T t : result) {
			other_clearParent(t);
		}
		list.clear();
		return result;
	}
	@Override
	public void add(int index, T elem) {
		other_setParentToThis(elem);
		list.add(index, elem);		
	}

	@Override
	public boolean addAll(Collection<? extends T> c) {
		for (T t: c) {
			other_setParentToThis(t);
		}
		return list.addAll(c);
	}

	@Override
	public boolean addAll(int pos, Collection<? extends T> c) {
		for (T t: c) {
			other_setParentToThis(t);
		}
		return list.addAll(pos, c);
	}

	@Override
	public void clear() {
		for (T t : list) {
			other_clearParent(t);
		}
		list.clear();
	}

	@Override
	public boolean contains(Object arg0) {
		return list.contains(arg0);
	}

	@Override
	public boolean containsAll(Collection<?> c) {
		return list.containsAll(c);
	}

	@Override
	public T get(int index) {
		return list.get(index);
	}

	@Override
	public int indexOf(Object o) {
		return list.indexOf(o);
	}

	@Override
	public boolean isEmpty() {
		return list.isEmpty();
	}

	@Override
	public Iterator<T> iterator() {
		return list.iterator();
	}

	@Override
	public int lastIndexOf(Object o) {
		return list.lastIndexOf(o);
	}

	@Override
	public ListIterator<T> listIterator(int index) {
		return new AsgListIterator(list.listIterator(index));
	}
	@Override
	public ListIterator<T> listIterator() {
		return new AsgListIterator(list.listIterator());
	}
	
	class AsgListIterator implements ListIterator<T> {

		private ListIterator<T> it;
		private T lastElement;

		public AsgListIterator(ListIterator<T> listIterator) {
			this.it = listIterator;
		}

		@Override
		public void add(T e) {
			other_setParentToThis(e);
			it.add(e);
		}

		@Override
		public boolean hasNext() {
			return it.hasNext();
		}

		@Override
		public boolean hasPrevious() {
			return it.hasPrevious();
		}

		@Override
		public T next() {
			lastElement = it.next();
			return lastElement;
		}

		@Override
		public int nextIndex() {
			return it.nextIndex();
		}

		@Override
		public T previous() {
			lastElement = it.previous();
			return lastElement;
		}

		@Override
		public int previousIndex() {
			return it.previousIndex();
		}

		@Override
		public void remove() {
			if (lastElement == null) throw new Error();
			other_clearParent(lastElement);
			lastElement = null;
			it.remove();
		}

		@Override
		public void set(T e) {
			if (lastElement == null) throw new Error();
			other_clearParent(lastElement);
			lastElement = null;
			other_setParentToThis(e);
			it.set(e);
		}
		
	}

 @SuppressWarnings("unchecked")
	@Override
	public boolean remove(Object o) {
		if (list.remove(o)) {
			other_clearParent((T) o);
			return true;
		}
		return false;
	}

	@Override
	public T remove(int index) {
		T t = list.remove(index);
		other_clearParent(t);
		return t;
	}

	@Override
	public boolean removeAll(Collection<?> c) {
		for (T t : list) {
			if (c.contains(t)) {
				other_clearParent(t);
			}
		}
		return list.removeAll(c);
	}

	@Override
	public boolean retainAll(Collection<?> c) {
		for (T t : list) {
			if (!c.contains(t)) {
				other_clearParent(t);
			}
		}
		return list.retainAll(c);
	}

	@Override
	public T set(int index, T element) {
		other_setParentToThis(element);
		T t = list.set(index, element);		
		other_clearParent(t);
		return t;
	}

	@Override
	public int size() {
		return list.size();
	}

	@Override
	public List<T> subList(int fromIndex, int toIndex) {
		return list.subList(fromIndex, toIndex);
	}

	@Override
	public Object[] toArray() {
		return list.toArray();
	}

	@Override
	public <S> S[] toArray(S[] a) {
		return list.toArray(a);
	}
	
	
	
	public boolean structuralEquals(Element e) {
		if (e instanceof AsgList) {
			AsgList<?> o = (AsgList<?>) e;
			if (o.size() != size()) {
				return false;
			}
			for (int i=0; i<size(); i++) {
				Element a = (Element) get(i);
				Element b = (Element) o.get(i);
				if (!a.structuralEquals(b)) {
					return false;
				}
			}
			return true;
		}
		return false;
	}

	@SuppressWarnings({"unchecked", "rawtypes"})	public void forEachElement(java.util.function.Consumer<? super Element> action) {
		list.forEach((java.util.function.Consumer) action);
	}
	public void trimToSize() {
		list.trimToSize();
	}
}
