//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaTableConstructorImpl implements LuaTableConstructor{
    LuaTableConstructorImpl(LuaTableFields tableFields) {
        if (tableFields == null)
            throw new IllegalArgumentException("Element tableFields must not be null.");
        this.tableFields = tableFields;
        tableFields.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaTableFields tableFields;
    public void setTableFields(LuaTableFields tableFields) {
        if (tableFields == null) throw new IllegalArgumentException();
        this.tableFields.setParent(null);
        tableFields.setParent(this);
        this.tableFields = tableFields;
    } 
    public LuaTableFields getTableFields() { return tableFields; }

    public Element get(int i) {
        switch (i) {
            case 0: return tableFields;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = tableFields; setTableFields((LuaTableFields) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.tableFields);
    }
    public int size() {
        return 1;
    }
    @Override public LuaTableConstructor copy() {
        LuaTableConstructor result = new LuaTableConstructorImpl((LuaTableFields) this.tableFields.copy());
        return result;
    }

    @Override public LuaTableConstructor copyWithRefs() {
        LuaTableConstructor res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        tableFields.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaTableConstructor(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaTableConstructor(this);
    }

    @Override public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaTableConstructor(this);
    }
    @Override public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaTableConstructor(this);
    }

    @Override public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaTableConstructor(this);
    }
    @Override public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaTableConstructor(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaTableConstructor(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaTableConstructor(this);
    }

    @Override public String toString() {
        return "LuaTableConstructor(" + tableFields+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaTableConstructor) {
            LuaTableConstructor o = (LuaTableConstructor) e;
            return this.tableFields.structuralEquals(o.getTableFields());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaTableConstructor)this, sb, indent);
    }
}
