//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaIfImpl implements LuaIf{
    LuaIfImpl(LuaExpr cond, LuaStatements thenStmts, LuaStatements elseStmts) {
        if (cond == null)
            throw new IllegalArgumentException("Element cond must not be null.");
        if (thenStmts == null)
            throw new IllegalArgumentException("Element thenStmts must not be null.");
        if (elseStmts == null)
            throw new IllegalArgumentException("Element elseStmts must not be null.");
        this.cond = cond;
        this.thenStmts = thenStmts;
        this.elseStmts = elseStmts;
        cond.setParent(this);
        thenStmts.setParent(this);
        elseStmts.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private LuaExpr cond;
    public void setCond(LuaExpr cond) {
        if (cond == null) throw new IllegalArgumentException();
        this.cond.setParent(null);
        cond.setParent(this);
        this.cond = cond;
    } 
    public LuaExpr getCond() { return cond; }

    private LuaStatements thenStmts;
    public void setThenStmts(LuaStatements thenStmts) {
        if (thenStmts == null) throw new IllegalArgumentException();
        this.thenStmts.setParent(null);
        thenStmts.setParent(this);
        this.thenStmts = thenStmts;
    } 
    public LuaStatements getThenStmts() { return thenStmts; }

    private LuaStatements elseStmts;
    public void setElseStmts(LuaStatements elseStmts) {
        if (elseStmts == null) throw new IllegalArgumentException();
        this.elseStmts.setParent(null);
        elseStmts.setParent(this);
        this.elseStmts = elseStmts;
    } 
    public LuaStatements getElseStmts() { return elseStmts; }

    public Element get(int i) {
        switch (i) {
            case 0: return cond;
            case 1: return thenStmts;
            case 2: return elseStmts;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = cond; setCond((LuaExpr) newElem); return oldElem;
            case 1: oldElem = thenStmts; setThenStmts((LuaStatements) newElem); return oldElem;
            case 2: oldElem = elseStmts; setElseStmts((LuaStatements) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.cond);
        action.accept(this.thenStmts);
        action.accept(this.elseStmts);
    }
    public int size() {
        return 3;
    }
    @Override public LuaIf copy() {
        LuaIf result = new LuaIfImpl((LuaExpr) this.cond.copy(), (LuaStatements) this.thenStmts.copy(), (LuaStatements) this.elseStmts.copy());
        return result;
    }

    @Override public LuaIf copyWithRefs() {
        LuaIf res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        cond.clearAttributes();
        thenStmts.clearAttributes();
        elseStmts.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaIf(this);
    }
    @Override public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaIf(this);
    }

    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaIf(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaIf(this);
    }

    @Override public String toString() {
        return "LuaIf(" + cond + ", " +thenStmts + ", " +elseStmts+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaIf) {
            LuaIf o = (LuaIf) e;
            return this.cond.structuralEquals(o.getCond())
                && this.thenStmts.structuralEquals(o.getThenStmts())
                && this.elseStmts.structuralEquals(o.getElseStmts());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaIf)this, sb, indent);
    }
}
