//generated by abstract-syntax-gen
package de.peeeq.wurstscript.ast;
import java.util.*;

public interface Element {
    Element getParent();
    Element copy();
    Element copyWithRefs();
    int size();
    void clearAttributes();
    void clearAttributesLocal();
    Element get(int i);
    Element set(int i, Element newElement);
    void forEachElement(java.util.function.Consumer<? super Element> action);
    default void trimToSize() {        forEachElement(Element::trimToSize);    }    void setParent(Element parent);
    void replaceBy(Element other);
    boolean structuralEquals(Element elem);
    default List<Integer> pathTo(Element  elem) {
        List<Integer> path = new ArrayList<>();
        while (elem != this) {
            if (elem == null) {
                throw new RuntimeException("Element " + elem + " is not a parent of " + this);
            }
            Element parent = elem.getParent();
            for (int i = 0; i < parent.size(); i++) {
                if (parent.get(i) == elem) {
                    path.add(i);
                    break;
                }
            }
            elem = parent;
        }
        Collections.reverse(path);
        return path;
    }

    default Element followPath(Iterable<Integer> path) {
        Element elem = this;
        for (Integer i : path) {
            elem = elem.get(i);
        }
        return elem;
    }
    <T> T match(Matcher<T> s);
    void match(MatcherVoid s);
    public interface Matcher<T> {
        T case_SwitchCases(SwitchCases switchCases);
        T case_ModAbstract(ModAbstract modAbstract);
        T case_ExprInstanceOf(ExprInstanceOf exprInstanceOf);
        T case_FuncDef(FuncDef funcDef);
        T case_ExprMemberVarDot(ExprMemberVarDot exprMemberVarDot);
        T case_ModOverride(ModOverride modOverride);
        T case_WImports(WImports wImports);
        T case_Arguments(Arguments arguments);
        T case_FuncDefs(FuncDefs funcDefs);
        T case_IdentifierWithTypeArgs(IdentifierWithTypeArgs identifierWithTypeArgs);
        T case_ExprStatementsBlock(ExprStatementsBlock exprStatementsBlock);
        T case_ClassDef(ClassDef classDef);
        T case_StmtReturn(StmtReturn stmtReturn);
        T case_NoExpr(NoExpr noExpr);
        T case_JassToplevelDeclarations(JassToplevelDeclarations jassToplevelDeclarations);
        T case_ExprUnary(ExprUnary exprUnary);
        T case_ExprIncomplete(ExprIncomplete exprIncomplete);
        T case_ModuleInstanciation(ModuleInstanciation moduleInstanciation);
        T case_ExprBoolVal(ExprBoolVal exprBoolVal);
        T case_EndFunctionStatement(EndFunctionStatement endFunctionStatement);
        T case_WStatements(WStatements wStatements);
        T case_VisibilityProtected(VisibilityProtected visibilityProtected);
        T case_ExprMemberVarDotDot(ExprMemberVarDotDot exprMemberVarDotDot);
        T case_ExprRealVal(ExprRealVal exprRealVal);
        T case_TypeExprThis(TypeExprThis typeExprThis);
        T case_WShortParameters(WShortParameters wShortParameters);
        T case_GlobalVarDefs(GlobalVarDefs globalVarDefs);
        T case_NoSuperConstructorCall(NoSuperConstructorCall noSuperConstructorCall);
        T case_ModVararg(ModVararg modVararg);
        T case_TopLevelDeclarations(TopLevelDeclarations topLevelDeclarations);
        T case_SwitchStmt(SwitchStmt switchStmt);
        T case_WParameters(WParameters wParameters);
        T case_ExprStringVal(ExprStringVal exprStringVal);
        T case_ExprFuncRef(ExprFuncRef exprFuncRef);
        T case_TypeExprList(TypeExprList typeExprList);
        T case_TypeExprArray(TypeExprArray typeExprArray);
        T case_WEntities(WEntities wEntities);
        T case_ExprNull(ExprNull exprNull);
        T case_ExprBinary(ExprBinary exprBinary);
        T case_InterfaceDef(InterfaceDef interfaceDef);
        T case_EnumMember(EnumMember enumMember);
        T case_WPackage(WPackage wPackage);
        T case_ExprMemberArrayVarDot(ExprMemberArrayVarDot exprMemberArrayVarDot);
        T case_SwitchDefaultCaseStatements(SwitchDefaultCaseStatements switchDefaultCaseStatements);
        T case_StmtForRangeUp(StmtForRangeUp stmtForRangeUp);
        T case_WParameter(WParameter wParameter);
        T case_ExprList(ExprList exprList);
        T case_TupleDef(TupleDef tupleDef);
        T case_WShortParameter(WShortParameter wShortParameter);
        T case_VisibilityPublicread(VisibilityPublicread visibilityPublicread);
        T case_ExprVarArrayAccess(ExprVarArrayAccess exprVarArrayAccess);
        T case_OnDestroyDef(OnDestroyDef onDestroyDef);
        T case_VisibilityPublic(VisibilityPublic visibilityPublic);
        T case_ExprMemberMethodDot(ExprMemberMethodDot exprMemberMethodDot);
        T case_TypeParamDefs(TypeParamDefs typeParamDefs);
        T case_IdentifierWithTypeParamDefs(IdentifierWithTypeParamDefs identifierWithTypeParamDefs);
        T case_ModuleUse(ModuleUse moduleUse);
        T case_LocalVarDef(LocalVarDef localVarDef);
        T case_EnumMembers(EnumMembers enumMembers);
        T case_StmtSet(StmtSet stmtSet);
        T case_NoDefaultCase(NoDefaultCase noDefaultCase);
        T case_StmtForIn(StmtForIn stmtForIn);
        T case_ExprMemberArrayVarDotDot(ExprMemberArrayVarDotDot exprMemberArrayVarDotDot);
        T case_Identifier(Identifier identifier);
        T case_Modifiers(Modifiers modifiers);
        T case_ExprIntVal(ExprIntVal exprIntVal);
        T case_StartFunctionStatement(StartFunctionStatement startFunctionStatement);
        T case_ModuleInstanciations(ModuleInstanciations moduleInstanciations);
        T case_ArraySizes(ArraySizes arraySizes);
        T case_TypeExprResolved(TypeExprResolved typeExprResolved);
        T case_ArrayInitializer(ArrayInitializer arrayInitializer);
        T case_NoTypeExpr(NoTypeExpr noTypeExpr);
        T case_StmtSkip(StmtSkip stmtSkip);
        T case_StmtErr(StmtErr stmtErr);
        T case_EnumDef(EnumDef enumDef);
        T case_NativeType(NativeType nativeType);
        T case_CompilationUnit(CompilationUnit compilationUnit);
        T case_Indexes(Indexes indexes);
        T case_ConstructorDef(ConstructorDef constructorDef);
        T case_Annotation(Annotation annotation);
        T case_WImport(WImport wImport);
        T case_VisibilityDefault(VisibilityDefault visibilityDefault);
        T case_SwitchCase(SwitchCase switchCase);
        T case_WurstDoc(WurstDoc wurstDoc);
        T case_GlobalVarDef(GlobalVarDef globalVarDef);
        T case_NativeFunc(NativeFunc nativeFunc);
        T case_ConstructorDefs(ConstructorDefs constructorDefs);
        T case_ExprFunctionCall(ExprFunctionCall exprFunctionCall);
        T case_NoTypeParamConstraints(NoTypeParamConstraints noTypeParamConstraints);
        T case_WPackages(WPackages wPackages);
        T case_ExprCast(ExprCast exprCast);
        T case_ModuleUses(ModuleUses moduleUses);
        T case_ExprEmpty(ExprEmpty exprEmpty);
        T case_ExprIfElse(ExprIfElse exprIfElse);
        T case_JassGlobalBlock(JassGlobalBlock jassGlobalBlock);
        T case_ExprNewObject(ExprNewObject exprNewObject);
        T case_InitBlock(InitBlock initBlock);
        T case_ExprDestroy(ExprDestroy exprDestroy);
        T case_StmtForRangeDown(StmtForRangeDown stmtForRangeDown);
        T case_TypeExprSimple(TypeExprSimple typeExprSimple);
        T case_StmtLoop(StmtLoop stmtLoop);
        T case_StmtIf(StmtIf stmtIf);
        T case_SomeSuperConstructorCall(SomeSuperConstructorCall someSuperConstructorCall);
        T case_ExprThis(ExprThis exprThis);
        T case_TypeParamDef(TypeParamDef typeParamDef);
        T case_WBlock(WBlock wBlock);
        T case_ExprMemberMethodDotDot(ExprMemberMethodDotDot exprMemberMethodDotDot);
        T case_ModStatic(ModStatic modStatic);
        T case_ExprSuper(ExprSuper exprSuper);
        T case_StmtForFrom(StmtForFrom stmtForFrom);
        T case_VisibilityPrivate(VisibilityPrivate visibilityPrivate);
        T case_ExprVarAccess(ExprVarAccess exprVarAccess);
        T case_StmtExitwhen(StmtExitwhen stmtExitwhen);
        T case_ClassDefs(ClassDefs classDefs);
        T case_WurstModel(WurstModel wurstModel);
        T case_ExprClosure(ExprClosure exprClosure);
        T case_ModuleDef(ModuleDef moduleDef);
        T case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef);
        T case_StmtWhile(StmtWhile stmtWhile);
        T case_ModConstant(ModConstant modConstant);
        T case_ExprTypeId(ExprTypeId exprTypeId);
    }

    public interface MatcherVoid {
        void case_SwitchCases(SwitchCases switchCases);
        void case_ModAbstract(ModAbstract modAbstract);
        void case_ExprInstanceOf(ExprInstanceOf exprInstanceOf);
        void case_FuncDef(FuncDef funcDef);
        void case_ExprMemberVarDot(ExprMemberVarDot exprMemberVarDot);
        void case_ModOverride(ModOverride modOverride);
        void case_WImports(WImports wImports);
        void case_Arguments(Arguments arguments);
        void case_FuncDefs(FuncDefs funcDefs);
        void case_IdentifierWithTypeArgs(IdentifierWithTypeArgs identifierWithTypeArgs);
        void case_ExprStatementsBlock(ExprStatementsBlock exprStatementsBlock);
        void case_ClassDef(ClassDef classDef);
        void case_StmtReturn(StmtReturn stmtReturn);
        void case_NoExpr(NoExpr noExpr);
        void case_JassToplevelDeclarations(JassToplevelDeclarations jassToplevelDeclarations);
        void case_ExprUnary(ExprUnary exprUnary);
        void case_ExprIncomplete(ExprIncomplete exprIncomplete);
        void case_ModuleInstanciation(ModuleInstanciation moduleInstanciation);
        void case_ExprBoolVal(ExprBoolVal exprBoolVal);
        void case_EndFunctionStatement(EndFunctionStatement endFunctionStatement);
        void case_WStatements(WStatements wStatements);
        void case_VisibilityProtected(VisibilityProtected visibilityProtected);
        void case_ExprMemberVarDotDot(ExprMemberVarDotDot exprMemberVarDotDot);
        void case_ExprRealVal(ExprRealVal exprRealVal);
        void case_TypeExprThis(TypeExprThis typeExprThis);
        void case_WShortParameters(WShortParameters wShortParameters);
        void case_GlobalVarDefs(GlobalVarDefs globalVarDefs);
        void case_NoSuperConstructorCall(NoSuperConstructorCall noSuperConstructorCall);
        void case_ModVararg(ModVararg modVararg);
        void case_TopLevelDeclarations(TopLevelDeclarations topLevelDeclarations);
        void case_SwitchStmt(SwitchStmt switchStmt);
        void case_WParameters(WParameters wParameters);
        void case_ExprStringVal(ExprStringVal exprStringVal);
        void case_ExprFuncRef(ExprFuncRef exprFuncRef);
        void case_TypeExprList(TypeExprList typeExprList);
        void case_TypeExprArray(TypeExprArray typeExprArray);
        void case_WEntities(WEntities wEntities);
        void case_ExprNull(ExprNull exprNull);
        void case_ExprBinary(ExprBinary exprBinary);
        void case_InterfaceDef(InterfaceDef interfaceDef);
        void case_EnumMember(EnumMember enumMember);
        void case_WPackage(WPackage wPackage);
        void case_ExprMemberArrayVarDot(ExprMemberArrayVarDot exprMemberArrayVarDot);
        void case_SwitchDefaultCaseStatements(SwitchDefaultCaseStatements switchDefaultCaseStatements);
        void case_StmtForRangeUp(StmtForRangeUp stmtForRangeUp);
        void case_WParameter(WParameter wParameter);
        void case_ExprList(ExprList exprList);
        void case_TupleDef(TupleDef tupleDef);
        void case_WShortParameter(WShortParameter wShortParameter);
        void case_VisibilityPublicread(VisibilityPublicread visibilityPublicread);
        void case_ExprVarArrayAccess(ExprVarArrayAccess exprVarArrayAccess);
        void case_OnDestroyDef(OnDestroyDef onDestroyDef);
        void case_VisibilityPublic(VisibilityPublic visibilityPublic);
        void case_ExprMemberMethodDot(ExprMemberMethodDot exprMemberMethodDot);
        void case_TypeParamDefs(TypeParamDefs typeParamDefs);
        void case_IdentifierWithTypeParamDefs(IdentifierWithTypeParamDefs identifierWithTypeParamDefs);
        void case_ModuleUse(ModuleUse moduleUse);
        void case_LocalVarDef(LocalVarDef localVarDef);
        void case_EnumMembers(EnumMembers enumMembers);
        void case_StmtSet(StmtSet stmtSet);
        void case_NoDefaultCase(NoDefaultCase noDefaultCase);
        void case_StmtForIn(StmtForIn stmtForIn);
        void case_ExprMemberArrayVarDotDot(ExprMemberArrayVarDotDot exprMemberArrayVarDotDot);
        void case_Identifier(Identifier identifier);
        void case_Modifiers(Modifiers modifiers);
        void case_ExprIntVal(ExprIntVal exprIntVal);
        void case_StartFunctionStatement(StartFunctionStatement startFunctionStatement);
        void case_ModuleInstanciations(ModuleInstanciations moduleInstanciations);
        void case_ArraySizes(ArraySizes arraySizes);
        void case_TypeExprResolved(TypeExprResolved typeExprResolved);
        void case_ArrayInitializer(ArrayInitializer arrayInitializer);
        void case_NoTypeExpr(NoTypeExpr noTypeExpr);
        void case_StmtSkip(StmtSkip stmtSkip);
        void case_StmtErr(StmtErr stmtErr);
        void case_EnumDef(EnumDef enumDef);
        void case_NativeType(NativeType nativeType);
        void case_CompilationUnit(CompilationUnit compilationUnit);
        void case_Indexes(Indexes indexes);
        void case_ConstructorDef(ConstructorDef constructorDef);
        void case_Annotation(Annotation annotation);
        void case_WImport(WImport wImport);
        void case_VisibilityDefault(VisibilityDefault visibilityDefault);
        void case_SwitchCase(SwitchCase switchCase);
        void case_WurstDoc(WurstDoc wurstDoc);
        void case_GlobalVarDef(GlobalVarDef globalVarDef);
        void case_NativeFunc(NativeFunc nativeFunc);
        void case_ConstructorDefs(ConstructorDefs constructorDefs);
        void case_ExprFunctionCall(ExprFunctionCall exprFunctionCall);
        void case_NoTypeParamConstraints(NoTypeParamConstraints noTypeParamConstraints);
        void case_WPackages(WPackages wPackages);
        void case_ExprCast(ExprCast exprCast);
        void case_ModuleUses(ModuleUses moduleUses);
        void case_ExprEmpty(ExprEmpty exprEmpty);
        void case_ExprIfElse(ExprIfElse exprIfElse);
        void case_JassGlobalBlock(JassGlobalBlock jassGlobalBlock);
        void case_ExprNewObject(ExprNewObject exprNewObject);
        void case_InitBlock(InitBlock initBlock);
        void case_ExprDestroy(ExprDestroy exprDestroy);
        void case_StmtForRangeDown(StmtForRangeDown stmtForRangeDown);
        void case_TypeExprSimple(TypeExprSimple typeExprSimple);
        void case_StmtLoop(StmtLoop stmtLoop);
        void case_StmtIf(StmtIf stmtIf);
        void case_SomeSuperConstructorCall(SomeSuperConstructorCall someSuperConstructorCall);
        void case_ExprThis(ExprThis exprThis);
        void case_TypeParamDef(TypeParamDef typeParamDef);
        void case_WBlock(WBlock wBlock);
        void case_ExprMemberMethodDotDot(ExprMemberMethodDotDot exprMemberMethodDotDot);
        void case_ModStatic(ModStatic modStatic);
        void case_ExprSuper(ExprSuper exprSuper);
        void case_StmtForFrom(StmtForFrom stmtForFrom);
        void case_VisibilityPrivate(VisibilityPrivate visibilityPrivate);
        void case_ExprVarAccess(ExprVarAccess exprVarAccess);
        void case_StmtExitwhen(StmtExitwhen stmtExitwhen);
        void case_ClassDefs(ClassDefs classDefs);
        void case_WurstModel(WurstModel wurstModel);
        void case_ExprClosure(ExprClosure exprClosure);
        void case_ModuleDef(ModuleDef moduleDef);
        void case_ExtensionFuncDef(ExtensionFuncDef extensionFuncDef);
        void case_StmtWhile(StmtWhile stmtWhile);
        void case_ModConstant(ModConstant modConstant);
        void case_ExprTypeId(ExprTypeId exprTypeId);
    }

    public abstract void accept(Visitor v);
    public interface Visitor {
        void visit(Identifier identifier);
        void visit(CompilationUnit compilationUnit);
        void visit(WPackage wPackage);
        void visit(WImport wImport);
        void visit(ExtensionFuncDef extensionFuncDef);
        void visit(InitBlock initBlock);
        void visit(NativeFunc nativeFunc);
        void visit(ModuleDef moduleDef);
        void visit(TypeExprSimple typeExprSimple);
        void visit(TypeExprArray typeExprArray);
        void visit(TypeExprThis typeExprThis);
        void visit(TypeExprResolved typeExprResolved);
        void visit(NoTypeExpr noTypeExpr);
        void visit(NoExpr noExpr);
        void visit(NativeType nativeType);
        void visit(ClassDef classDef);
        void visit(InterfaceDef interfaceDef);
        void visit(TupleDef tupleDef);
        void visit(EnumDef enumDef);
        void visit(SwitchCase switchCase);
        void visit(SwitchDefaultCaseStatements switchDefaultCaseStatements);
        void visit(NoDefaultCase noDefaultCase);
        void visit(ConstructorDef constructorDef);
        void visit(OnDestroyDef onDestroyDef);
        void visit(ModuleUse moduleUse);
        void visit(ModuleInstanciation moduleInstanciation);
        void visit(EnumMember enumMember);
        void visit(SomeSuperConstructorCall someSuperConstructorCall);
        void visit(NoSuperConstructorCall noSuperConstructorCall);
        void visit(GlobalVarDef globalVarDef);
        void visit(LocalVarDef localVarDef);
        void visit(ArrayInitializer arrayInitializer);
        void visit(FuncDef funcDef);
        void visit(TypeParamDef typeParamDef);
        void visit(NoTypeParamConstraints noTypeParamConstraints);
        void visit(WParameter wParameter);
        void visit(WShortParameter wShortParameter);
        void visit(EndFunctionStatement endFunctionStatement);
        void visit(StartFunctionStatement startFunctionStatement);
        void visit(StmtSkip stmtSkip);
        void visit(StmtSet stmtSet);
        void visit(StmtErr stmtErr);
        void visit(StmtReturn stmtReturn);
        void visit(StmtExitwhen stmtExitwhen);
        void visit(StmtIf stmtIf);
        void visit(SwitchStmt switchStmt);
        void visit(WBlock wBlock);
        void visit(StmtWhile stmtWhile);
        void visit(StmtLoop stmtLoop);
        void visit(StmtForIn stmtForIn);
        void visit(StmtForFrom stmtForFrom);
        void visit(StmtForRangeUp stmtForRangeUp);
        void visit(StmtForRangeDown stmtForRangeDown);
        void visit(ExprBinary exprBinary);
        void visit(ExprUnary exprUnary);
        void visit(ExprFunctionCall exprFunctionCall);
        void visit(ExprNewObject exprNewObject);
        void visit(ExprCast exprCast);
        void visit(ExprInstanceOf exprInstanceOf);
        void visit(ExprClosure exprClosure);
        void visit(ExprIncomplete exprIncomplete);
        void visit(ExprStatementsBlock exprStatementsBlock);
        void visit(ExprDestroy exprDestroy);
        void visit(ExprIfElse exprIfElse);
        void visit(ExprTypeId exprTypeId);
        void visit(ExprMemberVarDot exprMemberVarDot);
        void visit(ExprMemberVarDotDot exprMemberVarDotDot);
        void visit(ExprMemberArrayVarDot exprMemberArrayVarDot);
        void visit(ExprMemberArrayVarDotDot exprMemberArrayVarDotDot);
        void visit(ExprMemberMethodDot exprMemberMethodDot);
        void visit(ExprMemberMethodDotDot exprMemberMethodDotDot);
        void visit(ExprIntVal exprIntVal);
        void visit(ExprRealVal exprRealVal);
        void visit(ExprStringVal exprStringVal);
        void visit(ExprBoolVal exprBoolVal);
        void visit(ExprFuncRef exprFuncRef);
        void visit(ExprVarAccess exprVarAccess);
        void visit(ExprVarArrayAccess exprVarArrayAccess);
        void visit(ExprThis exprThis);
        void visit(ExprNull exprNull);
        void visit(ExprSuper exprSuper);
        void visit(ExprEmpty exprEmpty);
        void visit(IdentifierWithTypeArgs identifierWithTypeArgs);
        void visit(IdentifierWithTypeParamDefs identifierWithTypeParamDefs);
        void visit(VisibilityPublic visibilityPublic);
        void visit(VisibilityPrivate visibilityPrivate);
        void visit(VisibilityPublicread visibilityPublicread);
        void visit(VisibilityProtected visibilityProtected);
        void visit(VisibilityDefault visibilityDefault);
        void visit(Annotation annotation);
        void visit(ModStatic modStatic);
        void visit(ModOverride modOverride);
        void visit(ModAbstract modAbstract);
        void visit(ModConstant modConstant);
        void visit(WurstDoc wurstDoc);
        void visit(ModVararg modVararg);
        void visit(WurstModel wurstModel);
        void visit(JassToplevelDeclarations jassToplevelDeclarations);
        void visit(WPackages wPackages);
        void visit(TopLevelDeclarations topLevelDeclarations);
        void visit(WImports wImports);
        void visit(WEntities wEntities);
        void visit(ClassDefs classDefs);
        void visit(EnumMembers enumMembers);
        void visit(FuncDefs funcDefs);
        void visit(GlobalVarDefs globalVarDefs);
        void visit(ConstructorDefs constructorDefs);
        void visit(ModuleInstanciations moduleInstanciations);
        void visit(ModuleUses moduleUses);
        void visit(TypeExprList typeExprList);
        void visit(SwitchCases switchCases);
        void visit(ArraySizes arraySizes);
        void visit(TypeParamDefs typeParamDefs);
        void visit(WParameters wParameters);
        void visit(WShortParameters wShortParameters);
        void visit(WStatements wStatements);
        void visit(Indexes indexes);
        void visit(Arguments arguments);
        void visit(ExprList exprList);
        void visit(Modifiers modifiers);
        void visit(JassGlobalBlock jassGlobalBlock);
    }
    public static abstract class DefaultVisitor implements Visitor {
        @Override public void visit(Identifier identifier) {
     }
        @Override public void visit(CompilationUnit compilationUnit) {
          compilationUnit.getJassDecls().accept(this);
          compilationUnit.getPackages().accept(this);
     }
        @Override public void visit(WPackage wPackage) {
          wPackage.getModifiers().accept(this);
          wPackage.getNameId().accept(this);
          wPackage.getImports().accept(this);
          wPackage.getElements().accept(this);
     }
        @Override public void visit(WImport wImport) {
          wImport.getPackagenameId().accept(this);
     }
        @Override public void visit(ExtensionFuncDef extensionFuncDef) {
          extensionFuncDef.getModifiers().accept(this);
          extensionFuncDef.getExtendedType().accept(this);
          extensionFuncDef.getNameId().accept(this);
          extensionFuncDef.getTypeParameters().accept(this);
          extensionFuncDef.getParameters().accept(this);
          extensionFuncDef.getReturnTyp().accept(this);
          extensionFuncDef.getBody().accept(this);
     }
        @Override public void visit(InitBlock initBlock) {
          initBlock.getBody().accept(this);
     }
        @Override public void visit(NativeFunc nativeFunc) {
          nativeFunc.getModifiers().accept(this);
          nativeFunc.getNameId().accept(this);
          nativeFunc.getParameters().accept(this);
          nativeFunc.getReturnTyp().accept(this);
     }
        @Override public void visit(ModuleDef moduleDef) {
          moduleDef.getModifiers().accept(this);
          moduleDef.getNameId().accept(this);
          moduleDef.getTypeParameters().accept(this);
          moduleDef.getInnerClasses().accept(this);
          moduleDef.getMethods().accept(this);
          moduleDef.getVars().accept(this);
          moduleDef.getConstructors().accept(this);
          moduleDef.getP_moduleInstanciations().accept(this);
          moduleDef.getModuleUses().accept(this);
          moduleDef.getOnDestroy().accept(this);
     }
        @Override public void visit(TypeExprSimple typeExprSimple) {
          typeExprSimple.getScopeType().accept(this);
          typeExprSimple.getTypeArgs().accept(this);
     }
        @Override public void visit(TypeExprArray typeExprArray) {
          typeExprArray.getBase().accept(this);
          typeExprArray.getArraySize().accept(this);
     }
        @Override public void visit(TypeExprThis typeExprThis) {
          typeExprThis.getScopeType().accept(this);
     }
        @Override public void visit(TypeExprResolved typeExprResolved) {
     }
        @Override public void visit(NoTypeExpr noTypeExpr) {
     }
        @Override public void visit(NoExpr noExpr) {
     }
        @Override public void visit(NativeType nativeType) {
          nativeType.getModifiers().accept(this);
          nativeType.getNameId().accept(this);
          nativeType.getOptTyp().accept(this);
     }
        @Override public void visit(ClassDef classDef) {
          classDef.getModifiers().accept(this);
          classDef.getNameId().accept(this);
          classDef.getTypeParameters().accept(this);
          classDef.getExtendedClass().accept(this);
          classDef.getImplementsList().accept(this);
          classDef.getInnerClasses().accept(this);
          classDef.getMethods().accept(this);
          classDef.getVars().accept(this);
          classDef.getConstructors().accept(this);
          classDef.getP_moduleInstanciations().accept(this);
          classDef.getModuleUses().accept(this);
          classDef.getOnDestroy().accept(this);
     }
        @Override public void visit(InterfaceDef interfaceDef) {
          interfaceDef.getModifiers().accept(this);
          interfaceDef.getNameId().accept(this);
          interfaceDef.getTypeParameters().accept(this);
          interfaceDef.getExtendsList().accept(this);
          interfaceDef.getMethods().accept(this);
          interfaceDef.getVars().accept(this);
          interfaceDef.getConstructors().accept(this);
          interfaceDef.getModuleInstanciations().accept(this);
          interfaceDef.getModuleUses().accept(this);
          interfaceDef.getOnDestroy().accept(this);
     }
        @Override public void visit(TupleDef tupleDef) {
          tupleDef.getModifiers().accept(this);
          tupleDef.getNameId().accept(this);
          tupleDef.getParameters().accept(this);
          tupleDef.getReturnTyp().accept(this);
     }
        @Override public void visit(EnumDef enumDef) {
          enumDef.getModifiers().accept(this);
          enumDef.getNameId().accept(this);
          enumDef.getMembers().accept(this);
     }
        @Override public void visit(SwitchCase switchCase) {
          switchCase.getExpressions().accept(this);
          switchCase.getStmts().accept(this);
     }
        @Override public void visit(SwitchDefaultCaseStatements switchDefaultCaseStatements) {
          switchDefaultCaseStatements.getStmts().accept(this);
     }
        @Override public void visit(NoDefaultCase noDefaultCase) {
     }
        @Override public void visit(ConstructorDef constructorDef) {
          constructorDef.getModifiers().accept(this);
          constructorDef.getParameters().accept(this);
          constructorDef.getSuperConstructorCall().accept(this);
          constructorDef.getBody().accept(this);
     }
        @Override public void visit(OnDestroyDef onDestroyDef) {
          onDestroyDef.getBody().accept(this);
     }
        @Override public void visit(ModuleUse moduleUse) {
          moduleUse.getModuleNameId().accept(this);
          moduleUse.getTypeArgs().accept(this);
     }
        @Override public void visit(ModuleInstanciation moduleInstanciation) {
          moduleInstanciation.getModifiers().accept(this);
          moduleInstanciation.getNameId().accept(this);
          moduleInstanciation.getInnerClasses().accept(this);
          moduleInstanciation.getMethods().accept(this);
          moduleInstanciation.getVars().accept(this);
          moduleInstanciation.getConstructors().accept(this);
          moduleInstanciation.getP_moduleInstanciations().accept(this);
          moduleInstanciation.getModuleUses().accept(this);
          moduleInstanciation.getOnDestroy().accept(this);
     }
        @Override public void visit(EnumMember enumMember) {
          enumMember.getModifiers().accept(this);
          enumMember.getNameId().accept(this);
     }
        @Override public void visit(SomeSuperConstructorCall someSuperConstructorCall) {
          someSuperConstructorCall.getSuperArgs().accept(this);
     }
        @Override public void visit(NoSuperConstructorCall noSuperConstructorCall) {
     }
        @Override public void visit(GlobalVarDef globalVarDef) {
          globalVarDef.getModifiers().accept(this);
          globalVarDef.getOptTyp().accept(this);
          globalVarDef.getNameId().accept(this);
          globalVarDef.getInitialExpr().accept(this);
     }
        @Override public void visit(LocalVarDef localVarDef) {
          localVarDef.getModifiers().accept(this);
          localVarDef.getOptTyp().accept(this);
          localVarDef.getNameId().accept(this);
          localVarDef.getInitialExpr().accept(this);
     }
        @Override public void visit(ArrayInitializer arrayInitializer) {
          arrayInitializer.getValues().accept(this);
     }
        @Override public void visit(FuncDef funcDef) {
          funcDef.getModifiers().accept(this);
          funcDef.getNameId().accept(this);
          funcDef.getTypeParameters().accept(this);
          funcDef.getParameters().accept(this);
          funcDef.getReturnTyp().accept(this);
          funcDef.getBody().accept(this);
     }
        @Override public void visit(TypeParamDef typeParamDef) {
          typeParamDef.getModifiers().accept(this);
          typeParamDef.getNameId().accept(this);
          typeParamDef.getTypeParamConstraints().accept(this);
     }
        @Override public void visit(NoTypeParamConstraints noTypeParamConstraints) {
     }
        @Override public void visit(WParameter wParameter) {
          wParameter.getModifiers().accept(this);
          wParameter.getTyp().accept(this);
          wParameter.getNameId().accept(this);
     }
        @Override public void visit(WShortParameter wShortParameter) {
          wShortParameter.getModifiers().accept(this);
          wShortParameter.getTypOpt().accept(this);
          wShortParameter.getNameId().accept(this);
     }
        @Override public void visit(EndFunctionStatement endFunctionStatement) {
     }
        @Override public void visit(StartFunctionStatement startFunctionStatement) {
     }
        @Override public void visit(StmtSkip stmtSkip) {
     }
        @Override public void visit(StmtSet stmtSet) {
          stmtSet.getUpdatedExpr().accept(this);
          stmtSet.getRight().accept(this);
     }
        @Override public void visit(StmtErr stmtErr) {
     }
        @Override public void visit(StmtReturn stmtReturn) {
          stmtReturn.getReturnedObj().accept(this);
     }
        @Override public void visit(StmtExitwhen stmtExitwhen) {
          stmtExitwhen.getCond().accept(this);
     }
        @Override public void visit(StmtIf stmtIf) {
          stmtIf.getCond().accept(this);
          stmtIf.getThenBlock().accept(this);
          stmtIf.getElseBlock().accept(this);
     }
        @Override public void visit(SwitchStmt switchStmt) {
          switchStmt.getExpr().accept(this);
          switchStmt.getCases().accept(this);
          switchStmt.getSwitchDefault().accept(this);
     }
        @Override public void visit(WBlock wBlock) {
          wBlock.getBody().accept(this);
     }
        @Override public void visit(StmtWhile stmtWhile) {
          stmtWhile.getCond().accept(this);
          stmtWhile.getBody().accept(this);
     }
        @Override public void visit(StmtLoop stmtLoop) {
          stmtLoop.getBody().accept(this);
     }
        @Override public void visit(StmtForIn stmtForIn) {
          stmtForIn.getLoopVar().accept(this);
          stmtForIn.getIn().accept(this);
          stmtForIn.getBody().accept(this);
     }
        @Override public void visit(StmtForFrom stmtForFrom) {
          stmtForFrom.getLoopVar().accept(this);
          stmtForFrom.getIn().accept(this);
          stmtForFrom.getBody().accept(this);
     }
        @Override public void visit(StmtForRangeUp stmtForRangeUp) {
          stmtForRangeUp.getLoopVar().accept(this);
          stmtForRangeUp.getTo().accept(this);
          stmtForRangeUp.getStep().accept(this);
          stmtForRangeUp.getBody().accept(this);
     }
        @Override public void visit(StmtForRangeDown stmtForRangeDown) {
          stmtForRangeDown.getLoopVar().accept(this);
          stmtForRangeDown.getTo().accept(this);
          stmtForRangeDown.getStep().accept(this);
          stmtForRangeDown.getBody().accept(this);
     }
        @Override public void visit(ExprBinary exprBinary) {
          exprBinary.getLeft().accept(this);
          exprBinary.getRight().accept(this);
     }
        @Override public void visit(ExprUnary exprUnary) {
          exprUnary.getRight().accept(this);
     }
        @Override public void visit(ExprFunctionCall exprFunctionCall) {
          exprFunctionCall.getFuncNameId().accept(this);
          exprFunctionCall.getTypeArgs().accept(this);
          exprFunctionCall.getArgs().accept(this);
     }
        @Override public void visit(ExprNewObject exprNewObject) {
          exprNewObject.getTypeNameId().accept(this);
          exprNewObject.getTypeArgs().accept(this);
          exprNewObject.getArgs().accept(this);
     }
        @Override public void visit(ExprCast exprCast) {
          exprCast.getTyp().accept(this);
          exprCast.getExpr().accept(this);
     }
        @Override public void visit(ExprInstanceOf exprInstanceOf) {
          exprInstanceOf.getTyp().accept(this);
          exprInstanceOf.getExpr().accept(this);
     }
        @Override public void visit(ExprClosure exprClosure) {
          exprClosure.getShortParameters().accept(this);
          exprClosure.getImplementation().accept(this);
     }
        @Override public void visit(ExprIncomplete exprIncomplete) {
     }
        @Override public void visit(ExprStatementsBlock exprStatementsBlock) {
          exprStatementsBlock.getBody().accept(this);
     }
        @Override public void visit(ExprDestroy exprDestroy) {
          exprDestroy.getDestroyedObj().accept(this);
     }
        @Override public void visit(ExprIfElse exprIfElse) {
          exprIfElse.getCond().accept(this);
          exprIfElse.getIfTrue().accept(this);
          exprIfElse.getIfFalse().accept(this);
     }
        @Override public void visit(ExprTypeId exprTypeId) {
          exprTypeId.getLeft().accept(this);
     }
        @Override public void visit(ExprMemberVarDot exprMemberVarDot) {
          exprMemberVarDot.getLeft().accept(this);
          exprMemberVarDot.getVarNameId().accept(this);
     }
        @Override public void visit(ExprMemberVarDotDot exprMemberVarDotDot) {
          exprMemberVarDotDot.getLeft().accept(this);
          exprMemberVarDotDot.getVarNameId().accept(this);
     }
        @Override public void visit(ExprMemberArrayVarDot exprMemberArrayVarDot) {
          exprMemberArrayVarDot.getLeft().accept(this);
          exprMemberArrayVarDot.getVarNameId().accept(this);
          exprMemberArrayVarDot.getIndexes().accept(this);
     }
        @Override public void visit(ExprMemberArrayVarDotDot exprMemberArrayVarDotDot) {
          exprMemberArrayVarDotDot.getLeft().accept(this);
          exprMemberArrayVarDotDot.getVarNameId().accept(this);
          exprMemberArrayVarDotDot.getIndexes().accept(this);
     }
        @Override public void visit(ExprMemberMethodDot exprMemberMethodDot) {
          exprMemberMethodDot.getLeft().accept(this);
          exprMemberMethodDot.getFuncNameId().accept(this);
          exprMemberMethodDot.getTypeArgs().accept(this);
          exprMemberMethodDot.getArgs().accept(this);
     }
        @Override public void visit(ExprMemberMethodDotDot exprMemberMethodDotDot) {
          exprMemberMethodDotDot.getLeft().accept(this);
          exprMemberMethodDotDot.getFuncNameId().accept(this);
          exprMemberMethodDotDot.getTypeArgs().accept(this);
          exprMemberMethodDotDot.getArgs().accept(this);
     }
        @Override public void visit(ExprIntVal exprIntVal) {
     }
        @Override public void visit(ExprRealVal exprRealVal) {
     }
        @Override public void visit(ExprStringVal exprStringVal) {
     }
        @Override public void visit(ExprBoolVal exprBoolVal) {
     }
        @Override public void visit(ExprFuncRef exprFuncRef) {
          exprFuncRef.getFuncNameId().accept(this);
     }
        @Override public void visit(ExprVarAccess exprVarAccess) {
          exprVarAccess.getVarNameId().accept(this);
     }
        @Override public void visit(ExprVarArrayAccess exprVarArrayAccess) {
          exprVarArrayAccess.getVarNameId().accept(this);
          exprVarArrayAccess.getIndexes().accept(this);
     }
        @Override public void visit(ExprThis exprThis) {
     }
        @Override public void visit(ExprNull exprNull) {
     }
        @Override public void visit(ExprSuper exprSuper) {
     }
        @Override public void visit(ExprEmpty exprEmpty) {
     }
        @Override public void visit(IdentifierWithTypeArgs identifierWithTypeArgs) {
          identifierWithTypeArgs.getNameId().accept(this);
     }
        @Override public void visit(IdentifierWithTypeParamDefs identifierWithTypeParamDefs) {
          identifierWithTypeParamDefs.getNameId().accept(this);
     }
        @Override public void visit(VisibilityPublic visibilityPublic) {
     }
        @Override public void visit(VisibilityPrivate visibilityPrivate) {
     }
        @Override public void visit(VisibilityPublicread visibilityPublicread) {
     }
        @Override public void visit(VisibilityProtected visibilityProtected) {
     }
        @Override public void visit(VisibilityDefault visibilityDefault) {
     }
        @Override public void visit(Annotation annotation) {
          annotation.getFuncNameId().accept(this);
          annotation.getArgs().accept(this);
     }
        @Override public void visit(ModStatic modStatic) {
     }
        @Override public void visit(ModOverride modOverride) {
     }
        @Override public void visit(ModAbstract modAbstract) {
     }
        @Override public void visit(ModConstant modConstant) {
     }
        @Override public void visit(WurstDoc wurstDoc) {
     }
        @Override public void visit(ModVararg modVararg) {
     }
        @Override public void visit(WurstModel wurstModel) {
          for (CompilationUnit i : wurstModel ) {
              i.accept(this);
          }
     }
        @Override public void visit(JassToplevelDeclarations jassToplevelDeclarations) {
          for (JassToplevelDeclaration i : jassToplevelDeclarations ) {
              i.accept(this);
          }
     }
        @Override public void visit(WPackages wPackages) {
          for (WPackage i : wPackages ) {
              i.accept(this);
          }
     }
        @Override public void visit(TopLevelDeclarations topLevelDeclarations) {
          for (TopLevelDeclaration i : topLevelDeclarations ) {
              i.accept(this);
          }
     }
        @Override public void visit(WImports wImports) {
          for (WImport i : wImports ) {
              i.accept(this);
          }
     }
        @Override public void visit(WEntities wEntities) {
          for (WEntity i : wEntities ) {
              i.accept(this);
          }
     }
        @Override public void visit(ClassDefs classDefs) {
          for (ClassDef i : classDefs ) {
              i.accept(this);
          }
     }
        @Override public void visit(EnumMembers enumMembers) {
          for (EnumMember i : enumMembers ) {
              i.accept(this);
          }
     }
        @Override public void visit(FuncDefs funcDefs) {
          for (FuncDef i : funcDefs ) {
              i.accept(this);
          }
     }
        @Override public void visit(GlobalVarDefs globalVarDefs) {
          for (GlobalVarDef i : globalVarDefs ) {
              i.accept(this);
          }
     }
        @Override public void visit(ConstructorDefs constructorDefs) {
          for (ConstructorDef i : constructorDefs ) {
              i.accept(this);
          }
     }
        @Override public void visit(ModuleInstanciations moduleInstanciations) {
          for (ModuleInstanciation i : moduleInstanciations ) {
              i.accept(this);
          }
     }
        @Override public void visit(ModuleUses moduleUses) {
          for (ModuleUse i : moduleUses ) {
              i.accept(this);
          }
     }
        @Override public void visit(TypeExprList typeExprList) {
          for (TypeExpr i : typeExprList ) {
              i.accept(this);
          }
     }
        @Override public void visit(SwitchCases switchCases) {
          for (SwitchCase i : switchCases ) {
              i.accept(this);
          }
     }
        @Override public void visit(ArraySizes arraySizes) {
          for (Expr i : arraySizes ) {
              i.accept(this);
          }
     }
        @Override public void visit(TypeParamDefs typeParamDefs) {
          for (TypeParamDef i : typeParamDefs ) {
              i.accept(this);
          }
     }
        @Override public void visit(WParameters wParameters) {
          for (WParameter i : wParameters ) {
              i.accept(this);
          }
     }
        @Override public void visit(WShortParameters wShortParameters) {
          for (WShortParameter i : wShortParameters ) {
              i.accept(this);
          }
     }
        @Override public void visit(WStatements wStatements) {
          for (WStatement i : wStatements ) {
              i.accept(this);
          }
     }
        @Override public void visit(Indexes indexes) {
          for (Expr i : indexes ) {
              i.accept(this);
          }
     }
        @Override public void visit(Arguments arguments) {
          for (Expr i : arguments ) {
              i.accept(this);
          }
     }
        @Override public void visit(ExprList exprList) {
          for (Expr i : exprList ) {
              i.accept(this);
          }
     }
        @Override public void visit(Modifiers modifiers) {
          for (Modifier i : modifiers ) {
              i.accept(this);
          }
     }
        @Override public void visit(JassGlobalBlock jassGlobalBlock) {
          for (GlobalVarDef i : jassGlobalBlock ) {
              i.accept(this);
          }
     }
    }
    /** */
    public abstract boolean attrIsDynamicContext();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable PackageOrGlobal attrNearestPackage();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable NamedScope attrNearestNamedScope();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable WScope attrNearestScope();
    /** */
    public abstract String attrPathDescription();
    /** */
    public abstract CompilationUnit attrCompilationUnit();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable ClassDef attrNearestClassDef();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable ClassOrInterface attrNearestClassOrInterface();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable ClassOrModule attrNearestClassOrModule();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable StructureDef attrNearestStructureDef();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable FunctionImplementation attrNearestFuncDef();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable ExprClosure attrNearestExprClosure();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable ExprStatementsBlock attrNearestExprStatementsBlock();
    /** "returns the element itself if it is a NameDef or returns the referenced NameDef if the elem is a reference or returns null otherwise "*/
    public abstract @org.eclipse.jdt.annotation.Nullable NameDef tryGetNameDef();
    /** */
    public abstract de.peeeq.wurstscript.parser.WPos attrSource();
    /** "returns the position where errors are marked"*/
    public abstract de.peeeq.wurstscript.parser.WPos attrErrorPos();
    /** */
    public abstract WurstModel getModel();
    /** */
    public abstract void addError(String msg);
    /** */
    public abstract void addWarning(String msg);
    /** */
    public abstract de.peeeq.wurstscript.attributes.ErrorHandler getErrorHandler();
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable TypeDef lookupType(String name, boolean showErrors);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.PackageLink lookupPackage(String name, boolean showErrors);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.NameLink lookupVar(String name, boolean showErrors);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.NameLink lookupVarNoConfig(String name, boolean showErrors);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.NameLink lookupMemberVar(de.peeeq.wurstscript.types.WurstType receiverType, String name, boolean showErrors);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<de.peeeq.wurstscript.attributes.names.FuncLink> lookupFuncs(String name, boolean showErrors);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<de.peeeq.wurstscript.attributes.names.FuncLink> lookupFuncsNoConfig(String name, boolean showErrors);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<de.peeeq.wurstscript.attributes.names.FuncLink> lookupMemberFuncs(de.peeeq.wurstscript.types.WurstType receiverType, String name, boolean showErrors);
    /** */
    public abstract @org.eclipse.jdt.annotation.Nullable TypeDef lookupType(String name);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.PackageLink lookupPackage(String name);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.NameLink lookupVar(String name);
    /** */
    public abstract de.peeeq.wurstscript.attributes.names.NameLink lookupMemberVar(de.peeeq.wurstscript.types.WurstType receiverType, String name);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<de.peeeq.wurstscript.attributes.names.FuncLink> lookupFuncs(String name);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<de.peeeq.wurstscript.attributes.names.FuncLink> lookupMemberFuncs(de.peeeq.wurstscript.types.WurstType receiverType, String name);
    /** */
    public abstract com.google.common.collect.ImmutableCollection<WPackage> attrUsedPackages();
    /** */
    public abstract String description();
    /** */
    public abstract String descriptionHtml();
    /** */
    public abstract boolean isSubtreeOf(Element other);
    /** */
    public abstract void prettyPrint(de.peeeq.wurstscript.attributes.prettyPrint.Spacer spacer, StringBuilder sb, int indent);
}

