/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.lua.translation;

import de.peeeq.datastructures.UnionFind;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.jassIm.JassImElementWithName;
import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaAst;
import de.peeeq.wurstscript.luaAst.LuaCallExpr;
import de.peeeq.wurstscript.luaAst.LuaCompilationUnit;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCallE;
import de.peeeq.wurstscript.luaAst.LuaExprNull;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaExprlist;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaLiteral;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaStatements;
import de.peeeq.wurstscript.luaAst.LuaTableConstructor;
import de.peeeq.wurstscript.luaAst.LuaTableField;
import de.peeeq.wurstscript.luaAst.LuaTableFields;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.GetAForB;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.lua.translation.ExprTranslation;
import de.peeeq.wurstscript.translation.lua.translation.LuaNatives;
import de.peeeq.wurstscript.translation.lua.translation.RemoveGarbage;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.Lazy;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LuaTranslator {
    final ImProg prog;
    final LuaCompilationUnit luaModel;
    private final Set<String> usedNames = new HashSet<String>(Arrays.asList("print", "tostring", "error", "and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"));
    List<ExprTranslation.TupleFunc> tupleEqualsFuncs = new ArrayList<ExprTranslation.TupleFunc>();
    List<ExprTranslation.TupleFunc> tupleCopyFuncs = new ArrayList<ExprTranslation.TupleFunc>();
    GetAForB<ImVar, LuaVariable> luaVar = new GetAForB<ImVar, LuaVariable>(){

        @Override
        public LuaVariable initFor(ImVar a) {
            String name = a.getName();
            if (!a.getIsBJ()) {
                name = LuaTranslator.this.uniqueName(name);
            }
            return LuaAst.LuaVariable(name, LuaAst.LuaNoExpr());
        }
    };
    GetAForB<ImFunction, LuaFunction> luaFunc = new GetAForB<ImFunction, LuaFunction>(){

        @Override
        public LuaFunction initFor(ImFunction a) {
            String name = a.getName();
            if (!(a.isExtern() || a.isBj() || a.isNative())) {
                name = LuaTranslator.this.uniqueName(name);
            }
            LuaFunction lf = LuaAst.LuaFunction(name, LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
            for (ImVar p : a.getParameters()) {
                LuaVariable pv = LuaTranslator.this.luaVar.getFor(p);
                lf.getParams().add(pv);
            }
            return lf;
        }
    };
    public GetAForB<ImMethod, LuaMethod> luaMethod = new GetAForB<ImMethod, LuaMethod>(){

        @Override
        public LuaMethod initFor(ImMethod a) {
            LuaExprVarAccess receiver = LuaAst.LuaExprVarAccess(LuaTranslator.this.luaClassVar.getFor(a.attrClass()));
            return LuaAst.LuaMethod(receiver, a.getName(), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
        }
    };
    GetAForB<ImClass, LuaVariable> luaClassVar = new GetAForB<ImClass, LuaVariable>(){

        @Override
        public LuaVariable initFor(ImClass a) {
            return LuaAst.LuaVariable(LuaTranslator.this.uniqueName(a.getName()), LuaAst.LuaNoExpr());
        }
    };
    GetAForB<ImClass, LuaVariable> luaClassMetaTableVar = new GetAForB<ImClass, LuaVariable>(){

        @Override
        public LuaVariable initFor(ImClass a) {
            return LuaAst.LuaVariable(LuaTranslator.this.uniqueName(a.getName() + "_mt"), LuaAst.LuaNoExpr());
        }
    };
    GetAForB<ImClass, LuaMethod> luaClassInitMethod = new GetAForB<ImClass, LuaMethod>(){

        @Override
        public LuaMethod initFor(ImClass a) {
            LuaExprVarAccess receiver = LuaAst.LuaExprVarAccess(LuaTranslator.this.luaClassVar.getFor(a));
            return LuaAst.LuaMethod(receiver, LuaTranslator.this.uniqueName("create"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
        }
    };
    LuaFunction arrayInitFunction = LuaAst.LuaFunction(this.uniqueName("defaultArray"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction stringConcatFunction = LuaAst.LuaFunction(this.uniqueName("stringConcat"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction toIndexFunction = LuaAst.LuaFunction(this.uniqueName("objectToIndex"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction fromIndexFunction = LuaAst.LuaFunction(this.uniqueName("objectFromIndex"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction instanceOfFunction = LuaAst.LuaFunction(this.uniqueName("isInstanceOf"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction ensureIntFunction = LuaAst.LuaFunction(this.uniqueName("intEnsure"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction ensureStrFunction = LuaAst.LuaFunction(this.uniqueName("stringEnsure"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction ensureBoolFunction = LuaAst.LuaFunction(this.uniqueName("boolEnsure"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    LuaFunction ensureRealFunction = LuaAst.LuaFunction(this.uniqueName("realEnsure"), LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(new LuaStatement[0]));
    private final Lazy<LuaFunction> errorFunc = Lazy.create(() -> this.getProg().getFunctions().stream().flatMap(f -> {
        WPackage p;
        FuncDef fd;
        Element trace = f.attrTrace();
        if (trace instanceof FuncDef && (fd = (FuncDef)trace).getName().equals("error") && fd.attrNearestPackage() instanceof WPackage && (p = (WPackage)fd.attrNearestPackage()).getName().equals("ErrorHandling")) {
            return Stream.of(this.luaFunc.getFor((ImFunction)f));
        }
        return Stream.empty();
    }).findFirst().orElse(null));
    private final ImTranslator imTr;

    private ImProg getProg() {
        return this.prog;
    }

    public LuaTranslator(ImProg prog, ImTranslator imTr) {
        this.prog = prog;
        this.imTr = imTr;
        this.luaModel = LuaAst.LuaCompilationUnit(new LuaStatement[0]);
    }

    protected String uniqueName(String name) {
        int i = 0;
        Object rname = name;
        while (this.usedNames.contains(rname)) {
            rname = name + ++i;
        }
        this.usedNames.add((String)rname);
        return rname;
    }

    public LuaCompilationUnit translate() {
        this.collectPredefinedNames();
        RemoveGarbage.removeGarbage(this.prog);
        this.prog.flatten(this.imTr);
        this.normalizeMethodNames();
        this.createArrayInitFunction();
        this.createStringConcatFunction();
        this.createInstanceOfFunction();
        this.createObjectIndexFunctions();
        this.createEnsureTypeFunctions();
        for (ImVar v : this.prog.getGlobals()) {
            this.translateGlobal(v);
        }
        for (ImClass c : this.prog.getClasses()) {
            LuaVariable classVar = this.luaClassVar.getFor(c);
            this.luaModel.add(classVar);
        }
        for (ImClass c : this.prog.getClasses()) {
            this.translateClass(c);
        }
        for (ImFunction f : this.prog.getFunctions()) {
            this.translateFunc(f);
        }
        for (ImClass c : this.prog.getClasses()) {
            this.initClassTables(c);
        }
        this.cleanStatements();
        return this.luaModel;
    }

    private void collectPredefinedNames() {
        for (ImFunction function : this.prog.getFunctions()) {
            if (!function.isBj() && !function.isExtern() && !function.isNative()) continue;
            this.setNameFromTrace(function);
            this.usedNames.add(function.getName());
        }
        for (ImVar global : this.prog.getGlobals()) {
            if (!global.getIsBJ()) continue;
            this.setNameFromTrace(global);
            this.usedNames.add(global.getName());
        }
    }

    private void setNameFromTrace(JassImElementWithName named) {
        Element trace = named.attrTrace();
        if (trace instanceof NameDef) {
            named.setName(((NameDef)trace).getName());
        }
    }

    private void normalizeMethodNames() {
        UnionFind<ImMethod> methodUnions = new UnionFind<ImMethod>();
        for (ImClass c : this.prog.getClasses()) {
            for (ImMethod m : c.getMethods()) {
                methodUnions.find(m);
                for (ImMethod subMethod : m.getSubMethods()) {
                    methodUnions.union(m, subMethod);
                }
            }
        }
        for (Map.Entry entry : methodUnions.groups().entrySet()) {
            String name = this.uniqueName(((ImMethod)entry.getKey()).getName());
            for (ImMethod method : entry.getValue()) {
                method.setName(name);
            }
        }
    }

    private void createStringConcatFunction() {
        String[] code = new String[]{"if x then", "    if y then return x .. y else return x end", "else", "    return y", "end"};
        this.stringConcatFunction.getParams().add(LuaAst.LuaVariable("x", LuaAst.LuaNoExpr()));
        this.stringConcatFunction.getParams().add(LuaAst.LuaVariable("y", LuaAst.LuaNoExpr()));
        for (String c : code) {
            this.stringConcatFunction.getBody().add(LuaAst.LuaLiteral(c));
        }
        this.luaModel.add(this.stringConcatFunction);
    }

    private void createInstanceOfFunction() {
        String[] code = new String[]{"return x ~= nil and x.__wurst_supertypes[A]"};
        this.instanceOfFunction.getParams().add(LuaAst.LuaVariable("x", LuaAst.LuaNoExpr()));
        this.instanceOfFunction.getParams().add(LuaAst.LuaVariable("A", LuaAst.LuaNoExpr()));
        for (String c : code) {
            this.instanceOfFunction.getBody().add(LuaAst.LuaLiteral(c));
        }
        this.luaModel.add(this.instanceOfFunction);
    }

    private void createObjectIndexFunctions() {
        String vName = "__wurst_objectIndexMap";
        LuaVariable v = LuaAst.LuaVariable(vName, LuaAst.LuaTableConstructor(LuaAst.LuaTableFields(LuaAst.LuaTableNamedField("counter", LuaAst.LuaExprIntVal("0")))));
        this.luaModel.add(v);
        LuaVariable im = LuaAst.LuaVariable("__wurst_number_wrapper_map", LuaAst.LuaTableConstructor(LuaAst.LuaTableFields(LuaAst.LuaTableNamedField("counter", LuaAst.LuaExprIntVal("0")))));
        this.luaModel.add(im);
        String[] code = new String[]{"if x == nil then", "    return 0", "end", "if type(x) == \"number\" then", "    if __wurst_number_wrapper_map[x] then", "        x = __wurst_number_wrapper_map[x]", "    else", "        local obj = {__wurst_boxed_number = x}", "        __wurst_number_wrapper_map[x] = obj", "        x = obj", "    end", "end", "if __wurst_objectIndexMap[x] then", "    return __wurst_objectIndexMap[x]", "else", "   local r = __wurst_objectIndexMap.counter + 1", "   __wurst_objectIndexMap.counter = r", "   __wurst_objectIndexMap[r] = x", "   __wurst_objectIndexMap[x] = r", "   return r", "end"};
        this.toIndexFunction.getParams().add(LuaAst.LuaVariable("x", LuaAst.LuaNoExpr()));
        for (String c : code) {
            this.toIndexFunction.getBody().add(LuaAst.LuaLiteral(c));
        }
        this.luaModel.add(this.toIndexFunction);
        code = new String[]{"if type(x) == \"number\" then", "    x = __wurst_objectIndexMap[x]", "end", "if type(x) == \"table\" and x.__wurst_boxed_number then", "    return x.__wurst_boxed_number", "end", "return x"};
        this.fromIndexFunction.getParams().add(LuaAst.LuaVariable("x", LuaAst.LuaNoExpr()));
        for (String c : code) {
            this.fromIndexFunction.getBody().add(LuaAst.LuaLiteral(c));
        }
        this.luaModel.add(this.fromIndexFunction);
    }

    private void createArrayInitFunction() {
        String[] code = new String[]{"local t = {}", "local mt = {__index = function (table, key)", "    local v = d()", "    table[key] = v", "    return v", "end}", "setmetatable(t, mt)", "return t"};
        this.arrayInitFunction.getParams().add(LuaAst.LuaVariable("d", LuaAst.LuaNoExpr()));
        for (String c : code) {
            this.arrayInitFunction.getBody().add(LuaAst.LuaLiteral(c));
        }
        this.luaModel.add(this.arrayInitFunction);
    }

    private void createEnsureTypeFunctions() {
        LuaFunction[] ensureTypeFunctions = new LuaFunction[]{this.ensureIntFunction, this.ensureBoolFunction, this.ensureRealFunction, this.ensureStrFunction};
        String[] defaultValue = new String[]{"0", "false", "0.0", "\"\""};
        for (int i = 0; i < ensureTypeFunctions.length; ++i) {
            LuaFunction ensureTypeFunction = ensureTypeFunctions[i];
            String[] code = new String[]{"if x == nil then", "    return " + defaultValue[i], "else", "    return " + (ensureTypeFunction == this.ensureIntFunction ? "math.tointeger(x)" : "x"), "end"};
            ensureTypeFunction.getParams().add(LuaAst.LuaVariable("x", LuaAst.LuaNoExpr()));
            for (String c : code) {
                ensureTypeFunction.getBody().add(LuaAst.LuaLiteral(c));
            }
            this.luaModel.add(ensureTypeFunction);
        }
    }

    private void cleanStatements() {
        this.luaModel.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaStatements stmts) {
                super.visit(stmts);
                LuaTranslator.this.cleanStatements(stmts);
            }
        });
    }

    private void cleanStatements(LuaStatements stmts) {
        ListIterator it = stmts.listIterator();
        while (it.hasNext()) {
            LuaExpr e;
            LuaStatement s = (LuaStatement)it.next();
            if (s instanceof LuaExprNull) {
                it.remove();
                continue;
            }
            if (!(s instanceof LuaExpr) || ((e = (LuaExpr)s) instanceof LuaCallExpr || e instanceof LuaLiteral) && !(e instanceof LuaExprFunctionCallE)) continue;
            e.setParent(null);
            LuaVariable exprTemp = LuaAst.LuaVariable("wurstExpr", e);
            it.set(exprTemp);
        }
    }

    private void translateFunc(ImFunction f) {
        if (f.isBj()) {
            return;
        }
        LuaFunction lf = this.luaFunc.getFor(f);
        if (f.isNative()) {
            LuaNatives.get(lf);
        } else {
            if (f.hasFlag(FunctionFlagEnum.IS_VARARG)) {
                LuaVariable lastParam = this.luaVar.getFor(Utils.getLast(f.getParameters()));
                lastParam.setName("...");
            }
            for (ImVar local : f.getLocals()) {
                LuaVariable luaLocal = this.luaVar.getFor(local);
                luaLocal.setInitialValue(this.defaultValue(local.getType()));
                lf.getBody().add(luaLocal);
            }
            this.translateStatements(lf.getBody(), f.getBody());
        }
        if (f.isExtern() || f.isNative()) {
            String name = lf.getName();
            this.luaModel.add(LuaAst.LuaIf(LuaAst.LuaExprFuncRef(lf), LuaAst.LuaStatements(new LuaStatement[0]), LuaAst.LuaStatements(LuaAst.LuaAssignment(LuaAst.LuaLiteral(name), LuaAst.LuaExprFunctionAbstraction(lf.getParams().copy(), lf.getBody().copy())))));
        } else {
            this.luaModel.add(lf);
        }
    }

    void translateStatements(List<LuaStatement> res, ImStmts stmts) {
        for (ImStmt s : stmts) {
            s.translateStmtToLua(res, this);
        }
    }

    public LuaStatements translateStatements(ImStmts stmts) {
        LuaStatements r = LuaAst.LuaStatements(new LuaStatement[0]);
        this.translateStatements(r, stmts);
        return r;
    }

    private void translateClass(ImClass c) {
        LuaVariable classVar = this.luaClassVar.getFor(c);
        LuaMethod initMethod = this.luaClassInitMethod.getFor(c);
        this.luaModel.add(initMethod);
        classVar.setInitialValue(this.emptyTable());
        for (ImFunction f : c.getFunctions()) {
            this.translateFunc(f);
            this.luaFunc.getFor(f).setName(this.uniqueName(c.getName() + "_" + f.getName()));
        }
        this.createClassInitFunction(c, classVar, initMethod);
    }

    private void createClassInitFunction(ImClass c, LuaVariable classVar, LuaMethod initMethod) {
        LuaStatements body = initMethod.getBody();
        LuaTableFields initialFieldValues = LuaAst.LuaTableFields(new LuaTableField[0]);
        LuaVariable newInst = LuaAst.LuaVariable("new_inst", LuaAst.LuaTableConstructor(initialFieldValues));
        for (ImVar field : c.getFields()) {
            initialFieldValues.add(LuaAst.LuaTableNamedField(field.getName(), this.defaultValue(field.getType())));
        }
        body.add(newInst);
        body.add(LuaAst.LuaExprFunctionCallByName("setmetatable", LuaAst.LuaExprlist(LuaAst.LuaExprVarAccess(newInst), LuaAst.LuaTableConstructor(LuaAst.LuaTableFields(LuaAst.LuaTableNamedField("__index", LuaAst.LuaExprVarAccess(classVar)))))));
        body.add(LuaAst.LuaReturn(LuaAst.LuaExprVarAccess(newInst)));
    }

    private void initClassTables(ImClass c) {
        LuaVariable classVar = this.luaClassVar.getFor(c);
        HashSet<String> methods = new HashSet<String>();
        this.createMethods(c, classVar, methods);
        LuaTableFields superClasses = LuaAst.LuaTableFields(new LuaTableField[0]);
        this.collectSuperClasses(superClasses, c, new HashSet<ImClass>());
        this.luaModel.add(LuaAst.LuaAssignment(LuaAst.LuaExprFieldAccess(LuaAst.LuaExprVarAccess(classVar), "__wurst_supertypes"), LuaAst.LuaTableConstructor(superClasses)));
        this.luaModel.add(LuaAst.LuaAssignment(LuaAst.LuaExprFieldAccess(LuaAst.LuaExprVarAccess(classVar), "__typeId__"), LuaAst.LuaExprIntVal("" + this.prog.attrTypeId().get(c))));
    }

    private void createMethods(ImClass c, LuaVariable classVar, Set<String> methods) {
        for (ImMethod method : c.getMethods()) {
            if (methods.contains(method.getName())) continue;
            methods.add(method.getName());
            if (method.getIsAbstract()) continue;
            this.luaModel.add(LuaAst.LuaAssignment(LuaAst.LuaExprFieldAccess(LuaAst.LuaExprVarAccess(classVar), method.getName()), LuaAst.LuaExprFuncRef(this.luaFunc.getFor(method.getImplementation()))));
        }
        for (ImClassType sc : c.getSuperClasses()) {
            this.createMethods(sc.getClassDef(), classVar, methods);
        }
    }

    @NotNull
    private LuaTableConstructor emptyTable() {
        return LuaAst.LuaTableConstructor(LuaAst.LuaTableFields(new LuaTableField[0]));
    }

    private void collectSuperClasses(LuaTableFields superClasses, ImClass c, Set<ImClass> visited) {
        if (visited.contains(c)) {
            return;
        }
        superClasses.add(LuaAst.LuaTableExprField(LuaAst.LuaExprVarAccess(this.luaClassVar.getFor(c)), LuaAst.LuaExprBoolVal(true)));
        visited.add(c);
        for (ImClassType sc : c.getSuperClasses()) {
            this.collectSuperClasses(superClasses, sc.getClassDef(), visited);
        }
    }

    private void translateGlobal(ImVar v) {
        if (v.getIsBJ()) {
            return;
        }
        LuaVariable lv = this.luaVar.getFor(v);
        lv.setInitialValue(this.defaultValue(v.getType()));
        this.luaModel.add(lv);
    }

    private LuaExpr defaultValue(ImType type) {
        return type.match(new ImType.Matcher<LuaExpr>(){

            @Override
            public LuaExpr case_ImAnyType(ImAnyType imAnyType) {
                return LuaAst.LuaExprNull();
            }

            @Override
            public LuaExpr case_ImTupleType(ImTupleType tt) {
                LuaTableFields tableFields = LuaAst.LuaTableFields(new LuaTableField[0]);
                for (int i = 0; i < tt.getNames().size(); ++i) {
                    tableFields.add(LuaAst.LuaTableSingleField(LuaTranslator.this.defaultValue(tt.getTypes().get(i))));
                }
                return LuaAst.LuaTableConstructor(tableFields);
            }

            @Override
            public LuaExpr case_ImVoid(ImVoid imVoid) {
                return LuaAst.LuaExprNull();
            }

            @Override
            public LuaExpr case_ImClassType(ImClassType imClassType) {
                return LuaAst.LuaExprNull();
            }

            @Override
            public LuaExpr case_ImArrayTypeMulti(ImArrayTypeMulti at) {
                ImType baseType;
                if (at.getArraySize().size() <= 1) {
                    baseType = at.getEntryType();
                } else {
                    ArrayList<Integer> arraySizes = new ArrayList<Integer>(at.getArraySize());
                    arraySizes.remove(0);
                    baseType = JassIm.ImArrayTypeMulti(at.getEntryType(), arraySizes);
                }
                return LuaAst.LuaExprFunctionCall(LuaTranslator.this.arrayInitFunction, LuaAst.LuaExprlist(LuaAst.LuaExprFunctionAbstraction(LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(LuaAst.LuaReturn(LuaTranslator.this.defaultValue(baseType))))));
            }

            @Override
            public LuaExpr case_ImSimpleType(ImSimpleType st) {
                if (TypesHelper.isIntType(st)) {
                    return LuaAst.LuaExprIntVal("0");
                }
                if (TypesHelper.isBoolType(st)) {
                    return LuaAst.LuaExprBoolVal(false);
                }
                if (TypesHelper.isRealType(st)) {
                    return LuaAst.LuaExprRealVal("0.");
                }
                return LuaAst.LuaExprNull();
            }

            @Override
            public LuaExpr case_ImArrayType(ImArrayType imArrayType) {
                ImType baseType = imArrayType.getEntryType();
                return LuaAst.LuaExprFunctionCall(LuaTranslator.this.arrayInitFunction, LuaAst.LuaExprlist(LuaAst.LuaExprFunctionAbstraction(LuaAst.LuaParams(new LuaVariable[0]), LuaAst.LuaStatements(LuaAst.LuaReturn(LuaTranslator.this.defaultValue(baseType))))));
            }

            @Override
            public LuaExpr case_ImTypeVarRef(ImTypeVarRef imTypeVarRef) {
                return LuaAst.LuaExprNull();
            }
        });
    }

    public LuaExprOpt translateOptional(ImExprOpt e) {
        if (e instanceof ImExpr) {
            ImExpr imExpr = (ImExpr)e;
            return imExpr.translateToLua(this);
        }
        return LuaAst.LuaNoExpr();
    }

    public LuaExprlist translateExprList(ImExprs exprs) {
        LuaExprlist r = LuaAst.LuaExprlist(new LuaExpr[0]);
        for (ImExpr e : exprs) {
            r.add(e.translateToLua(this));
        }
        return r;
    }

    public int getTypeId(ImClass classDef) {
        return this.prog.attrTypeId().get(classDef);
    }

    public LuaFunction getErrorFunc() {
        return this.errorFunc.get();
    }
}

