/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public class ControlFlowGraph {
    private final Map<ImStmt, Node> nodes = new HashMap<ImStmt, Node>();
    private final Map<ImIf, Node> ifEnd = new HashMap<ImIf, Node>();
    private final Map<ImLoop, Node> loopEnd = new HashMap<ImLoop, Node>();
    private final Map<ImVarargLoop, Node> varargLoopEnd = new HashMap<ImVarargLoop, Node>();
    private final List<Node> nodeList = new ArrayList<Node>();

    public ControlFlowGraph(ImStmts stmts) {
        this.buildCfg(stmts);
    }

    private void buildCfg(ImStmts stmts) {
        for (int i = 0; i < stmts.size(); ++i) {
            Node endloopNode;
            ImStmts body;
            ImStmt s = (ImStmt)stmts.get(i);
            Node current = this.getNode(s);
            this.nodeList.add(current);
            if (s instanceof ImLoop) {
                ImLoop imLoop = (ImLoop)s;
                body = imLoop.getBody();
                this.buildCfg(body);
                if (!body.isEmpty()) {
                    this.addSuccessor(current, this.getNode((ImStmt)body.get(0)));
                }
                endloopNode = this.getEndloopNode(imLoop);
                this.nodeList.add(endloopNode);
                this.getSuccessors(imLoop, i).forEach(succ -> this.addSuccessor(endloopNode, (Node)succ));
                continue;
            }
            if (s instanceof ImVarargLoop) {
                ImVarargLoop imVarargLoop = (ImVarargLoop)s;
                body = imVarargLoop.getBody();
                this.buildCfg(body);
                if (!body.isEmpty()) {
                    this.addSuccessor(current, this.getNode((ImStmt)body.get(0)));
                }
                endloopNode = this.getEndVarargLoopNode(imVarargLoop);
                this.addSuccessor(current, endloopNode);
                this.nodeList.add(endloopNode);
                this.getSuccessors(imVarargLoop, i).forEach(succ -> this.addSuccessor(endloopNode, (Node)succ));
                continue;
            }
            if (s instanceof ImIf) {
                ImIf imIf = (ImIf)s;
                ImStmts thenBlock = imIf.getThenBlock();
                ImStmts elseBlock = imIf.getElseBlock();
                this.buildCfg(thenBlock);
                this.buildCfg(elseBlock);
                if (thenBlock.isEmpty()) {
                    this.addSuccessor(current, this.getEndIfNode(imIf));
                } else {
                    this.addSuccessor(current, this.getNode((ImStmt)thenBlock.get(0)));
                }
                if (elseBlock.isEmpty()) {
                    if (!thenBlock.isEmpty()) {
                        this.addSuccessor(current, this.getEndIfNode(imIf));
                    }
                } else {
                    this.addSuccessor(current, this.getNode((ImStmt)elseBlock.get(0)));
                }
                Node endifNode = this.getEndIfNode(imIf);
                this.nodeList.add(endifNode);
                this.getSuccessors(imIf, i).forEach(succ -> this.addSuccessor(endifNode, (Node)succ));
                continue;
            }
            this.getSuccessors(s, i).forEach(succ -> this.addSuccessor(current, (Node)succ));
        }
    }

    private void addSuccessor(Node current, Node succ) {
        current.successors.add(succ);
        succ.predecessors.add(current);
    }

    private Stream<Node> getSuccessors(ImStmt s, int i) {
        return this.getSuccessorList(s, i).stream();
    }

    private List<Node> getSuccessorList(ImStmt s, int i) {
        ArrayList<Node> result;
        block9: {
            if (s instanceof ImReturn) {
                return Collections.emptyList();
            }
            result = new ArrayList<Node>();
            if (s instanceof ImExitwhen) {
                Element e = s;
                do {
                    if (!(e instanceof ImLoop)) continue;
                    result.add(this.getEndloopNode((ImLoop)e));
                    break block9;
                } while ((e = e.getParent()) != null);
                throw new CompileError(s, "exitwhen outside of loop");
            }
        }
        if (s.getParent() instanceof ImStmts) {
            ImStmts stmts = (ImStmts)s.getParent();
            assert (stmts != null);
            if (i + 1 < stmts.size()) {
                result.add(this.getNode((ImStmt)stmts.get(i + 1)));
            } else if (stmts.getParent() instanceof ImStmt) {
                ImStmt par = (ImStmt)stmts.getParent();
                assert (par != null);
                result.addAll(this.successorsOfBlock(par));
            }
            return result;
        }
        throw new Error("not implemented");
    }

    private List<Node> successorsOfBlock(ImStmt par) throws Error {
        if (par instanceof ImLoop) {
            return Collections.singletonList(this.getNode(par));
        }
        if (par instanceof ImVarargLoop) {
            return Collections.singletonList(this.getNode(par));
        }
        if (par instanceof ImIf) {
            return Collections.singletonList(this.getEndIfNode((ImIf)par));
        }
        throw new Error("unhandled case: " + par);
    }

    private Node getNode(ImStmt s) {
        ImStmt stmt = s;
        Node result = this.getNode(this.nodes, s, stmt);
        if (stmt instanceof ImIf) {
            ImIf imIf = (ImIf)stmt;
            result.setName("if " + imIf.getCondition());
            result.stmt = imIf.getCondition();
        } else if (stmt instanceof ImLoop) {
            result.setName("loop");
            result.stmt = null;
        } else if (stmt instanceof ImVarargLoop) {
            result.setName("vararg loop");
            result.stmt = null;
        }
        return result;
    }

    private Node getEndloopNode(ImLoop e) {
        return this.getNode(this.loopEnd, e, null).setName("endloop");
    }

    private Node getEndVarargLoopNode(ImVarargLoop e) {
        return this.getNode(this.varargLoopEnd, e, null).setName("endvarargloop");
    }

    private Node getEndIfNode(ImIf e) {
        return this.getNode(this.ifEnd, e, null).setName("endif");
    }

    private <K> Node getNode(Map<K, Node> cache, K key, @Nullable ImStmt s) {
        return cache.computeIfAbsent(key, k -> new Node(s));
    }

    public List<Node> getNodes() {
        return this.nodeList;
    }

    static class Node {
        private @Nullable ImStmt stmt;
        private @Nullable String name = null;
        private final List<Node> predecessors = new ArrayList<Node>();
        private final List<Node> successors = new ArrayList<Node>();

        public Node(@Nullable ImStmt stmt) {
            this.stmt = stmt;
        }

        public @Nullable ImStmt getStmt() {
            return this.stmt;
        }

        public List<Node> getPredecessors() {
            return this.predecessors;
        }

        public List<Node> getSuccessors() {
            return this.successors;
        }

        public String toString() {
            if (this.name == null) {
                return "" + this.stmt;
            }
            return this.name;
        }

        public Node setName(String name) {
            this.name = name;
            return this;
        }
    }
}

