/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.LoopStatementWithVarDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.OtherLink;
import de.peeeq.wurstscript.attributes.names.PackageLink;
import de.peeeq.wurstscript.attributes.names.TypeDefLink;
import de.peeeq.wurstscript.attributes.names.VarLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;

public class NameResolution {
    public static ImmutableCollection<FuncLink> lookupFuncsNoConfig(Element node, String name, boolean showErrors) {
        WurstType receiverType;
        ImmutableCollection<FuncLink> funcs;
        StructureDef nearestStructureDef = node.attrNearestStructureDef();
        if (nearestStructureDef != null && !(funcs = node.lookupMemberFuncs(receiverType = nearestStructureDef.attrTyp(), name, showErrors)).isEmpty()) {
            return funcs;
        }
        ArrayList result = Lists.newArrayList();
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            for (DefLink n : scope.attrNameLinks().get((Object)name)) {
                if (!(n instanceof FuncLink) || n.getReceiverType() != null || result.contains(n)) continue;
                result.add((FuncLink)n);
            }
            scope = NameResolution.nextScope(scope);
        }
        return NameResolution.removeDuplicates(result);
    }

    public static ImmutableCollection<FuncLink> lookupFuncs(Element e, String name, boolean showErrors) {
        ArrayList result = Lists.newArrayList(e.lookupFuncsNoConfig(name, showErrors));
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, ((FuncLink)result.get(i)).withConfigDef());
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static <T extends NameLink> ImmutableCollection<T> removeDuplicates(List<T> nameLinks) {
        ArrayList result = Lists.newArrayList();
        block0: for (NameLink nl : nameLinks) {
            for (NameLink other : result) {
                if (other.getDef() != nl.getDef()) continue;
                continue block0;
            }
            result.add(nl);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static @Nullable WScope nextScope(WScope scope) {
        Element parent = scope.getParent();
        if (parent == null) {
            return null;
        }
        WScope currentScope = scope;
        if (currentScope instanceof ModuleInstanciation) {
            ModuleInstanciation moduleInstanciation = (ModuleInstanciation)currentScope;
            return NameResolution.nextScope(moduleInstanciation.attrModuleOrigin());
        }
        return parent.attrNearestScope();
    }

    public static ImmutableCollection<FuncLink> lookupMemberFuncs(Element node, WurstType receiverType, String name, boolean showErrors) {
        ArrayList result = Lists.newArrayList();
        NameResolution.addMemberMethods(node, receiverType, name, result);
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            for (DefLink n : scope.attrNameLinks().get((Object)name)) {
                DefLink n2;
                if (!(n instanceof FuncLink) || (n2 = NameResolution.matchDefLinkReceiver(n, receiverType, node, false)) == null) continue;
                FuncLink f = (FuncLink)n2;
                result.add(f);
            }
            scope = NameResolution.nextScope(scope);
        }
        return NameResolution.removeDuplicates(result);
    }

    public static void addMemberMethods(Element node, WurstType receiverType, String name, List<FuncLink> result) {
        receiverType.addMemberMethods(node, name, result);
    }

    public static NameLink lookupVarNoConfig(Element node, String name, boolean showErrors) {
        NameLink privateCandidate = null;
        ArrayList candidates = Lists.newArrayList();
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            block15: {
                block14: {
                    if (!(scope instanceof LoopStatementWithVarDef)) break block14;
                    LoopStatementWithVarDef loop = (LoopStatementWithVarDef)scope;
                    if (!Utils.elementContained(Optional.of(node), loop.getBody())) break block15;
                }
                if (scope instanceof StructureDef) {
                    StructureDef nearestStructureDef = (StructureDef)scope;
                    WurstTypeNamedScope receiverType = (WurstTypeNamedScope)nearestStructureDef.attrTyp();
                    for (DefLink link : receiverType.nameLinks(name)) {
                        if (link instanceof FuncLink) continue;
                        return link;
                    }
                }
                for (DefLink n : scope.attrNameLinks().get((Object)name)) {
                    WurstType n_receiverType = n.getReceiverType();
                    if (n instanceof VarLink && n_receiverType == null) {
                        if (n.getVisibility() != Visibility.PRIVATE_OTHER && n.getVisibility() != Visibility.PROTECTED_OTHER) {
                            candidates.add(n);
                            continue;
                        }
                        if (privateCandidate != null) continue;
                        privateCandidate = n;
                        continue;
                    }
                    if (!(n instanceof TypeDefLink)) continue;
                    candidates.add(n);
                }
                if (candidates.size() > 0) {
                    if (showErrors && candidates.size() > 1) {
                        node.addError("Reference to variable " + name + " is ambiguous. Alternatives are:\n" + Utils.printAlternatives(candidates));
                    }
                    return (NameLink)candidates.get(0);
                }
            }
            scope = NameResolution.nextScope(scope);
        }
        if (showErrors) {
            if (privateCandidate == null) {
                node.addError("Could not find variable " + name + ".");
            } else {
                node.addError(Utils.printElementWithSource(Optional.of(privateCandidate.getDef())) + " is not visible inside this package. If you want to access it, declare it public.");
                return privateCandidate;
            }
        }
        return null;
    }

    public static NameLink lookupMemberVar(Element node, WurstType receiverType, String name, boolean showErrors) {
        WurstTypeArray wta;
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            for (Object n : scope.attrNameLinks().get((Object)name)) {
                DefLink n2;
                if (!(n instanceof VarLink) || (n2 = NameResolution.matchDefLinkReceiver((DefLink)n, receiverType, node, showErrors)) == null) continue;
                return n2;
            }
            scope = NameResolution.nextScope(scope);
        }
        if (receiverType instanceof WurstTypeClassOrInterface) {
            WurstTypeClassOrInterface ct = (WurstTypeClassOrInterface)receiverType;
            for (DefLink n : ct.nameLinks().get((Object)name)) {
                if (!(n instanceof VarLink) && !(n instanceof TypeDefLink) || !n.getVisibility().isPublic()) continue;
                return n;
            }
        } else if (receiverType instanceof WurstTypeArray && name.equals("length") && (wta = (WurstTypeArray)receiverType).getDimensions() > 0) {
            final int size = wta.getSize(0);
            return new OtherLink(Visibility.PUBLIC, name, WurstTypeInt.instance()){

                @Override
                public ImExpr translate(NameRef e, ImTranslator t, ImFunction f) {
                    return JassIm.ImIntVal(size);
                }
            };
        }
        return null;
    }

    public static DefLink matchDefLinkReceiver(DefLink n, WurstType receiverType, Element node, boolean showErrors) {
        WurstType n_receiverType = n.getReceiverType();
        if (n_receiverType == null) {
            return null;
        }
        VariableBinding mapping = receiverType.matchAgainstSupertype(n_receiverType, node, VariableBinding.emptyMapping().withTypeVariables(n.getTypeParams()), VariablePosition.RIGHT);
        if (mapping == null) {
            return null;
        }
        if (showErrors) {
            if (n.getVisibility() == Visibility.PRIVATE_OTHER) {
                node.addError(Utils.printElement(n.getDef()) + " is private and cannot be used here.");
            } else if (n.getVisibility() == Visibility.PROTECTED_OTHER) {
                node.addError(Utils.printElement(n.getDef()) + " is protected and cannot be used here.");
            }
        }
        return n.withTypeArgBinding(node, mapping);
    }

    public static @Nullable TypeDef lookupType(Element node, String name, boolean showErrors) {
        NameLink privateCandidate = null;
        ArrayList candidates = Lists.newArrayList();
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            for (NameLink n : scope.attrTypeNameLinks().get((Object)name)) {
                if (!(n.getDef() instanceof TypeDef)) continue;
                if (n.getVisibility() != Visibility.PRIVATE_OTHER && n.getVisibility() != Visibility.PROTECTED_OTHER) {
                    candidates.add(n);
                    continue;
                }
                if (privateCandidate != null) continue;
                privateCandidate = n;
            }
            if (candidates.size() > 0) {
                if (showErrors && candidates.size() > 1) {
                    node.addError("Reference to type " + name + " is ambiguous. Alternatives are:\n" + Utils.printAlternatives(candidates));
                }
                return (TypeDef)((NameLink)candidates.get(0)).getDef();
            }
            scope = NameResolution.nextScope(scope);
        }
        if (showErrors) {
            if (privateCandidate == null) {
                node.addError("Could not find type " + name + ".");
            } else {
                node.addError(Utils.printElementWithSource(Optional.of(privateCandidate.getDef())) + " is not visible inside this package. If you want to access it, declare it public.");
                return (TypeDef)privateCandidate.getDef();
            }
        }
        return null;
    }

    public static PackageLink lookupPackage(Element node, String name, boolean showErrors) {
        WScope scope = node.attrNearestScope();
        while (scope != null) {
            for (NameLink n : scope.attrNameLinks().get((Object)name)) {
                if (!(n instanceof PackageLink)) continue;
                return (PackageLink)n;
            }
            scope = NameResolution.nextScope(scope);
        }
        return null;
    }

    public static ImmutableCollection<FuncLink> lookupFuncsShort(Element elem, String name) {
        return NameResolution.lookupFuncs(elem, name, true);
    }

    public static ImmutableCollection<FuncLink> lookupMemberFuncsShort(Element elem, WurstType receiverType, String name) {
        return NameResolution.lookupMemberFuncs(elem, receiverType, name, true);
    }

    public static NameLink lookupVarShort(Element node, String name) {
        return NameResolution.lookupVar(node, name, true);
    }

    public static NameLink lookupMemberVarShort(Element node, WurstType receiverType, String name) {
        return NameResolution.lookupMemberVar(node, receiverType, name, true);
    }

    public static @Nullable TypeDef lookupTypeShort(Element node, String name) {
        return NameResolution.lookupType(node, name, true);
    }

    public static PackageLink lookupPackageShort(Element node, String name) {
        return NameResolution.lookupPackage(node, name, true);
    }

    public static NameLink lookupVar(Element e, String name, boolean showErrors) {
        NameLink v = e.lookupVarNoConfig(name, showErrors);
        if (v != null) {
            NameDef actual = v.getDef().attrConfigActualNameDef();
            return v.withDef(actual);
        }
        return null;
    }
}

