/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter.providers;

import de.peeeq.wurstio.jassinterpreter.providers.NameProvider;
import de.peeeq.wurstio.jassinterpreter.providers.Provider;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstFuncRef;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstNull;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class GroupProvider
extends Provider {
    private final ArrayDeque<IlConstHandle> enumUnitStack = new ArrayDeque();

    public GroupProvider(AbstractInterpreter interpreter) {
        super(interpreter);
    }

    public IlConstHandle CreateGroup() {
        return new IlConstHandle(NameProvider.getRandomName("group"), new LinkedHashSet());
    }

    public void GroupClear(IlConstHandle group) {
        ((LinkedHashSet)group.getObj()).clear();
    }

    public ILconstBool GroupAddUnit(IlConstHandle group, IlConstHandle unit) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        if (groupList.contains(unit)) {
            return ILconstBool.FALSE;
        }
        groupList.add(unit);
        return ILconstBool.TRUE;
    }

    public ILconstBool GroupRemoveUnit(IlConstHandle group, IlConstHandle unit) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        if (groupList.contains(unit)) {
            groupList.remove(unit);
            return ILconstBool.TRUE;
        }
        return ILconstBool.FALSE;
    }

    public ILconst FirstOfGroup(IlConstHandle group) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        if (groupList.isEmpty()) {
            WLogger.warning("Trying to get FoG of empty group");
            return ILconstNull.instance();
        }
        return (ILconst)groupList.iterator().next();
    }

    public void ForGroup(IlConstHandle group, ILconstFuncRef funcRef) {
        WLogger.trace("for group call");
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        groupList.forEach(u -> {
            this.enumUnitStack.push((IlConstHandle)u);
            WLogger.trace("for group call itr: " + funcRef.getFuncName());
            this.interpreter.runFuncRef(funcRef, null);
            this.enumUnitStack.pop();
        });
    }

    public IlConstHandle GetEnumUnit() {
        if (this.enumUnitStack.size() == 0 || this.enumUnitStack.peek() == null) {
            WLogger.warning("Calling GetEnumUnit() outside of callback");
        }
        return this.enumUnitStack.peek();
    }

    public void DestroyGroup(IlConstHandle group) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        groupList.clear();
    }

    public ILconstBool IsUnitInGroup(IlConstHandle unit, IlConstHandle group) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        return ILconstBool.instance(groupList.contains(unit));
    }

    public ILconstInt BlzGroupGetSize(IlConstHandle group) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        return ILconstInt.create(groupList.size());
    }

    public ILconst BlzGroupUnitAt(IlConstHandle group, ILconstInt index) {
        LinkedHashSet groupList = (LinkedHashSet)group.getObj();
        ILconst elem = ILconstNull.instance();
        if (index.getVal() > 0 && index.getVal() < groupList.size()) {
            Iterator it = groupList.iterator();
            elem = (ILconst)it.next();
            for (int i = 1; i <= index.getVal() && it.hasNext(); ++i) {
                elem = (ILconst)it.next();
            }
            return elem;
        }
        if (index.getVal() == 0) {
            return this.FirstOfGroup(group);
        }
        return elem;
    }

    public ILconstInt BlzGroupAddGroupFast(IlConstHandle group, IlConstHandle groupAdd) {
        LinkedHashSet groupList = (LinkedHashSet)groupAdd.getObj();
        LinkedHashSet addList = (LinkedHashSet)group.getObj();
        int addCount = 0;
        for (IlConstHandle unit : addList) {
            if (groupList.contains(unit)) continue;
            groupList.add(unit);
            ++addCount;
        }
        return ILconstInt.create(addCount);
    }

    public ILconstInt BlzGroupRemoveGroupFast(IlConstHandle group, IlConstHandle groupRm) {
        LinkedHashSet groupList = (LinkedHashSet)groupRm.getObj();
        int sizeBefore = groupList.size();
        groupList.removeAll((LinkedHashSet)group.getObj());
        return ILconstInt.create(sizeBefore - groupList.size());
    }
}

