/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation.controlflow;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

class VState {
    public static final VState initialDefined = new VState(false, false, (ImmutableSetMultimap<WStatement, Element>)ImmutableSetMultimap.of(), (ImmutableSet<WStatement>)ImmutableSet.of(), (ImmutableSet<WStatement>)ImmutableSet.of());
    public static final VState initial = new VState(true, false, (ImmutableSetMultimap<WStatement, Element>)ImmutableSetMultimap.of(), (ImmutableSet<WStatement>)ImmutableSet.of(), (ImmutableSet<WStatement>)ImmutableSet.of());
    public static final VState destroyed = new VState(false, true, (ImmutableSetMultimap<WStatement, Element>)ImmutableSetMultimap.of(), (ImmutableSet<WStatement>)ImmutableSet.of(), (ImmutableSet<WStatement>)ImmutableSet.of());
    final boolean mightBeUninitialized;
    final boolean mightBeDestroyed;
    final ImmutableSetMultimap<WStatement, Element> writesAndReads;
    final ImmutableSet<WStatement> activeWrites;
    final ImmutableSet<WStatement> allWrites;

    public VState(boolean mightBeUninitialized, boolean mightBeDestroyed, ImmutableSetMultimap<WStatement, Element> writesAndReads, ImmutableSet<WStatement> activeWrites, ImmutableSet<WStatement> allWrites) {
        this.mightBeUninitialized = mightBeUninitialized;
        this.mightBeDestroyed = mightBeDestroyed;
        this.writesAndReads = writesAndReads;
        this.activeWrites = activeWrites;
        this.allWrites = allWrites;
    }

    public VState addWrite(WStatement s) {
        ImmutableSet.Builder wr = ImmutableSet.builder();
        wr.addAll(this.allWrites);
        wr.add((Object)s);
        return new VState(false, false, this.writesAndReads, (ImmutableSet<WStatement>)ImmutableSet.of((Object)s), (ImmutableSet<WStatement>)wr.build());
    }

    public VState addRead(Element r) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll(this.writesAndReads);
        for (WStatement s : this.activeWrites) {
            builder.put((Object)s, (Object)r);
        }
        return new VState(this.mightBeUninitialized, this.mightBeDestroyed, (ImmutableSetMultimap<WStatement, Element>)builder.build(), this.activeWrites, this.allWrites);
    }

    public VState merge(VState other) {
        return new VState(this.mightBeUninitialized || other.mightBeUninitialized, this.mightBeDestroyed || other.mightBeDestroyed, Utils.mergeMultiMaps(this.writesAndReads, other.writesAndReads), Utils.mergeSets(this.activeWrites, other.activeWrites), Utils.mergeSets(this.allWrites, other.allWrites));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.activeWrites.hashCode();
        result = 31 * result + this.allWrites.hashCode();
        result = 31 * result + (this.mightBeUninitialized ? 1231 : 1237);
        result = 31 * result + (this.mightBeDestroyed ? 1231 : 1237);
        result = 31 * result + this.writesAndReads.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VState other = (VState)obj;
        if (!this.activeWrites.equals(other.activeWrites)) {
            return false;
        }
        if (!this.allWrites.equals(other.allWrites)) {
            return false;
        }
        if (this.mightBeUninitialized != other.mightBeUninitialized) {
            return false;
        }
        if (this.mightBeDestroyed != other.mightBeDestroyed) {
            return false;
        }
        return this.writesAndReads.equals(other.writesAndReads);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VState [ " + this.mightBeUninitialized + ", " + this.mightBeDestroyed + ", ");
        for (Map.Entry e : this.writesAndReads.entries()) {
            sb.append("\n\t\t");
            sb.append(((WStatement)e.getKey()).attrSource().getLine()).append(" -> ").append(((Element)e.getValue()).attrSource().getLine());
        }
        sb.append("]");
        return sb.toString();
    }
}

