/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation;

import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDot;
import de.peeeq.wurstscript.ast.ExprMemberArrayVarDotDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDot;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDot;
import de.peeeq.wurstscript.ast.ExprMemberVarDotDot;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.ExprVarArrayAccess;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WPackage;
import java.util.Collection;
import java.util.HashSet;

public class ValidateClassMemberUsage {
    public static void checkClassMembers(Collection<CompilationUnit> toCheck) {
        for (CompilationUnit cu : toCheck) {
            for (WPackage p : cu.getPackages()) {
                ValidateClassMemberUsage.checkVarUsage(p);
                ValidateClassMemberUsage.checkFuncUsage(p);
            }
        }
    }

    private static void checkVarUsage(WPackage p) {
        final HashSet definedVars = new HashSet();
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ClassDef c) {
                super.visit(c);
                definedVars.addAll(c.getVars());
            }
        });
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ExprVarAccess e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprVarArrayAccess e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprMemberVarDot e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprMemberVarDotDot e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprMemberArrayVarDot e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprMemberArrayVarDotDot e) {
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof VarDef) {
                    definedVars.remove(nameDef);
                }
            }
        });
        definedVars.forEach(var -> {
            if (var.attrIsPrivate()) {
                var.addWarning("Private variable <" + var.getName() + "> is never read.");
            }
        });
    }

    private static void checkFuncUsage(WPackage p) {
        final HashSet definedFuncs = new HashSet();
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ClassDef c) {
                super.visit(c);
                definedFuncs.addAll(c.getMethods());
            }
        });
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ExprFunctionCall e) {
                super.visit(e);
                definedFuncs.remove(e.attrFuncDef());
            }

            @Override
            public void visit(ExprFuncRef e) {
                super.visit(e);
                definedFuncs.remove(e.attrFuncDef());
            }

            @Override
            public void visit(ExprMemberMethodDot e) {
                super.visit(e);
                FunctionDefinition nameDef = e.attrFuncDef();
                if (nameDef != null) {
                    definedFuncs.remove(nameDef);
                }
            }

            @Override
            public void visit(ExprMemberMethodDotDot e) {
                super.visit(e);
                FunctionDefinition nameDef = e.attrFuncDef();
                if (nameDef != null) {
                    definedFuncs.remove(nameDef);
                }
            }
        });
        definedFuncs.forEach(funcDef -> {
            if (!(!funcDef.attrIsPrivate() || funcDef.attrIsStatic() && funcDef.hasAnnotation("@compiletime"))) {
                funcDef.addWarning("Private function <" + funcDef.getName() + "> is never used.");
            }
        });
    }
}

