/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.types.WurstTypeBool;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeString;
import de.peeeq.wurstscript.types.WurstTypeVoid;

public class TypesHelper {
    private static final ImSimpleType intType = WurstTypeInt.instance().imTranslateType();
    private static final ImSimpleType realType = WurstTypeReal.instance().imTranslateType();

    public static ImSimpleType imInt() {
        return intType;
    }

    public static ImSimpleType imReal() {
        return realType;
    }

    public static ImSimpleType imString() {
        return WurstTypeString.instance().imTranslateType();
    }

    public static ImType imVoid() {
        return WurstTypeVoid.instance().imTranslateType();
    }

    public static ImType imBool() {
        return WurstTypeBool.instance().imTranslateType();
    }

    public static ImType imHashTable() {
        return JassIm.ImSimpleType("hashtable");
    }

    public static ImArrayType imIntArray() {
        return JassIm.ImArrayType(TypesHelper.imInt());
    }

    public static ImArrayType imStringArray() {
        return JassIm.ImArrayType(TypesHelper.imString());
    }

    public static boolean typeContainsTuples(ImType vt) {
        return vt instanceof ImTupleType || vt instanceof ImArrayType && TypesHelper.typeContainsTuples(((ImArrayType)vt).getEntryType()) || vt instanceof ImArrayTypeMulti && TypesHelper.typeContainsTuples(((ImArrayTypeMulti)vt).getEntryType());
    }

    public static ImVar getSimpleAndPureTupleVar(ImTupleSelection ts) {
        ImExpr te = ts;
        while (te instanceof ImTupleSelection) {
            te = te.getTupleExpr();
        }
        if (te instanceof ImVarAccess) {
            ImVar var = ((ImVarAccess)te).getVar();
            if (var.isGlobal()) {
                return null;
            }
            return var;
        }
        return null;
    }

    public static ImVar getTupleVar(ImTupleSelection ts) {
        ImExpr te = ts;
        while (te instanceof ImTupleSelection) {
            te = te.getTupleExpr();
        }
        if (te instanceof ImVarAccess) {
            return ((ImVarAccess)te).getVar();
        }
        if (te instanceof ImVarArrayAccess) {
            return ((ImVarArrayAccess)te).getVar();
        }
        if (te instanceof ImMemberAccess) {
            return ((ImMemberAccess)te).getVar();
        }
        throw new Error("not implemented");
    }

    public static boolean isIntType(ImType t) {
        if (t instanceof ImSimpleType) {
            return ((ImSimpleType)t).getTypename().equals("integer");
        }
        return false;
    }

    public static boolean isRealType(ImType t) {
        if (t instanceof ImSimpleType) {
            return ((ImSimpleType)t).getTypename().equals("real");
        }
        return false;
    }

    public static boolean isBoolType(ImType t) {
        if (t instanceof ImSimpleType) {
            return ((ImSimpleType)t).getTypename().equals("boolean");
        }
        return false;
    }

    public static boolean isStringType(ImType t) {
        if (t instanceof ImSimpleType) {
            return ((ImSimpleType)t).getTypename().equals("string");
        }
        return false;
    }

    public static ImSimpleType imTrigger() {
        return JassIm.ImSimpleType("trigger");
    }
}

