/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.AstElementWithIndexes;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprBoolVal;
import de.peeeq.wurstscript.ast.ExprCast;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprDestroy;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprIfElse;
import de.peeeq.wurstscript.ast.ExprIncomplete;
import de.peeeq.wurstscript.ast.ExprInstanceOf;
import de.peeeq.wurstscript.ast.ExprIntVal;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprMemberMethodDotDot;
import de.peeeq.wurstscript.ast.ExprMemberVar;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.ExprNull;
import de.peeeq.wurstscript.ast.ExprRealVal;
import de.peeeq.wurstscript.ast.ExprStatementsBlock;
import de.peeeq.wurstscript.ast.ExprStringVal;
import de.peeeq.wurstscript.ast.ExprSuper;
import de.peeeq.wurstscript.ast.ExprThis;
import de.peeeq.wurstscript.ast.ExprTypeId;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.LExpr;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.TranslatedToImFunction;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.OtherLink;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeClassFunc;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVars;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ClosureTranslator;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeModuleInstanciation;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeTuple;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.utils.Utils;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExprTranslation {
    public static ImExpr translate(ExprBinary e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprUnary e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprBoolVal e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprFuncRef e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprIntVal e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprNull e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprRealVal e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprStringVal e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprThis e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprSuper e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(NameRef e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprCast e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(FunctionCall e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprIncomplete e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprNewObject e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    public static ImExpr translate(ExprInstanceOf e, ImTranslator t, ImFunction f) {
        return ExprTranslation.wrapTranslation(e, t, ExprTranslation.translateIntern(e, t, f));
    }

    private static ImExpr wrapTranslation(Expr e, ImTranslator t, ImExpr translated) {
        WurstType actualType = e.attrTypRaw();
        WurstType expectedTypRaw = e.attrExpectedTypRaw();
        return ExprTranslation.wrapTranslation(e, t, translated, actualType, expectedTypRaw);
    }

    static ImExpr wrapLua(Element trace, ImTranslator t, ImExpr translated, WurstType actualType) {
        if (t.isLuaTarget() && actualType instanceof WurstTypeBoundTypeParam) {
            WurstTypeBoundTypeParam wtb = (WurstTypeBoundTypeParam)actualType;
            ImFunction ensureType = null;
            switch (wtb.getName()) {
                case "integer": {
                    ensureType = t.ensureIntFunc;
                    break;
                }
                case "string": {
                    ensureType = t.ensureStrFunc;
                    break;
                }
                case "boolean": {
                    ensureType = t.ensureBoolFunc;
                    break;
                }
                case "real": {
                    ensureType = t.ensureRealFunc;
                }
            }
            if (ensureType != null) {
                return JassIm.ImFunctionCall(trace, ensureType, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(translated), false, CallType.NORMAL);
            }
        }
        return translated;
    }

    static ImExpr wrapTranslation(Element trace, ImTranslator t, ImExpr translated, WurstType actualType, WurstType expectedTypRaw) {
        FuncDef toIndexFunc;
        WurstTypeBoundTypeParam wtb;
        FuncDef fromIndexFunc;
        ImFunction toIndex = null;
        ImFunction fromIndex = null;
        if (actualType instanceof WurstTypeBoundTypeParam && (fromIndexFunc = (wtb = (WurstTypeBoundTypeParam)actualType).getFromIndex()) != null) {
            fromIndex = t.getFuncFor(fromIndexFunc);
        }
        if (expectedTypRaw instanceof WurstTypeBoundTypeParam && (toIndexFunc = (wtb = (WurstTypeBoundTypeParam)expectedTypRaw).getToIndex()) != null) {
            toIndex = t.getFuncFor(toIndexFunc);
        }
        if (toIndex != null && fromIndex != null) {
            return ExprTranslation.wrapLua(trace, t, translated, actualType);
        }
        if (fromIndex != null) {
            if (t.isLuaTarget()) {
                translated = JassIm.ImFunctionCall(trace, t.ensureIntFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(translated), false, CallType.NORMAL);
            }
            return JassIm.ImFunctionCall(trace, fromIndex, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(translated), false, CallType.NORMAL);
        }
        if (toIndex != null) {
            return ExprTranslation.wrapLua(trace, t, JassIm.ImFunctionCall(trace, toIndex, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(translated), false, CallType.NORMAL), actualType);
        }
        return ExprTranslation.wrapLua(trace, t, translated, actualType);
    }

    public static ImExpr translateIntern(ExprBinary e, ImTranslator t, ImFunction f) {
        ImExpr left = e.getLeft().imTranslateExpr(t, f);
        ImExpr right = e.getRight().imTranslateExpr(t, f);
        WurstOperator op = e.getOp();
        if (e.attrFuncLink() != null) {
            ImFunction calledFunc = t.getFuncFor(e.attrFuncDef());
            return JassIm.ImFunctionCall(e, calledFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(left, right), false, CallType.NORMAL);
        }
        if (op == WurstOperator.DIV_REAL) {
            if (Utils.isJassCode(e)) {
                if (e.getLeft().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e) && e.getRight().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e)) {
                    op = WurstOperator.DIV_INT;
                }
            } else if (e.getLeft().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e) && e.getRight().attrTyp().isSubtypeOf(WurstTypeInt.instance(), e)) {
                left = JassIm.ImOperatorCall(WurstOperator.MULT, JassIm.ImExprs(left, JassIm.ImRealVal("1.")));
            }
        }
        return JassIm.ImOperatorCall(op, JassIm.ImExprs(left, right));
    }

    public static ImExpr translateIntern(ExprUnary e, ImTranslator t, ImFunction f) {
        return JassIm.ImOperatorCall(e.getOpU(), JassIm.ImExprs(e.getRight().imTranslateExpr(t, f)));
    }

    public static ImExpr translateIntern(ExprBoolVal e, ImTranslator t, ImFunction f) {
        return JassIm.ImBoolVal(e.getValB());
    }

    public static ImExpr translateIntern(ExprFuncRef e, ImTranslator t, ImFunction f) {
        ImFunction func = t.getFuncFor(e.attrFuncDef());
        return JassIm.ImFuncRef(e, func);
    }

    public static ImExpr translateIntern(ExprIntVal e, ImTranslator t, ImFunction f) {
        if (e.attrExpectedTyp() instanceof WurstTypeReal) {
            return JassIm.ImRealVal(e.getValI() + ".");
        }
        return JassIm.ImIntVal(e.getValI());
    }

    public static ImExpr translateIntern(ExprNull e, ImTranslator t, ImFunction f) {
        WurstType expectedTypeRaw = e.attrExpectedTypRaw();
        if (expectedTypeRaw instanceof WurstTypeUnknown) {
            e.addError("Cannot use 'null' in this context.");
        }
        return JassIm.ImNull(expectedTypeRaw.imTranslateType(t));
    }

    public static ImExpr translateIntern(ExprRealVal e, ImTranslator t, ImFunction f) {
        return JassIm.ImRealVal(e.getValR());
    }

    public static ImExpr translateIntern(ExprStringVal e, ImTranslator t, ImFunction f) {
        return JassIm.ImStringVal(e.getValS());
    }

    public static ImExpr translateIntern(ExprThis e, ImTranslator t, ImFunction f) {
        ImVar var = t.getThisVar(f, e);
        return JassIm.ImVarAccess(var);
    }

    public static ImExpr translateIntern(ExprSuper e, ImTranslator t, ImFunction f) {
        ImVar var = t.getThisVar(f, e);
        return JassIm.ImVarAccess(var);
    }

    public static ImExpr translateIntern(NameRef e, ImTranslator t, ImFunction f) {
        return ExprTranslation.translateNameDef(e, t, f);
    }

    private static ImExpr translateNameDef(NameRef e, ImTranslator t, ImFunction f) throws CompileError {
        NameDef decl;
        NameLink link = e.attrNameLink();
        NameDef nameDef = decl = link == null ? null : link.getDef();
        if (decl == null) {
            if (!t.isEclipseMode()) {
                e.addError("Translation Error: Could not find definition of " + e.getVarName() + ".");
            }
            return ImHelper.nullExpr();
        }
        if (decl instanceof VarDef) {
            VarDef varDef = (VarDef)decl;
            ImVar v = t.getVarFor(varDef);
            if (e.attrImplicitParameter() instanceof Expr) {
                Expr implicitParam = (Expr)e.attrImplicitParameter();
                if (implicitParam.attrTyp() instanceof WurstTypeTuple) {
                    WurstTypeTuple tupleType = (WurstTypeTuple)implicitParam.attrTyp();
                    if (e instanceof ExprMemberVar) {
                        ExprMemberVar e2 = (ExprMemberVar)e;
                        return ExprTranslation.translateTupleSelection(t, f, e2);
                    }
                    throw new CompileError(e.getSource(), "Cannot create tuple access");
                }
                if (e instanceof AstElementWithIndexes) {
                    ImExpr index1 = implicitParam.imTranslateExpr(t, f);
                    ImExpr index2 = ((Expr)((AstElementWithIndexes)((Object)e)).getIndexes().get(0)).imTranslateExpr(t, f);
                    return JassIm.ImMemberAccess(e, index1, JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(index2));
                }
                ImExpr index = implicitParam.imTranslateExpr(t, f);
                return JassIm.ImMemberAccess(e, index, JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(new ImExpr[0]));
            }
            if (e instanceof AstElementWithIndexes) {
                AstElementWithIndexes withIndexes = (AstElementWithIndexes)((Object)e);
                if (withIndexes.getIndexes().size() > 1) {
                    throw new CompileError(e.getSource(), "More than one index is not supported.");
                }
                ImExpr index = ((Expr)withIndexes.getIndexes().get(0)).imTranslateExpr(t, f);
                return JassIm.ImVarArrayAccess(e, v, JassIm.ImExprs(index));
            }
            return JassIm.ImVarAccess(v);
        }
        if (decl instanceof EnumMember) {
            EnumMember enumMember = (EnumMember)decl;
            int id = t.getEnumMemberId(enumMember);
            return JassIm.ImIntVal(id);
        }
        if (link instanceof OtherLink) {
            OtherLink otherLink = (OtherLink)link;
            return otherLink.translate(e, t, f);
        }
        throw new CompileError(e.getSource(), "Cannot translate reference to " + Utils.printElement(decl));
    }

    private static ImExpr translateTupleSelection(ImTranslator t, ImFunction f, ExprMemberVar mv) {
        ImExpr left = mv.getLeft().imTranslateExpr(t, f);
        WParameter tupleParam = (WParameter)mv.attrNameDef();
        WParameters tupleParams = (WParameters)tupleParam.getParent();
        int tupleIndex = tupleParams.indexOf(tupleParam);
        if (left instanceof ImLExpr) {
            return JassIm.ImTupleSelection(left, tupleIndex);
        }
        ImVar v = JassIm.ImVar(left.attrTrace(), left.attrTyp(), "temp_tuple", false);
        f.getLocals().add(v);
        return JassIm.ImStatementExpr(JassIm.ImStmts(JassIm.ImSet(left.attrTrace(), JassIm.ImVarAccess(v), left)), JassIm.ImTupleSelection(JassIm.ImVarAccess(v), tupleIndex));
    }

    private static int tupleSize(WurstType t) {
        if (t instanceof WurstTypeTuple) {
            WurstTypeTuple tt = (WurstTypeTuple)t;
            int sum = 0;
            for (WParameter p : tt.getTupleDef().getParameters()) {
                sum += ExprTranslation.tupleSize(p.getTyp().attrTyp());
            }
            return sum;
        }
        return 1;
    }

    public static ImExpr translateIntern(ExprCast e, ImTranslator t, ImFunction f) {
        ImExpr et = e.getExpr().imTranslateExpr(t, f);
        ImType toType = e.getTyp().attrTyp().imTranslateType(t);
        return JassIm.ImCast(et, toType);
    }

    public static ImExpr translateIntern(FunctionCall e, ImTranslator t, ImFunction f) {
        if (e instanceof ExprMemberMethodDotDot) {
            return ExprTranslation.translateFunctionCall(e, t, f, true);
        }
        return ExprTranslation.translateFunctionCall(e, t, f, false);
    }

    private static ImExpr translateFunctionCall(FunctionCall e, ImTranslator t, ImFunction f, boolean returnReveiver) {
        ImExpr call;
        ExprMemberMethod exprMemberMethod;
        WurstType left;
        if (e.getFuncName().equals("getStackTraceString") && e.attrImplicitParameter() instanceof NoExpr && e.getArgs().size() == 0) {
            return JassIm.ImGetStackTrace();
        }
        if (e.getFuncName().equals("ExecuteFunc")) {
            ExprStringVal s = (ExprStringVal)e.getArgs().get(0);
            String exFunc = s.getValS();
            NameLink func = Utils.getFirst(e.lookupFuncs(exFunc));
            ImFunction executedFunc = t.getFuncFor((TranslatedToImFunction)((Object)func.getDef()));
            return JassIm.ImFunctionCall(e, executedFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), true, CallType.EXECUTE);
        }
        if (e.getFuncName().equals("compiletime") && e.attrImplicitParameter() instanceof NoExpr && e.getArgs().size() == 1) {
            return JassIm.ImCompiletimeExpr(e, ((Expr)e.getArgs().get(0)).imTranslateExpr(t, f), t.getCompiletimeExpressionsOrder(e));
        }
        ArrayList arguments = Lists.newArrayList((Iterable)e.getArgs());
        Expr leftExpr = null;
        boolean dynamicDispatch = false;
        FunctionDefinition calledFunc = e.attrFuncDef();
        if (e.attrImplicitParameter() instanceof Expr) {
            if (ExprTranslation.isCalledOnDynamicRef(e) && calledFunc instanceof FuncDef) {
                dynamicDispatch = true;
            }
            leftExpr = (Expr)e.attrImplicitParameter();
        }
        boolean useRealFuncDef = true;
        if (e instanceof ExprMemberMethod && (left = (exprMemberMethod = (ExprMemberMethod)e).getLeft().attrTyp()) instanceof WurstTypeModuleInstanciation) {
            useRealFuncDef = false;
        }
        if (calledFunc == null) {
            return ImHelper.nullExpr();
        }
        if (useRealFuncDef) {
            calledFunc = calledFunc.attrRealFuncDef();
        }
        if (leftExpr instanceof ExprThis && calledFunc == e.attrNearestFuncDef()) {
            dynamicDispatch = false;
        }
        ImExpr receiver = leftExpr == null ? null : leftExpr.imTranslateExpr(t, f);
        ImExprs imArgs = ExprTranslation.translateExprs(arguments, t, f);
        if (calledFunc instanceof TupleDef) {
            return JassIm.ImTupleExpr(imArgs);
        }
        ImStmts stmts = null;
        ImVar tempVar = null;
        if (returnReveiver) {
            if (leftExpr == null) {
                throw new Error("impossible");
            }
            tempVar = JassIm.ImVar(leftExpr, leftExpr.attrTyp().imTranslateType(t), "receiver", false);
            f.getLocals().add(tempVar);
            stmts = JassIm.ImStmts(JassIm.ImSet(e, JassIm.ImVarAccess(tempVar), receiver));
            receiver = JassIm.ImVarAccess(tempVar);
        }
        if (dynamicDispatch) {
            ImMethod method = t.getMethodFor((FuncDef)calledFunc);
            ImTypeArguments typeArguments = ExprTranslation.getFunctionCallTypeArguments(t, e.attrFunctionSignature(), e, method.getImplementation().getTypeVariables());
            call = JassIm.ImMethodCall(e, method, typeArguments, receiver, imArgs, false);
        } else {
            ImFunction calledImFunc = t.getFuncFor(calledFunc);
            if (receiver != null) {
                imArgs.add(0, receiver);
            }
            ImTypeArguments typeArguments = ExprTranslation.getFunctionCallTypeArguments(t, e.attrFunctionSignature(), e, calledImFunc.getTypeVariables());
            call = JassIm.ImFunctionCall(e, calledImFunc, typeArguments, imArgs, false, CallType.NORMAL);
        }
        if (returnReveiver) {
            if (stmts == null) {
                throw new Error("impossible");
            }
            stmts.add(call);
            return JassIm.ImStatementExpr(stmts, JassIm.ImVarAccess(tempVar));
        }
        return call;
    }

    private static ImTypeArguments getFunctionCallTypeArguments(ImTranslator tr, FunctionSignature sig, Element location, ImTypeVars typeVariables) {
        ImTypeArguments res = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        VariableBinding mapping = sig.getMapping();
        for (ImTypeVar tv : typeVariables) {
            TypeParamDef tp = tr.getTypeParamDef(tv);
            Option<WurstTypeBoundTypeParam> to = mapping.get(tp);
            if (to.isEmpty()) {
                throw new CompileError(location, "Type variable " + tp.getName() + " not bound in mapping.");
            }
            WurstTypeBoundTypeParam t = (WurstTypeBoundTypeParam)to.get();
            if (!t.isTemplateTypeParameter()) continue;
            ImType type = t.imTranslateType(tr);
            HashMap<ImTypeClassFunc, Either<ImMethod, ImFunction>> typeClassBinding = new HashMap<ImTypeClassFunc, Either<ImMethod, ImFunction>>();
            res.add(JassIm.ImTypeArgument(type, typeClassBinding));
        }
        return res;
    }

    private static boolean isCalledOnDynamicRef(FunctionCall e) {
        if (e instanceof ExprMemberMethod) {
            ExprMemberMethod mm = (ExprMemberMethod)e;
            return mm.getLeft().attrTyp().allowsDynamicDispatch();
        }
        return e.attrIsDynamicContext();
    }

    private static ImExprs translateExprs(List<Expr> arguments, ImTranslator t, ImFunction f) {
        ImExprs result = JassIm.ImExprs(new ImExpr[0]);
        for (Expr e : arguments) {
            result.add(e.imTranslateExpr(t, f));
        }
        return result;
    }

    public static ImExpr translateIntern(ExprIncomplete e, ImTranslator t, ImFunction f) {
        throw new CompileError(e.getSource(), "Incomplete expression.");
    }

    public static ImExpr translateIntern(ExprNewObject e, ImTranslator t, ImFunction f) {
        ConstructorDef constructorFunc = e.attrConstructorDef();
        ImFunction constructorImFunc = t.getConstructNewFunc(constructorFunc);
        FunctionSignature sig = e.attrFunctionSignature();
        WurstTypeClass wurstType = (WurstTypeClass)e.attrTyp();
        ImClass imClass = t.getClassFor(wurstType.getClassDef());
        ImTypeArguments typeArgs = ExprTranslation.getFunctionCallTypeArguments(t, sig, e, imClass.getTypeVariables());
        return JassIm.ImFunctionCall(e, constructorImFunc, typeArgs, ExprTranslation.translateExprs(e.getArgs(), t, f), false, CallType.NORMAL);
    }

    public static ImExprOpt translate(NoExpr e, ImTranslator translator, ImFunction f) {
        return JassIm.ImNoExpr();
    }

    public static ImExpr translateIntern(ExprInstanceOf e, ImTranslator translator, ImFunction f) {
        WurstType targetType = e.getTyp().attrTyp();
        ImType imTargetType = targetType.imTranslateType(translator);
        if (imTargetType instanceof ImClassType) {
            return JassIm.ImInstanceof(e.getExpr().imTranslateExpr(translator, f), (ImClassType)imTargetType);
        }
        throw new Error("Cannot compile instanceof " + targetType);
    }

    public static ImExpr translate(ExprTypeId e, ImTranslator translator, ImFunction f) {
        WurstType leftType = e.getLeft().attrTyp();
        ImType imLeftType = leftType.imTranslateType(translator);
        if (imLeftType instanceof ImClassType) {
            ImClassType imLeftTypeC = (ImClassType)imLeftType;
            if (leftType instanceof WurstTypeClassOrInterface) {
                WurstTypeClassOrInterface wtc = (WurstTypeClassOrInterface)leftType;
                if (wtc.isStaticRef()) {
                    return JassIm.ImTypeIdOfClass(imLeftTypeC);
                }
                return JassIm.ImTypeIdOfObj(e.getLeft().imTranslateExpr(translator, f), imLeftTypeC);
            }
            throw new CompileError(e, "not implemented for " + leftType);
        }
        throw new CompileError(e, "not implemented for " + leftType);
    }

    public static ImExpr translate(ExprClosure e, ImTranslator tr, ImFunction f) {
        return new ClosureTranslator(e, tr, f).translate();
    }

    public static ImExpr translate(ExprStatementsBlock e, ImTranslator translator, ImFunction f) {
        ImStmts statements = JassIm.ImStmts(new ImStmt[0]);
        for (WStatement s : e.getBody()) {
            if (s instanceof StmtReturn) continue;
            ImStmt translated = s.imTranslateStmt(translator, f);
            statements.add(translated);
        }
        StmtReturn r = e.getReturnStmt();
        if (r != null && r.getReturnedObj() instanceof Expr) {
            ImExpr expr = ((Expr)r.getReturnedObj()).imTranslateExpr(translator, f);
            return JassIm.ImStatementExpr(statements, expr);
        }
        return ImHelper.statementExprVoid(statements);
    }

    public static ImExpr translate(ExprDestroy s, ImTranslator t, ImFunction f) {
        WurstType typ = s.getDestroyedObj().attrTyp();
        if (typ instanceof WurstTypeClass) {
            WurstTypeClass classType = (WurstTypeClass)typ;
            return ExprTranslation.destroyClass(s, t, f, classType.getClassDef());
        }
        if (typ instanceof WurstTypeInterface) {
            WurstTypeInterface wti = (WurstTypeInterface)typ;
            return ExprTranslation.destroyClass(s, t, f, wti.getDef());
        }
        if (typ instanceof WurstTypeModuleInstanciation) {
            WurstTypeModuleInstanciation minsType = (WurstTypeModuleInstanciation)typ;
            ClassDef classDef = minsType.getDef().attrNearestClassDef();
            return ExprTranslation.destroyClass(s, t, f, classDef);
        }
        throw new CompileError(s.getSource(), "cannot destroy object of type " + typ);
    }

    public static ImExpr destroyClass(ExprDestroy s, ImTranslator t, ImFunction f, StructureDef classDef) {
        ImMethod destroyFunc = t.destroyMethod.getFor(classDef);
        return JassIm.ImMethodCall(s, destroyFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), s.getDestroyedObj().imTranslateExpr(t, f), JassIm.ImExprs(new ImExpr[0]), false);
    }

    public static ImExpr translate(ExprEmpty s, ImTranslator translator, ImFunction f) {
        throw new CompileError(s.getSource(), "cannot translate empty expression");
    }

    public static ImExpr translate(ExprIfElse e, ImTranslator t, ImFunction f) {
        ImExpr ifTrue = e.getIfTrue().imTranslateExpr(t, f);
        ImExpr ifFalse = e.getIfFalse().imTranslateExpr(t, f);
        ImVar res = JassIm.ImVar(e, ifTrue.attrTyp(), "cond_result", false);
        f.getLocals().add(res);
        return JassIm.ImStatementExpr(JassIm.ImStmts(JassIm.ImIf(e, e.getCond().imTranslateExpr(t, f), JassIm.ImStmts(JassIm.ImSet(e.getIfTrue(), JassIm.ImVarAccess(res), ifTrue)), JassIm.ImStmts(JassIm.ImSet(e.getIfFalse(), JassIm.ImVarAccess(res), ifFalse)))), JassIm.ImVarAccess(res));
    }

    public static ImLExpr translateLvalue(LExpr e, ImTranslator t, ImFunction f) {
        NameDef decl = e.attrNameDef();
        if (decl == null) {
            throw new CompileError(e.getSource(), "Translation Error: Could not find definition of " + e.getVarName() + ".");
        }
        if (decl instanceof VarDef) {
            VarDef varDef = (VarDef)decl;
            ImVar v = t.getVarFor(varDef);
            if (e.attrImplicitParameter() instanceof Expr) {
                Expr implicitParam = (Expr)e.attrImplicitParameter();
                if (implicitParam.attrTyp() instanceof WurstTypeTuple) {
                    WurstTypeTuple tupleType = (WurstTypeTuple)implicitParam.attrTyp();
                    if (e instanceof ExprMemberVar && ((ExprMemberVar)e).getLeft() instanceof LExpr) {
                        ExprMemberVar emv = (ExprMemberVar)e;
                        LExpr left = (LExpr)emv.getLeft();
                        ImLExpr lt = left.imTranslateExprLvalue(t, f);
                        return JassIm.ImTupleSelection(lt, tupleType.getTupleIndex(varDef));
                    }
                    throw new CompileError(e.getSource(), "Cannot create tuple access");
                }
                if (e instanceof AstElementWithIndexes) {
                    ImExpr index1 = implicitParam.imTranslateExpr(t, f);
                    ImExpr index2 = ((Expr)((AstElementWithIndexes)((Object)e)).getIndexes().get(0)).imTranslateExpr(t, f);
                    return JassIm.ImMemberAccess(e, index1, JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(index2));
                }
                ImExpr index = implicitParam.imTranslateExpr(t, f);
                return JassIm.ImMemberAccess(e, index, JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(new ImExpr[0]));
            }
            if (e instanceof AstElementWithIndexes) {
                AstElementWithIndexes withIndexes = (AstElementWithIndexes)((Object)e);
                if (withIndexes.getIndexes().size() > 1) {
                    throw new CompileError(e.getSource(), "More than one index is not supported.");
                }
                ImExpr index = ((Expr)withIndexes.getIndexes().get(0)).imTranslateExpr(t, f);
                return JassIm.ImVarArrayAccess(e, v, JassIm.ImExprs(index));
            }
            return JassIm.ImVarAccess(v);
        }
        throw new CompileError(e.getSource(), "Cannot translate reference to " + Utils.printElement(decl));
    }
}

