/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaCallExpr;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaExprlist;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaExprFunctionCallImpl
implements LuaExprFunctionCall {
    private Element parent;
    private LuaFunction func;
    private LuaExprlist arguments;

    LuaExprFunctionCallImpl(LuaFunction func, LuaExprlist arguments) {
        if (func == null) {
            throw new IllegalArgumentException("Element func must not be null.");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Element arguments must not be null.");
        }
        this.func = func;
        this.arguments = arguments;
        arguments.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setFunc(LuaFunction func) {
        if (func == null) {
            throw new IllegalArgumentException();
        }
        this.func = func;
    }

    @Override
    public LuaFunction getFunc() {
        return this.func;
    }

    @Override
    public void setArguments(LuaExprlist arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException();
        }
        this.arguments.setParent(null);
        arguments.setParent(this);
        this.arguments = arguments;
    }

    @Override
    public LuaExprlist getArguments() {
        return this.arguments;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.arguments;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExprlist oldElem = this.arguments;
                this.setArguments((LuaExprlist)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.arguments);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public LuaExprFunctionCall copy() {
        LuaExprFunctionCallImpl result = new LuaExprFunctionCallImpl(this.func, this.arguments.copy());
        return result;
    }

    @Override
    public LuaExprFunctionCall copyWithRefs() {
        final LuaExprFunctionCall res = this.copy();
        final LuaExprFunctionCallImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.arguments.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public <T> T match(LuaCallExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public void match(LuaCallExpr.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprFunctionCall(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprFunctionCall(this);
    }

    public String toString() {
        return "LuaExprFunctionCall(" + this.func + ", " + this.arguments + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprFunctionCall) {
            LuaExprFunctionCall o = (LuaExprFunctionCall)e;
            return this.func == o.getFunc() && this.arguments.structuralEquals(o.getArguments());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

