/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.NameLinks;
import de.peeeq.wurstscript.attributes.names.TypeLink;
import java.util.Set;

public class Exports {
    public static ImmutableMultimap<String, DefLink> exportedNameLinks(WPackage p) {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        Exports.addExportedNameLinks((ImmutableMultimap.Builder<String, DefLink>)result, p, Sets.newLinkedHashSet());
        return result.build();
    }

    private static void addExportedNameLinks(ImmutableMultimap.Builder<String, DefLink> result, WPackage p, Set<WPackage> alreadyImported) {
        if (alreadyImported.contains(p)) {
            return;
        }
        alreadyImported.add(p);
        NameLinks.addHidingPrivateAndProtected(result, p.getElements().attrNameLinks());
        for (WImport imp2 : p.getImports()) {
            WPackage imported;
            if (!imp2.getIsPublic() || (imported = imp2.attrImportedPackage()) == null) continue;
            Exports.addExportedNameLinks(result, imported, alreadyImported);
        }
    }

    public static ImmutableMultimap<String, TypeLink> exportedTypeNameLinks(WPackage p) {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        Exports.addExportedTypeNameLinks((ImmutableMultimap.Builder<String, TypeLink>)result, p, Sets.newLinkedHashSet());
        return result.build();
    }

    private static void addExportedTypeNameLinks(ImmutableMultimap.Builder<String, TypeLink> result, WPackage p, Set<WPackage> alreadyImported) {
        if (alreadyImported.contains(p)) {
            return;
        }
        alreadyImported.add(p);
        NameLinks.addTypesHidingPrivateAndProtected(result, p.getElements().attrTypeNameLinks());
        for (WImport imp2 : p.getImports()) {
            WPackage imported;
            if (!imp2.getIsPublic() || (imported = imp2.attrImportedPackage()) == null) continue;
            Exports.addExportedTypeNameLinks(result, imported, alreadyImported);
        }
    }
}

