/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.utils.Utils;

public class CompilationUnitInfo {
    private String file = "";
    private ErrorHandler cuErrorHandler;
    private IndentationMode indentationMode = IndentationMode.spaces(4);

    public CompilationUnitInfo(ErrorHandler cuErrorHandler) {
        this.cuErrorHandler = cuErrorHandler;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public ErrorHandler getCuErrorHandler() {
        return this.cuErrorHandler;
    }

    public void setCuErrorHandler(ErrorHandler errorHandler) {
        this.cuErrorHandler = errorHandler;
    }

    public IndentationMode getIndentationMode() {
        return this.indentationMode;
    }

    public void setIndentationMode(IndentationMode indentationMode) {
        this.indentationMode = indentationMode;
    }

    public static interface IndentationMode {
        public static IndentationMode tabs() {
            return new IndentationMode(){

                @Override
                public String getIndent() {
                    return "\t";
                }

                @Override
                public int countIndents(int startColumn) {
                    return startColumn;
                }
            };
        }

        public static IndentationMode spaces(final int num) {
            final String indent = Utils.repeat(' ', num);
            return new IndentationMode(){

                @Override
                public String getIndent() {
                    return indent;
                }

                @Override
                public int countIndents(int startColumn) {
                    return startColumn / num;
                }
            };
        }

        public String getIndent();

        public int countIndents(int var1);

        default public void appendIndent(StringBuilder sb, int counts) {
            for (int i = 0; i < counts; ++i) {
                sb.append(this.getIndent());
            }
        }
    }
}

