/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.mpq;

import com.google.common.base.Preconditions;
import de.peeeq.wurstio.mpq.MpqEditor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import systems.crigges.jmpq3.JMpqEditor;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.MPQOpenOption;

class Jmpq3BasedEditor
implements MpqEditor {
    private final JMpqEditor editor;

    private JMpqEditor getEditor() {
        return this.editor;
    }

    public Jmpq3BasedEditor(File mpqArchive, boolean readonly) throws Exception {
        Preconditions.checkNotNull((Object)mpqArchive);
        if (!mpqArchive.exists()) {
            throw new FileNotFoundException("not found: " + mpqArchive);
        }
        this.editor = new JMpqEditor(mpqArchive, new MPQOpenOption[]{readonly ? MPQOpenOption.READ_ONLY : MPQOpenOption.FORCE_V0});
    }

    @Override
    public void insertFile(String filenameInMpq, byte[] contents) {
        this.getEditor().insertByteArray(filenameInMpq, contents);
    }

    @Override
    public void insertFile(String filenameInMpq, File contents) throws Exception {
        this.getEditor().insertFile(filenameInMpq, contents, false);
    }

    @Override
    public boolean canWrite() {
        return this.editor.isCanWrite();
    }

    @Override
    public byte[] extractFile(String fileToExtract) throws Exception {
        return this.getEditor().extractFileAsBytes(fileToExtract);
    }

    @Override
    public void deleteFile(String filenameInMpq) {
        this.getEditor().deleteFile(filenameInMpq);
    }

    @Override
    public void close() throws IOException {
        try {
            this.editor.close();
        }
        catch (JMpqException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasFile(String fileName) {
        return this.getEditor().hasFile(fileName);
    }

    @Override
    public void setKeepHeaderOffset(boolean flag) {
        this.editor.setKeepHeaderOffset(flag);
    }
}

