/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;

public class MapHeader {
    public static final Id START_TOKEN = Id.valueOf("HM3W");
    public static final long HEADER_BYTES_SIZE = 512L;
    private int _unknown;
    private String _mapName;
    private int _flags;
    private int _maxPlayersCount;

    public int getUnknown() {
        return this._unknown;
    }

    public void setUnknown(int unknown) {
        this._unknown = unknown;
    }

    @Nullable
    private String getMapName() {
        return this._mapName;
    }

    public void setMapName(@Nullable String mapName) {
        this._mapName = mapName;
    }

    public int getFlags() {
        return this._flags;
    }

    public int getMaxPlayersCount() {
        return this._maxPlayersCount;
    }

    public void setMaxPlayersCount(int val) {
        this._maxPlayersCount = val;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public void writeToMapFile(@Nonnull File file) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Wc3BinOutputStream stream = new Wc3BinOutputStream(byteStream);
        Writer writer = new Writer(stream);
        writer.exec(this);
        stream.close();
        byte[] bytes = byteStream.toByteArray();
        RandomAccessFile fp = new RandomAccessFile(file, "r");
        byte[] startTokenBytes = new byte[4];
        fp.read(startTokenBytes, 0, startTokenBytes.length);
        fp.close();
        Id startToken = Id.valueOf(new String(startTokenBytes, StandardCharsets.US_ASCII));
        if (!startToken.equals(START_TOKEN)) {
            fp = new RandomAccessFile(file, "rw");
            long length = fp.length();
            long endPos = length - 1L;
            int maxChunkSize = 0x3FFFFFFF;
            int chunkSize = (int)Math.min(length, (long)maxChunkSize);
            long startPos = endPos - (long)chunkSize + 1L;
            while (chunkSize > 0) {
                fp.seek(startPos);
                byte[] chunkBytes = new byte[chunkSize];
                fp.read(chunkBytes, 0, chunkBytes.length);
                fp.write(chunkBytes);
                length = startPos;
                chunkSize = (int)Math.min(length, (long)maxChunkSize);
                endPos = startPos - 1L;
                startPos = endPos - (long)chunkSize + 1L;
            }
        } else {
            fp = new RandomAccessFile(file, "rw");
        }
        fp.write(bytes);
        fp.close();
    }

    public static MapHeader ofFile(@Nonnull File file) throws IOException {
        Wc3BinInputStream stream = new Wc3BinInputStream(file);
        Reader reader = new Reader(stream);
        MapHeader mapHeader = reader.exec();
        stream.close();
        return mapHeader;
    }

    public static class Reader
    extends net.moonlightflower.wc3libs.bin.Reader<EncodingFormat> {
        private MapHeader _mapHeader;

        public Reader(@Nonnull Wc3BinInputStream stream) {
            super(stream);
        }

        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        @Nonnull
        public MapHeader exec() throws IOException {
            return this.exec(new MapHeader());
        }

        private MapHeader exec(@Nonnull MapHeader mapHeader) throws IOException {
            this._mapHeader = mapHeader;
            this.read((EncodingFormat)this.getFormat());
            return this._mapHeader;
        }

        @Nonnull
        private MapHeader read(@Nonnull EncodingFormat format) throws IOException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case AUTO: {
                    return this.read_auto();
                }
                case MAP_HEADER_0x0: {
                    return this.read_0x0();
                }
            }
            throw new Format.InvalidFormatException(format);
        }

        @Nonnull
        private MapHeader read_0x0() throws BinStream.StreamException {
            Wc3BinInputStream stream = this.getStream();
            Id startToken = stream.readId("startToken");
            this._mapHeader._unknown = stream.readInt32("unknown");
            this._mapHeader._mapName = stream.readString("mapName");
            this._mapHeader._flags = stream.readInt32("flags");
            this._mapHeader._maxPlayersCount = stream.readInt32("maxPlayersCount");
            return this._mapHeader;
        }

        @Nonnull
        private MapHeader read_auto() throws IOException {
            return this.read_0x0();
        }
    }

    public static class Writer
    extends net.moonlightflower.wc3libs.bin.Writer<EncodingFormat> {
        private MapHeader _mapHeader;

        @Override
        public EncodingFormat getAutoFormat() {
            return EncodingFormat.AUTO;
        }

        private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            long startPos = stream.getPos();
            stream.writeId(START_TOKEN);
            stream.writeInt32(this._mapHeader._unknown);
            stream.writeString(this._mapHeader._mapName);
            stream.writeInt32(this._mapHeader._flags);
            stream.writeInt32(this._mapHeader._maxPlayersCount);
            long fillBytesSize = 512L - stream.getPos() - startPos;
            if (fillBytesSize > 0L) {
                int fillBytesSizeI;
                do {
                    fillBytesSizeI = (int)fillBytesSize;
                    stream.writeBytes(new byte[fillBytesSizeI]);
                } while ((fillBytesSize -= (long)fillBytesSizeI) > 0L);
            }
        }

        public void exec(@Nonnull MapHeader mapHeader) throws BinStream.StreamException {
            this._mapHeader = mapHeader;
            switch ((EncodingFormat.Enum)((Object)((EncodingFormat)this.getFormat()).toEnum())) {
                case AUTO: 
                case MAP_HEADER_0x0: {
                    this.write_0x0(this.getStream());
                }
            }
        }

        public Writer(@Nonnull Wc3BinOutputStream stream) {
            super(stream);
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, null);
        public static final EncodingFormat MAP_HEADER_0x0 = new EncodingFormat(Enum.MAP_HEADER_0x0, (Integer)11);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, @Nullable Integer version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            MAP_HEADER_0x0;

        }
    }
}

