/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.bin.app.objMod.W3A;
import net.moonlightflower.wc3libs.bin.app.objMod.W3B;
import net.moonlightflower.wc3libs.bin.app.objMod.W3D;
import net.moonlightflower.wc3libs.bin.app.objMod.W3H;
import net.moonlightflower.wc3libs.bin.app.objMod.W3Q;
import net.moonlightflower.wc3libs.bin.app.objMod.W3T;
import net.moonlightflower.wc3libs.bin.app.objMod.W3U;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.War3Num;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.MetaFieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.misc.Printable;
import net.moonlightflower.wc3libs.misc.Printer;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.slk.MetaSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;
import net.moonlightflower.wc3libs.slk.app.meta.CommonMetaSLK;
import net.moonlightflower.wc3libs.txt.Profile;
import net.moonlightflower.wc3libs.txt.TXTSectionId;

public abstract class ObjMod<ObjType extends Obj>
implements Printable {
    private EncodingFormat _format;
    protected final Map<ObjId, ObjType> _objs = new LinkedHashMap<ObjId, ObjType>();
    private final List<ObjType> _objsList = new ArrayList<ObjType>();

    public EncodingFormat getFormat() {
        return this._format;
    }

    public void setFormat(@Nonnull EncodingFormat format) {
        this._format = format;
    }

    @Nonnull
    public Map<ObjId, ObjType> getObjs() {
        return this._objs;
    }

    @Nonnull
    public List<ObjType> getObjsList() {
        return this._objsList;
    }

    @Nonnull
    public List<ObjType> getOrigObjs() {
        ArrayList<Obj> ret = new ArrayList<Obj>();
        for (int i = 0; i < this.getObjsList().size(); ++i) {
            Obj obj = (Obj)this.getObjsList().get(i);
            if (obj.getNewId() != null) continue;
            ret.add(obj);
        }
        return ret;
    }

    @Nonnull
    public List<ObjType> getCustomObjs() {
        ArrayList<Obj> ret = new ArrayList<Obj>();
        for (int i = 0; i < this.getObjsList().size(); ++i) {
            Obj obj = (Obj)this.getObjsList().get(i);
            if (obj.getNewId() == null) continue;
            ret.add(obj);
        }
        return ret;
    }

    public boolean containsObj(@Nonnull ObjId id) {
        return this._objs.containsKey(id);
    }

    @Nullable
    public ObjType getObj(@Nonnull ObjId id) {
        return (ObjType)((Obj)this.getObjs().get(id));
    }

    private void addObj(@Nonnull ObjType val) {
        this._objs.put(((Obj)val).getId(), val);
        this._objsList.add(val);
    }

    public void removeObj(@Nonnull ObjType val) {
        this._objs.remove(((Obj)val).getId());
        this._objsList.remove(val);
    }

    public void removeObj(@Nonnull ObjId id) {
        ObjType obj = this.getObj(id);
        if (obj != null) {
            this.removeObj(obj);
        }
    }

    public void clearObjs() {
        this._objs.clear();
        this._objsList.clear();
    }

    protected abstract ObjType createObj(@Nonnull ObjId var1, @Nullable ObjId var2);

    public Obj addObj(@Nonnull ObjId id, @Nullable ObjId baseId) {
        if (this.getObjs().containsKey(id)) {
            return (Obj)this.getObjs().get(id);
        }
        ObjType obj = this.createObj(id, baseId);
        this.addObj(obj);
        return obj;
    }

    public void merge(@Nonnull ObjMod<ObjType> other) {
        for (Map.Entry<ObjId, ObjType> entry : other.getObjs().entrySet()) {
            Object obj;
            if (this._objs.containsKey(entry.getKey())) {
                obj = (Obj)this._objs.get(entry.getKey());
                ((Obj)entry.getValue()).getMods().forEach(arg_0 -> obj.addMod(arg_0));
                continue;
            }
            obj = ((Obj)entry.getValue()).copy();
            this.addObj(obj);
        }
    }

    @Nonnull
    public abstract ObjMod<ObjType> copy();

    @Override
    public void print(@Nonnull Printer printer) {
        printer.beginGroup(this.getClass().getSimpleName());
        for (Obj obj : this.getObjs().values()) {
            obj.print(printer);
        }
        printer.endGroup();
    }

    public abstract Collection<File> getSLKs();

    public abstract Collection<File> getNecessarySLKs();

    @Nonnull
    public ObjPack reduce(@Nonnull MetaSLK reduceMetaSlk, Collection<Class<? extends ObjMod>> excludedClasses) throws Exception {
        ObjPack pack = new ObjPack(this);
        if (excludedClasses.contains(this.getClass())) {
            return pack;
        }
        Map<File, SLK> outSlks = pack.getSlks();
        Profile outProfile = pack.getProfile();
        ObjMod outObjMod = pack.getObjMod();
        for (Obj obj : this.getObjs().values()) {
            ObjId objId = obj.getId();
            for (Obj.Mod mod : obj.getMods()) {
                MetaFieldId fieldId = mod.getId();
                ObjId metaObjId = ObjId.valueOf(fieldId);
                Object metaObj = reduceMetaSlk.getObj(metaObjId);
                if (metaObj == null) continue;
                String slkName = ((SLK.Obj)metaObj).getS(FieldId.valueOf("slk"));
                String slkFieldName = ((SLK.Obj)metaObj).getS(FieldId.valueOf("field"));
                if (slkName.equals("Profile")) {
                    Object outObj;
                    int level = mod instanceof Obj.ExtendedMod ? ((Obj.ExtendedMod)mod).getLevel() : 0;
                    DataType val = mod.getVal();
                    int index = level == 0 ? 0 : level - 1;
                    int metaIndex = War3Int.valueOf(((SLK.Obj)metaObj).get(FieldId.valueOf("index"), War3Int.valueOf(0))).getVal();
                    if (metaIndex > 0) {
                        index += metaIndex;
                    }
                    Profile.Obj profileObj = outProfile.addObj(TXTSectionId.valueOf(objId.toString()));
                    for (File necessarySlkFile : this.getNecessarySLKs()) {
                        SLK necessarySlk = outSlks.computeIfAbsent(necessarySlkFile, k -> new RawSLK());
                        necessarySlk.addObj(objId);
                    }
                    FieldId profileFieldId = FieldId.valueOf(slkFieldName);
                    Profile.Obj.Field profileField = profileObj.addField(profileFieldId);
                    DataType profileVal = null;
                    if (((SLK.Obj)metaObj).getS(FieldId.valueOf("type")).endsWith("List")) {
                        profileVal = val;
                        if (profileVal != null) {
                            String[] vals = profileVal.toString().split(",");
                            for (int i = 0; i < vals.length; ++i) {
                                profileField.set(War3String.valueOf(vals[i]), index + i);
                            }
                        }
                    } else {
                        profileVal = val;
                        profileField.set(profileVal, index);
                    }
                    if ((outObj = outObjMod.getObj(objId)) == null) continue;
                    ((Obj)outObj).remove(mod);
                    continue;
                }
                File slkFile = CommonMetaSLK.convertSLKName(slkName);
                if (slkFile == null) {
                    throw new RuntimeException("no slkFile for name " + slkName);
                }
                SLK outSlk = outSlks.computeIfAbsent(slkFile, k -> new RawSLK());
                int level = mod instanceof Obj.ExtendedMod ? ((Obj.ExtendedMod)mod).getLevel() : 0;
                DataType val = mod.getVal();
                FieldId slkFieldIdAdjusted = CommonMetaSLK.getSLKField(slkFile, metaObj, level);
                outSlk.addField(slkFieldIdAdjusted);
                Object slkObj = outSlk.addObj(objId);
                for (File necessarySlkFile : this.getNecessarySLKs()) {
                    SLK necessarySlk = outSlks.computeIfAbsent(necessarySlkFile, k -> new RawSLK());
                    necessarySlk.addObj(objId);
                }
                ((SLK.Obj)slkObj).set(slkFieldIdAdjusted, (DataType)War3String.valueOf(val));
                Object outObj = outObjMod.getObj(objId);
                if (outObj == null) continue;
                ((Obj)outObj).remove(mod);
            }
            Object outObj = outObjMod.getObj(objId);
            if (outObj == null) continue;
            ((Obj)outObj).remove(MetaFieldId.valueOf("wurs"));
            if (((Obj)outObj).getFields().isEmpty()) {
                outObjMod.removeObj(objId);
                continue;
            }
            outObjMod.removeObj(objId);
            outObjMod.addObj(objId, null).merge((Obj)outObj);
        }
        for (Map.Entry entry : outSlks.entrySet()) {
            SLK convSlk = SLK.createFromInFile((File)entry.getKey(), (SLK)entry.getValue());
            outSlks.put((File)entry.getKey(), convSlk);
        }
        return pack;
    }

    private void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.OBJ_0x1.getVersion(), version);
        this._format = EncodingFormat.valueOf(version);
        int origObjsAmount = stream.readInt32("origObjsAmount");
        for (int i = 0; i < origObjsAmount; ++i) {
            ObjId baseId = ObjId.valueOf(stream.readId("baseId"));
            ObjId id = ObjId.valueOf(stream.readId("objId"));
            ObjType obj = this.createObj(id, null);
            ((Obj)obj).read(stream, EncodingFormat.OBJ_0x1);
            this.addObj(obj);
        }
        int customObjsAmount = stream.readInt32("customObjsAmount");
        for (int i = 0; i < customObjsAmount; ++i) {
            ObjId baseId = ObjId.valueOf(stream.readId("baseId"));
            ObjId id = ObjId.valueOf(stream.readId("objId"));
            ObjType obj = this.createObj(baseId, baseId);
            ((Obj)obj).read(stream, EncodingFormat.OBJ_0x1);
            this.addObj(obj);
        }
    }

    @Nonnull
    protected abstract ObjType createObj(@Nonnull Wc3BinInputStream var1, @Nonnull EncodingFormat var2) throws BinStream.StreamException;

    private void read_0x2(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.OBJ_0x2.getVersion(), version);
        this._format = EncodingFormat.valueOf(version);
        int origObjsAmount = stream.readInt32("origObjsAmount");
        for (int i = 0; i < origObjsAmount; ++i) {
            ObjType obj = this.createObj(stream, EncodingFormat.OBJ_0x2);
            this.addObj(obj);
        }
        int customObjsAmount = stream.readInt32("customObjsAmount");
        for (int i = 0; i < customObjsAmount; ++i) {
            ObjType obj = this.createObj(stream, EncodingFormat.OBJ_0x2);
            this.addObj(obj);
        }
    }

    private void read_0x3(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.OBJ_0x3.getVersion(), version);
        this._format = EncodingFormat.valueOf(version);
        int origObjsAmount = stream.readInt32("origObjsAmount");
        for (int i = 0; i < origObjsAmount; ++i) {
            ObjType obj = this.createObj(stream, EncodingFormat.OBJ_0x3);
            this.addObj(obj);
        }
        int customObjsAmount = stream.readInt32("customObjsAmount");
        for (int i = 0; i < customObjsAmount; ++i) {
            ObjType obj = this.createObj(stream, EncodingFormat.OBJ_0x3);
            this.addObj(obj);
        }
    }

    private void write_0x1(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        stream.writeInt32(EncodingFormat.OBJ_0x1.getVersion());
        stream.writeInt32(this.getOrigObjs().size());
        for (Obj obj : this.getOrigObjs()) {
            obj.write(stream, EncodingFormat.OBJ_0x1);
        }
        stream.writeInt32(this.getCustomObjs().size());
        for (Obj obj : this.getCustomObjs()) {
            obj.write(stream, EncodingFormat.OBJ_0x1);
        }
    }

    private void write_0x2(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        Obj obj;
        int i;
        stream.writeInt32(EncodingFormat.OBJ_0x2.getVersion());
        stream.writeInt32(this.getOrigObjs().size());
        for (i = 0; i < this.getOrigObjs().size(); ++i) {
            obj = (Obj)this.getOrigObjs().get(i);
            obj.write(stream, EncodingFormat.OBJ_0x2);
        }
        stream.writeInt32(this.getCustomObjs().size());
        for (i = 0; i < this.getCustomObjs().size(); ++i) {
            obj = (Obj)this.getCustomObjs().get(i);
            obj.write(stream, EncodingFormat.OBJ_0x2);
        }
    }

    private void write_0x3(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        Obj obj;
        int i;
        stream.writeInt32(EncodingFormat.OBJ_0x3.getVersion());
        stream.writeInt32(this.getOrigObjs().size());
        for (i = 0; i < this.getOrigObjs().size(); ++i) {
            obj = (Obj)this.getOrigObjs().get(i);
            obj.write(stream, EncodingFormat.OBJ_0x3);
        }
        stream.writeInt32(this.getCustomObjs().size());
        for (i = 0; i < this.getCustomObjs().size(); ++i) {
            obj = (Obj)this.getCustomObjs().get(i);
            obj.write(stream, EncodingFormat.OBJ_0x3);
        }
    }

    private void write_as_defined(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)this._format.toEnum())) {
            case OBJ_0x1: {
                this.write_0x1(stream);
                break;
            }
            case OBJ_0x2: {
                this.write_0x2(stream);
                break;
            }
            case OBJ_0x3: {
                this.write_0x3(stream);
            }
        }
    }

    private void read_as_defined(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        int version = stream.readInt32("version");
        stream.rewind();
        EncodingFormat format = EncodingFormat.valueOf(version);
        if (format == null) {
            throw new IllegalArgumentException("unknown format " + version);
        }
        this.read(stream, format);
    }

    public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: 
            case AS_DEFINED: {
                this.read_as_defined(stream);
                break;
            }
            case OBJ_0x1: {
                this.read_0x1(stream);
                break;
            }
            case OBJ_0x2: {
                this.read_0x2(stream);
                break;
            }
            case OBJ_0x3: {
                this.read_0x3(stream);
            }
        }
    }

    public void read(@Nonnull Wc3BinInputStream stream) throws IOException {
        this.read(stream, EncodingFormat.AUTO);
    }

    public void read(@Nonnull InputStream inStream) throws IOException {
        this.read(new Wc3BinInputStream(inStream), EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AS_DEFINED: {
                this.write_as_defined(stream);
                break;
            }
            case OBJ_0x3: 
            case AUTO: {
                this.write_0x3(stream);
                break;
            }
            case OBJ_0x2: {
                this.write_0x2(stream);
                break;
            }
            case OBJ_0x1: {
                this.write_0x1(stream);
            }
        }
    }

    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, EncodingFormat.AUTO);
    }

    public ObjMod(@Nonnull Wc3BinInputStream stream) throws IOException {
        this.read(stream);
    }

    public ObjMod(@Nonnull File file) throws IOException {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    public ObjMod() {
    }

    @Nullable
    public static ObjMod createFromInFile(@Nonnull File inFile, @Nonnull File outFile) throws Exception {
        ObjMod ret = null;
        if (inFile.equals(W3A.GAME_PATH)) {
            ret = new W3A(outFile);
        }
        if (inFile.equals(W3B.GAME_PATH)) {
            ret = new W3B(outFile);
        }
        if (inFile.equals(W3D.GAME_PATH)) {
            ret = new W3D(outFile);
        }
        if (inFile.equals(W3H.GAME_PATH)) {
            ret = new W3H(outFile);
        }
        if (inFile.equals(W3Q.GAME_PATH)) {
            ret = new W3Q(outFile);
        }
        if (inFile.equals(W3T.GAME_PATH)) {
            ret = new W3T(outFile);
        }
        if (inFile.equals(W3U.GAME_PATH)) {
            ret = new W3U(outFile);
        }
        return ret;
    }

    @Nullable
    public static ObjMod createFromInFile(@Nonnull File inFile) {
        ObjMod ret = null;
        if (inFile.equals(W3A.GAME_PATH)) {
            ret = new W3A();
        }
        if (inFile.equals(W3B.GAME_PATH)) {
            ret = new W3B();
        }
        if (inFile.equals(W3D.GAME_PATH)) {
            ret = new W3D();
        }
        if (inFile.equals(W3H.GAME_PATH)) {
            ret = new W3H();
        }
        if (inFile.equals(W3Q.GAME_PATH)) {
            ret = new W3Q();
        }
        if (inFile.equals(W3T.GAME_PATH)) {
            ret = new W3T();
        }
        if (inFile.equals(W3U.GAME_PATH)) {
            ret = new W3U();
        }
        return ret;
    }

    public static <T extends ObjMod> T create(@Nonnull Class<T> clazz) {
        try {
            return (T)((ObjMod)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nonnull
    public static <T extends ObjMod> T ofMapFile(@Nonnull Class<T> clazz, @Nonnull File mapFile) throws IOException {
        if (!mapFile.exists()) {
            throw new IOException(String.format("file %s does not exist", mapFile));
        }
        JMpqPort.Out port = new JMpqPort.Out();
        try {
            File inFilePath = (File)clazz.getField("GAME_PATH").get(null);
            port.add(inFilePath);
            MpqPort.Out.Result portResult = port.commit(mapFile);
            if (!portResult.getExports().containsKey(inFilePath)) {
                throw new IOException("could not extract w3a file");
            }
            Wc3BinInputStream inStream = new Wc3BinInputStream(portResult.getInputStream(inFilePath));
            T objMod = ObjMod.create(clazz);
            ((ObjMod)objMod).read(inStream);
            inStream.close();
            return objMod;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class EncodingFormat
    extends Format<Enum> {
        private static final Map<Integer, EncodingFormat> _map = new LinkedHashMap<Integer, EncodingFormat>();
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, (Integer)-1);
        public static final EncodingFormat AS_DEFINED = new EncodingFormat(Enum.AS_DEFINED, null);
        public static final EncodingFormat OBJ_0x1 = new EncodingFormat(Enum.OBJ_0x1, (Integer)1);
        public static final EncodingFormat OBJ_0x2 = new EncodingFormat(Enum.OBJ_0x2, (Integer)2);
        public static final EncodingFormat OBJ_0x3 = new EncodingFormat(Enum.OBJ_0x3, (Integer)3);

        @Nullable
        public static EncodingFormat valueOf(int version) {
            return _map.get(version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, @Nullable Integer version) {
            super(enumVal, version);
            if (version != null) {
                _map.put(version, this);
            }
        }

        public static enum Enum {
            AUTO,
            AS_DEFINED,
            OBJ_0x1,
            OBJ_0x2,
            OBJ_0x3;

        }
    }

    public static class ObjPack<ObjType extends Obj> {
        private Map<ObjId, ObjId> _baseObjIds = new LinkedHashMap<ObjId, ObjId>();
        private Map<File, SLK> _slks = new LinkedHashMap<File, SLK>();
        private Profile _profile = new Profile();
        private ObjMod<ObjType> _objMod;

        public Map<ObjId, ObjId> getBaseObjIds() {
            return this._baseObjIds;
        }

        public Map<File, SLK> getSlks() {
            return this._slks;
        }

        public Profile getProfile() {
            return this._profile;
        }

        public ObjMod<ObjType> getObjMod() {
            return this._objMod;
        }

        private ObjPack(@Nonnull ObjMod<ObjType> orig) {
            this._objMod = orig.copy();
            for (Obj obj : this._objMod.getCustomObjs()) {
                this._baseObjIds.put(obj.getId(), obj.getBaseId());
            }
        }
    }

    public static abstract class Obj
    implements Printable {
        private List<Mod> _mods = new ArrayList<Mod>();
        private Map<MetaFieldId, List<Mod>> _modsMap = new LinkedHashMap<MetaFieldId, List<Mod>>();
        private ObjId _id;
        private ObjId _baseId;
        protected ObjId _newId;
        private int[] _unknown;

        public abstract boolean isExtended();

        @Nonnull
        public List<Mod> getMods() {
            return this._mods;
        }

        @Nonnull
        public Map<MetaFieldId, List<Mod>> getModsMapByField() {
            return this._modsMap;
        }

        @Nonnull
        public Set<MetaFieldId> getFields() {
            return this._modsMap.keySet();
        }

        @Nonnull
        public List<Mod> getModsOfField(@Nonnull MetaFieldId fieldId) {
            return this._modsMap.getOrDefault(fieldId, new ArrayList());
        }

        public void addMod(@Nonnull Mod mod) {
            this._mods.add(mod);
            MetaFieldId id = mod.getId();
            if (!this._modsMap.containsKey(id)) {
                this._modsMap.put(id, new ArrayList());
            }
            this._modsMap.get(id).add(mod);
        }

        @Nullable
        public DataType get(@Nonnull MetaFieldId id) {
            List<Mod> modsMapList = this._modsMap.get(id);
            if (modsMapList == null) {
                return null;
            }
            Mod mod = modsMapList.get(0);
            if (mod == null) {
                return null;
            }
            return mod.getVal();
        }

        public void set(@Nonnull MetaFieldId id, @Nullable DataType val) {
            Mod mod = new Mod(id, val);
            if (this._modsMap.containsKey(id)) {
                this._mods.removeIf(filterMod -> filterMod._id.equals(id));
                this._modsMap.remove(id);
            }
            this._mods.add(mod);
            this._modsMap.put(id, new ArrayList());
            this._modsMap.get(id).add(mod);
        }

        public void remove(@Nonnull Mod mod) {
            this._mods.remove(mod);
            List<Mod> modsMapList = this._modsMap.get(mod.getId());
            if (modsMapList != null) {
                modsMapList.remove(mod);
                if (modsMapList.isEmpty()) {
                    this._modsMap.remove(mod.getId());
                }
            }
        }

        public void remove(@Nonnull MetaFieldId id) {
            this._mods.removeIf(mod -> mod.getId().equals(id));
            this._modsMap.remove(id);
        }

        public void merge(@Nonnull Obj otherObj) {
            for (Map.Entry<MetaFieldId, List<Mod>> otherModEntry : otherObj.getModsMapByField().entrySet()) {
                MetaFieldId fieldId = otherModEntry.getKey();
                List<Mod> otherModsList = otherModEntry.getValue();
                List modsList = this._modsMap.getOrDefault(fieldId, new ArrayList());
                for (int i = 0; i < otherModsList.size(); ++i) {
                    if (modsList.size() <= i) {
                        modsList.add(otherModsList.get(i));
                        continue;
                    }
                    modsList.set(i, otherModsList.get(i));
                }
            }
        }

        @Nonnull
        public ObjId getId() {
            return this._id;
        }

        @Nullable
        public ObjId getBaseId() {
            return this._baseId;
        }

        @Nullable
        public ObjId getNewId() {
            return this._newId;
        }

        public int[] getUnknown() {
            return this._unknown;
        }

        public void setUnknown(int[] value) {
            this._unknown = value;
        }

        public String toString() {
            if (this.getBaseId() == null) {
                return String.format("%s", this.getId().toString());
            }
            return String.format("%s (%s)", this.getId().toString(), this.getBaseId().toString());
        }

        @Override
        public void print(@Nonnull Printer printer) {
            printer.beginGroup(String.format("%s %s", this.getId(), this.getBaseId()));
            for (Map.Entry<MetaFieldId, List<Mod>> modEntry : this.getModsMapByField().entrySet()) {
                MetaFieldId fieldId = modEntry.getKey();
                List<Mod> modsList = modEntry.getValue();
                printer.beginGroup(String.format("%s", fieldId));
                for (Mod mod : modsList) {
                    mod.print(printer);
                }
                printer.endGroup();
            }
            printer.endGroup();
        }

        private void read_0x1(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this._baseId = ObjId.valueOf(stream.readId("baseId"));
            this._newId = ((Function<Id, ObjId>)id -> {
                if (id.equals(Id.valueOf("\u0000\u0000\u0000\u0000"))) {
                    return null;
                }
                return ObjId.valueOf(id);
            }).apply(stream.readId("newId"));
            this._id = this._newId == null ? this._baseId : this._newId;
            int modsAmount = stream.readInt32("modsAmount");
            for (int i = 0; i < modsAmount; ++i) {
                DataType val;
                MetaFieldId fieldId = MetaFieldId.valueOf(stream.readId("fieldId"));
                int varTypeI = stream.readInt32("varType");
                ValType varType = ValType.valueOf(varTypeI);
                int level = 0;
                int dataPt = 0;
                if (this.isExtended()) {
                    level = stream.readInt32("level/variation");
                    dataPt = stream.readInt32("dataPt");
                }
                switch (varType) {
                    case INT: {
                        val = War3Int.valueOf(stream.readInt32("val (int)"));
                        break;
                    }
                    case REAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (real)"));
                        break;
                    }
                    case UNREAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (unreal)"));
                        break;
                    }
                    case STRING: {
                        val = War3String.valueOf(stream.readString("val (string) "));
                        break;
                    }
                    default: {
                        val = War3String.valueOf(stream.readString("val (string default)"));
                    }
                }
                Mod mod = this.isExtended() ? new ExtendedMod(fieldId, varType, val, level, dataPt) : new Mod(fieldId, varType, val);
                mod._endToken = stream.readId("endToken");
                this.addMod(mod);
            }
        }

        private void read_0x2(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this._baseId = ObjId.valueOf(stream.readId("baseId"));
            this._newId = ((Function<Id, ObjId>)id -> {
                if (id.equals(Id.valueOf("\u0000\u0000\u0000\u0000"))) {
                    return null;
                }
                return ObjId.valueOf(id);
            }).apply(stream.readId("newId"));
            this._id = this._newId == null ? this._baseId : this._newId;
            int modsAmount = stream.readInt32("modsAmount");
            for (int i = 0; i < modsAmount; ++i) {
                DataType val;
                MetaFieldId fieldId = MetaFieldId.valueOf(stream.readId("fieldId"));
                int varTypeI = stream.readInt32("varType");
                ValType varType = ValType.valueOf(varTypeI);
                int level = 0;
                int dataPt = 0;
                if (this.isExtended()) {
                    level = stream.readInt32("level/variation");
                    dataPt = stream.readInt32("dataPt");
                }
                switch (varType) {
                    case INT: {
                        val = War3Int.valueOf(stream.readInt32("val (int)"));
                        break;
                    }
                    case REAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (real)"));
                        break;
                    }
                    case UNREAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (unreal)"));
                        break;
                    }
                    case STRING: {
                        val = War3String.valueOf(stream.readString("val (string)"));
                        break;
                    }
                    default: {
                        val = War3String.valueOf(stream.readString("val (string default)"));
                    }
                }
                Mod mod = this.isExtended() ? new ExtendedMod(fieldId, varType, val, level, dataPt) : new Mod(fieldId, varType, val);
                mod._endToken = stream.readId("endToken");
                this.addMod(mod);
            }
        }

        private void read_0x3(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this._baseId = ObjId.valueOf(stream.readId("baseId"));
            this._newId = ((Function<Id, ObjId>)id -> {
                if (id.equals(Id.valueOf("\u0000\u0000\u0000\u0000"))) {
                    return null;
                }
                return ObjId.valueOf(id);
            }).apply(stream.readId("newId"));
            this._id = this._newId == null ? this._baseId : this._newId;
            int unknownAmount = stream.readInt32("unknownAmount");
            int[] unknown = new int[unknownAmount];
            for (int i = 0; i < unknownAmount; ++i) {
                unknown[i] = stream.readInt32("unknown" + i);
            }
            this._unknown = unknown;
            int modsAmount = stream.readInt32("modsAmount");
            for (int i = 0; i < modsAmount; ++i) {
                DataType val;
                MetaFieldId fieldId = MetaFieldId.valueOf(stream.readId("fieldId"));
                int varTypeI = stream.readInt32("varType");
                ValType varType = ValType.valueOf(varTypeI);
                int level = 0;
                int dataPt = 0;
                if (this.isExtended()) {
                    level = stream.readInt32("level/variation");
                    dataPt = stream.readInt32("dataPt");
                }
                switch (varType) {
                    case INT: {
                        val = War3Int.valueOf(stream.readInt32("val (int)"));
                        break;
                    }
                    case REAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (real)"));
                        break;
                    }
                    case UNREAL: {
                        val = War3Real.valueOf(stream.readFloat32("val (unreal)"));
                        break;
                    }
                    case STRING: {
                        val = War3String.valueOf(stream.readString("val (string)"));
                        break;
                    }
                    default: {
                        val = War3String.valueOf(stream.readString("val (string default)"));
                    }
                }
                Mod mod = this.isExtended() ? new ExtendedMod(fieldId, varType, val, level, dataPt) : new Mod(fieldId, varType, val);
                mod._endToken = stream.readId("endToken");
                this.addMod(mod);
            }
        }

        private void write_0x1(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            stream.writeId(this._baseId == null ? this._id : this._baseId);
            stream.writeId(this._newId == null ? Id.valueOf("\u0000\u0000\u0000\u0000") : this._newId);
            int modsAmount = this._mods.size();
            stream.writeInt32(modsAmount);
            for (Mod mod : this._mods) {
                MetaFieldId id = mod.getId();
                int dataPt = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getDataPt() : 0;
                int level = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getLevel() : 0;
                ValType valType = mod.getValType() == null ? ValType.STRING : mod.getValType();
                DataType val = mod.getVal();
                stream.writeId(id);
                stream.writeInt32(valType.getVal());
                if (this.isExtended()) {
                    stream.writeInt32(level);
                    stream.writeInt32(dataPt);
                }
                switch (valType) {
                    case INT: {
                        if (!(val instanceof War3Int)) {
                            throw new BinStream.StreamException(stream, "no int: " + val);
                        }
                        stream.writeInt32(((War3Int)val).toInt());
                        break;
                    }
                    case REAL: 
                    case UNREAL: {
                        if (!(val instanceof War3Num)) {
                            throw new BinStream.StreamException(stream, "no real: " + val);
                        }
                        stream.writeFloat32(((War3Num)((Object)val)).toFloat());
                        break;
                    }
                    case STRING: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                        break;
                    }
                    default: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                    }
                }
                stream.writeId(mod.getEndToken());
            }
        }

        private void write_0x2(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            stream.writeId(this._baseId == null ? this._id : this._baseId);
            stream.writeId(this._newId == null ? Id.valueOf("\u0000\u0000\u0000\u0000") : this._newId);
            int modsAmount = this._mods.size();
            stream.writeInt32(modsAmount);
            for (Mod mod : this._mods) {
                MetaFieldId id = mod.getId();
                int dataPt = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getDataPt() : 0;
                int level = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getLevel() : 0;
                ValType valType = mod.getValType() == null ? ValType.STRING : mod.getValType();
                DataType val = mod.getVal();
                stream.writeId(id);
                stream.writeInt32(valType.getVal());
                if (this.isExtended()) {
                    stream.writeInt32(level);
                    stream.writeInt32(dataPt);
                }
                switch (valType) {
                    case INT: {
                        if (!(val instanceof War3Int)) {
                            throw new BinStream.StreamException(stream, "no int: " + val);
                        }
                        stream.writeInt32(((War3Int)val).toInt());
                        break;
                    }
                    case REAL: 
                    case UNREAL: {
                        if (!(val instanceof War3Num)) {
                            throw new BinStream.StreamException(stream, "no real: " + val);
                        }
                        stream.writeFloat32(((War3Num)((Object)val)).toFloat());
                        break;
                    }
                    case STRING: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                        break;
                    }
                    default: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                    }
                }
                stream.writeId(mod.getEndToken());
            }
        }

        private void write_0x3(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
            stream.writeId(this._baseId == null ? this._id : this._baseId);
            stream.writeId(this._newId == null ? Id.valueOf("\u0000\u0000\u0000\u0000") : this._newId);
            if (this._unknown != null && this._unknown.length > 0) {
                stream.writeInt32(this._unknown.length);
                for (int val : this._unknown) {
                    stream.writeInt32(val);
                }
            } else {
                stream.writeInt32(1);
                stream.writeInt32(0);
            }
            int modsAmount = this._mods.size();
            stream.writeInt32(modsAmount);
            for (Mod mod : this._mods) {
                MetaFieldId id = mod.getId();
                int dataPt = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getDataPt() : 0;
                int level = mod instanceof ExtendedMod ? ((ExtendedMod)mod).getLevel() : 0;
                ValType valType = mod.getValType() == null ? ValType.STRING : mod.getValType();
                DataType val = mod.getVal();
                stream.writeId(id);
                stream.writeInt32(valType.getVal());
                if (this.isExtended()) {
                    stream.writeInt32(level);
                    stream.writeInt32(dataPt);
                }
                switch (valType) {
                    case INT: {
                        if (!(val instanceof War3Int)) {
                            throw new BinStream.StreamException(stream, "no int: " + val);
                        }
                        stream.writeInt32(((War3Int)val).toInt());
                        break;
                    }
                    case REAL: 
                    case UNREAL: {
                        if (!(val instanceof War3Num)) {
                            throw new BinStream.StreamException(stream, "no real: " + val);
                        }
                        stream.writeFloat32(((War3Num)((Object)val)).toFloat());
                        break;
                    }
                    case STRING: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                        break;
                    }
                    default: {
                        String valS = val == null ? "" : val.toString();
                        stream.writeString(valS);
                    }
                }
                stream.writeId(mod.getEndToken());
            }
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            try {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case OBJ_0x1: {
                        this.read_0x1(stream);
                        break;
                    }
                    case OBJ_0x2: {
                        this.read_0x2(stream);
                        break;
                    }
                    case OBJ_0x3: {
                        this.read_0x3(stream);
                    }
                }
            }
            catch (RuntimeException e) {
                throw new BinStream.StreamException(stream);
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case OBJ_0x3: 
                case AUTO: {
                    this.write_0x3(stream);
                    break;
                }
                case OBJ_0x2: {
                    this.write_0x2(stream);
                    break;
                }
                case OBJ_0x1: {
                    this.write_0x1(stream);
                }
            }
        }

        protected abstract Obj copySpec();

        @Nonnull
        public <T extends Obj> T copy() {
            Obj ret = this.copySpec();
            ret._newId = this._newId;
            ret.merge(this);
            return (T)ret;
        }

        public Obj(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Obj(@Nonnull ObjId id, @Nullable ObjId baseId) {
            this._id = id;
            this._baseId = baseId;
            this._newId = this._baseId != null ? id : null;
        }

        public static class ExtendedMod
        extends Mod
        implements Printable {
            private int _level;
            private int _dataPt;

            public int getLevel() {
                return this._level;
            }

            public void setLevel(int value) {
                this._level = value;
            }

            public int getDataPt() {
                return this._dataPt;
            }

            public void setDataPt(int val) {
                this._dataPt = val;
            }

            public ExtendedMod(@Nonnull MetaFieldId id, @Nonnull ValType valType, @Nullable DataType val, int level, int dataPt) {
                super(id, valType, val);
                this._level = level;
                this._dataPt = dataPt;
            }

            public ExtendedMod(@Nonnull MetaFieldId id, @Nullable DataType val, int level, int dataPt) {
                super(id, val);
                this._level = level;
                this._dataPt = dataPt;
            }

            @Override
            public void print(@Nonnull Printer printer) {
                printer.print(String.format("%s (level %d, dataPt %d): %s", this._id, this._level, this._dataPt, this._val));
            }
        }

        public static class Mod
        implements Printable {
            protected MetaFieldId _id;
            private ValType _valType;
            protected DataType _val;
            private Id _endToken;

            public MetaFieldId getId() {
                return this._id;
            }

            @Nullable
            public ValType getValType() {
                return this._valType;
            }

            public void setVal(ValType valType) {
                this._valType = valType;
            }

            @Nullable
            public DataType getVal() {
                return this._val;
            }

            public void setVal(DataType value, ValType valType) {
                this._val = value;
                this._valType = valType;
            }

            public void setVal(DataType val) {
                this.setVal(val, this.getValTypeFromVal(val));
            }

            private ValType getValTypeFromVal(DataType val) {
                if (val == null || val instanceof War3Int) {
                    return ValType.INT;
                }
                if (val instanceof War3Real) {
                    if (ValType.UNREAL.equals((Object)this._valType)) {
                        return ValType.UNREAL;
                    }
                    return ValType.REAL;
                }
                return ValType.STRING;
            }

            public Id getEndToken() {
                return this._endToken;
            }

            public void setEndToken(Id value) {
                this._endToken = value;
            }

            public String toString() {
                return this.getId().toString();
            }

            public Mod(@Nonnull MetaFieldId id, @Nonnull ValType valType, @Nullable DataType val) {
                this._id = id;
                this._valType = valType;
                this._val = val;
            }

            public Mod(@Nonnull MetaFieldId id, @Nullable DataType val) {
                this._id = id;
                this._valType = null;
                this._val = val;
            }

            @Override
            public void print(@Nonnull Printer printer) {
                printer.print(String.format("%s: %s", this._id, this._val));
            }
        }
    }

    public static enum ValType {
        INT(0),
        REAL(1),
        UNREAL(2),
        STRING(3);

        private int _val;
        private static final Map<Integer, ValType> _map;

        public int getVal() {
            return this._val;
        }

        public static ValType valueOf(int val) {
            return _map.get(val);
        }

        private ValType(int val) {
            this._val = val;
        }

        static {
            _map = new LinkedHashMap<Integer, ValType>();
            for (ValType varType : ValType.values()) {
                _map.put(varType.getVal(), varType);
            }
        }
    }
}

