/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.parser.WPos;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.annotation.Nullable;

public class ErrorHandling {
    public static void addError(Element e, String msg) {
        ErrorHandling.addErrorOrWarning(e, msg, CompileError.ErrorType.ERROR);
    }

    public static void addWarning(Element e, String msg) {
        ErrorHandling.addErrorOrWarning(e, msg, CompileError.ErrorType.WARNING);
    }

    private static void addErrorOrWarning(Element e, String msg, CompileError.ErrorType errorType) throws CompileError {
        ErrorHandler handler = e.getErrorHandler();
        CompileError c = ErrorHandling.makeCompileError(e, msg, handler, errorType);
        if (c != null) {
            handler.sendError(c);
        }
    }

    private static @Nullable CompileError makeCompileError(Element e, String msg, ErrorHandler handler, CompileError.ErrorType errorType) throws CompileError {
        WPos pos = e.attrErrorPos();
        if (errorType == CompileError.ErrorType.ERROR && handler.isUnitTestMode()) {
            throw new CompileError(pos, msg);
        }
        ListIterator<CompileError> it = handler.getErrors().listIterator();
        while (it.hasNext()) {
            CompileError err = it.next();
            if (!err.getSource().getFile().equals(pos.getFile())) continue;
            if (ErrorHandling.bigger(err.getSource(), pos)) {
                it.remove();
                continue;
            }
            if (!ErrorHandling.bigger(pos, err.getSource()) && !ErrorHandling.equal(pos, err.getSource())) continue;
            return null;
        }
        return new CompileError(pos, msg, errorType);
    }

    private static boolean equal(WPos a, WPos b) {
        return a.getLeftPos() == b.getLeftPos() && a.getRightPos() == b.getRightPos();
    }

    private static boolean bigger(WPos a, WPos b) {
        return a.getLeftPos() <= b.getLeftPos() && a.getRightPos() > b.getRightPos() || a.getLeftPos() < b.getLeftPos() && a.getRightPos() >= b.getRightPos();
    }

    public static ErrorHandler getErrorHandler(Element e) {
        if (e.getParent() == null) {
            throw new Error("Trying to get error handler of element not attached to root:\n" + e);
        }
        return e.getParent().getErrorHandler();
    }

    public static ErrorHandler getErrorHandler(CompilationUnit e) {
        return e.getCuInfo().getCuErrorHandler();
    }

    public static ErrorHandler getErrorHandler(WurstModel m) {
        Iterator iterator = m.iterator();
        if (iterator.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iterator.next();
            return cu.getCuInfo().getCuErrorHandler();
        }
        throw new Error("Empty model.");
    }
}

