/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.hotdoc;

import com.google.common.collect.Lists;
import de.peeeq.wurstio.WurstCompilerJassImpl;
import de.peeeq.wurstio.utils.FileUtils;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.ExtensionFuncDef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.StructureDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGuiCliImpl;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.jdt.annotation.Nullable;

public class HotdocGenerator {
    private final List<String> files;
    private final File outputfolder;
    private final VelocityEngine ve;
    private final Template variableTemplate;
    private final Template navbarTemplate;
    private final Template structureTemplate;

    public HotdocGenerator(List<String> files) {
        this.files = Lists.newArrayList(files);
        this.outputfolder = new File(this.files.remove(files.size() - 1));
        this.ve = new VelocityEngine();
        Properties p = new Properties();
        p.setProperty("runtime.references.strict", "true");
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.init(p);
        this.variableTemplate = this.ve.getTemplate("/hotdoc/var.html");
        this.navbarTemplate = this.ve.getTemplate("/hotdoc/navbar.html");
        this.structureTemplate = this.ve.getTemplate("/hotdoc/structure.html");
    }

    public void generateDoc() {
        try {
            WLogger.info("Generating hotdoc into " + this.outputfolder.getAbsolutePath());
            for (String f : this.files) {
                WLogger.info("\tinput: " + f);
            }
            if (this.outputfolder.exists()) {
                for (File f : this.outputfolder.listFiles()) {
                    if (!f.getName().endsWith(".html")) continue;
                    f.delete();
                }
            } else if (!this.outputfolder.mkdirs()) {
                throw new Error("could not create output directory");
            }
            RunArgs runArgs = new RunArgs(new String[0]);
            WurstGuiCliImpl gui = new WurstGuiCliImpl();
            WurstCompilerJassImpl compiler = new WurstCompilerJassImpl(null, gui, null, runArgs);
            compiler.loadFiles(Utils.getResourceFile("common.j"));
            compiler.loadFiles(Utils.getResourceFile("blizzard.j"));
            for (String string : this.files) {
                File f = new File(string);
                if (!f.exists()) {
                    WLogger.info("Folder " + f + " does not exist");
                    throw new RuntimeException(f.getAbsolutePath());
                }
                if (f.isDirectory()) {
                    compiler.loadWurstFilesInDir(f);
                    continue;
                }
                if (!Utils.isWurstFile(f)) continue;
                compiler.loadFiles(f);
            }
            WurstModel model = compiler.parseFiles();
            if (model == null) {
                WLogger.info("Hotdoc model is null.");
                for (CompileError e : gui.getErrorList()) {
                    WLogger.info(e);
                }
                throw new RuntimeException("Could not analyze program correctly.");
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)model.attrPackages().values());
            if (arrayList.size() == 0) {
                throw new RuntimeException("Cannot generate for empty model: " + this.files.get(0));
            }
            WLogger.info("Found " + arrayList.size() + "\u00b4packages.");
            arrayList.sort(Comparator.comparing(o -> o.getSource().shortFile()));
            this.createIndex(arrayList);
            for (WPackage p : arrayList) {
                this.createPackageDoc(p, arrayList);
            }
            gui.clearErrors();
        }
        catch (Throwable t) {
            System.err.println("Error in creating documentation: ");
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void createIndex(List<WPackage> packages) {
        Template t = this.ve.getTemplate("/hotdoc/document.html");
        VelocityContext context = new VelocityContext();
        context.put("title", (Object)"HotDoc Wurst Documentation");
        context.put("navbar", (Object)this.getNavbarWithHighlight(null, packages));
        context.put("content", (Object)"");
        String s = this.render(t, context);
        WLogger.info(s);
        try {
            FileUtils.write(this.render(t, context), new File(this.outputfolder + "/index.html"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createPackageDoc(WPackage pack, List<WPackage> packages) {
        Template t = this.ve.getTemplate("/hotdoc/document.html");
        VelocityContext context = new VelocityContext();
        context.put("title", (Object)(pack.getName() + " HotDoc Wurst Documentation"));
        context.put("navbar", (Object)this.getNavbarWithHighlight(pack, packages));
        context.put("content", (Object)this.getPackageContent(pack));
        String s = this.render(t, context);
        WLogger.info(s);
        try {
            FileUtils.write(this.render(t, context), new File(this.outputfolder + "/" + pack.getName() + ".html"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPackageContent(WPackage pack) {
        Template t = this.ve.getTemplate("/hotdoc/package.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPackage", (Object)pack);
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        this.documentVars(this.getElements(pack, VarDef.class), writer, false);
        this.documentFuncs(this.getElements(pack, FunctionDefinition.class), writer, false);
        this.documentStructures(pack, writer);
        return writer.toString();
    }

    private void documentStructures(WPackage pack, StringWriter writer) {
        List<StructureDef> sorted = Utils.sortByName(this.getElements(pack, StructureDef.class));
        for (StructureDef v : sorted) {
            if (!v.attrIsPublic()) continue;
            VelocityContext context = new VelocityContext();
            context.put("name", (Object)Utils.printElement(v));
            context.put("type", (Object)"");
            context.put("comment", (Object)v.attrComment());
            context.put("source", (Object)v.getSource());
            this.structureTemplate.merge((Context)context, (Writer)writer);
            this.documentVars(v.getVars(), writer, true);
            this.documentFuncs(v.getMethods(), writer, true);
        }
    }

    private <T extends FunctionDefinition> void documentFuncs(List<T> funcs, StringWriter writer, boolean includeNonPublic) {
        funcs = Utils.sortByName(funcs);
        for (FunctionDefinition f : funcs) {
            if (!f.attrIsPublic() && (!includeNonPublic || f.attrIsPrivate())) continue;
            VelocityContext context = new VelocityContext();
            StringBuilder descr = new StringBuilder();
            descr.append("function ");
            if (f instanceof ExtensionFuncDef) {
                ExtensionFuncDef ex = (ExtensionFuncDef)f;
                descr.append(ex.getExtendedType().attrTyp());
                descr.append(".");
            }
            descr.append(f.getName());
            descr.append("(");
            boolean first = true;
            for (WParameter p : f.getParameters()) {
                if (!first) {
                    descr.append(", ");
                }
                descr.append(p.attrTyp()).append(" ").append(p.getName());
                first = false;
            }
            descr.append(")");
            if (!f.attrReturnTyp().isVoid()) {
                descr.append(" returns ");
                descr.append(f.attrReturnTyp());
            }
            context.put("name", (Object)descr);
            context.put("type", (Object)"");
            context.put("comment", (Object)f.attrComment());
            context.put("source", (Object)f.getSource());
            this.variableTemplate.merge((Context)context, (Writer)writer);
        }
    }

    private <T extends VarDef> void documentVars(List<T> vardefs, StringWriter writer, boolean includeNonPublic) {
        List<VarDef> sorted = Utils.sortByName(vardefs);
        for (VarDef v : sorted) {
            if (!v.attrIsPublic() && (!includeNonPublic || v.attrIsPrivate())) continue;
            VelocityContext context = new VelocityContext();
            context.put("name", (Object)v.getName());
            context.put("type", (Object)v.attrTyp());
            context.put("comment", (Object)v.attrComment());
            context.put("source", (Object)v.getSource());
            this.variableTemplate.merge((Context)context, (Writer)writer);
        }
    }

    private <T> List<T> getElements(WPackage pack, Class<T> clazz) {
        ArrayList result = Lists.newArrayList();
        for (WEntity e : pack.getElements()) {
            WLogger.info(Utils.printElement(e));
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            WEntity t = e;
            result.add(t);
        }
        return result;
    }

    private String render(Template t, VelocityContext context) {
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        String s = writer.toString();
        return s;
    }

    private String getNavbarWithHighlight(@Nullable WPackage pack, List<WPackage> packages) {
        VelocityContext context = new VelocityContext();
        context.put("packages", packages);
        context.put("currentPackage", (Object)pack);
        return this.render(this.navbarTemplate, context);
    }
}

