/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.splats;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.Color;
import net.moonlightflower.wc3libs.dataTypes.app.LightningId;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.RawSLK;
import net.moonlightflower.wc3libs.slk.SLK;

public class LightningSLK
extends ObjSLK<LightningSLK, LightningId, Obj> {
    public static final File GAME_PATH = new File("Splats\\LightningData.slk");

    @Override
    @Nonnull
    public Map<LightningId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((LightningId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull LightningId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        this.read(new RawSLK(file));
    }

    public LightningSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(LightningId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull LightningSLK other, boolean overwrite) {
    }

    public static class Obj
    extends SLK.Obj<LightningId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public Path getTex() {
            return Paths.get(this.get(State.ART_TEX_DIR).getVal(), this.get(State.ART_TEX_FILE).getVal());
        }

        public void setTex(Path val) {
            this.set(State.ART_TEX_DIR, War3String.valueOf(val.getParent().toString()));
            this.set(State.ART_TEX_FILE, War3String.valueOf(val.getFileName().toString()));
        }

        public War3Real getAvgSegLen() {
            return this.get(State.ART_SEG_LEN_AVG);
        }

        public void setAvgSegLen(War3Real val) {
            this.set(State.ART_SEG_LEN_AVG, val);
        }

        public War3Real getWidth() {
            return this.get(State.ART_WIDTH);
        }

        public void setWidth(War3Real val) {
            this.set(State.ART_WIDTH, val);
        }

        public Color getColor() {
            return Color.fromBGRA255((int)this.get(State.ART_COLOR_BLUE).toFloat() * 255, (int)this.get(State.ART_COLOR_GREEN).toFloat() * 255, (int)this.get(State.ART_COLOR_RED).toFloat() * 255, (int)this.get(State.ART_COLOR_ALPHA).toFloat() * 255);
        }

        public void setColor(Color val) {
            this.set(State.ART_COLOR_ALPHA, War3Real.valueOf((float)val.getAlpha255() / 255.0f));
            this.set(State.ART_COLOR_BLUE, War3Real.valueOf((float)val.getBlue255() / 255.0f));
            this.set(State.ART_COLOR_GREEN, War3Real.valueOf((float)val.getGreen255() / 255.0f));
            this.set(State.ART_COLOR_RED, War3Real.valueOf((float)val.getRed255() / 255.0f));
        }

        public War3Real getNoiseScale() {
            return this.get(State.ART_NOISE_SCALE);
        }

        public void setNoiseScale(War3Real val) {
            this.set(State.ART_NOISE_SCALE, val);
        }

        public War3Real getTexCoordScale() {
            return this.get(State.ART_TEX_COORD_SCALE);
        }

        public void setTexCoordScale(War3Real val) {
            this.set(State.ART_TEX_COORD_SCALE, val);
        }

        public War3Real getDuration() {
            return this.get(State.ART_DURATION);
        }

        public void setDuration(War3Real val) {
            this.set(State.ART_DURATION, val);
        }

        public <T extends DataType> T get(State<T> state) {
            return (T)this.get((FieldId)state.getFieldId());
        }

        public <T extends DataType> void set(State<T> state, T val) {
            this.set((FieldId)state.getFieldId(), (DataType)val);
        }

        public <T extends DataType> void remove(State<T> state) {
            super.set(state, null);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(LightningId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(LightningId id) {
            super(id);
            for (State state : State.values(State.class)) {
                this.set(state, state.getDefVal());
            }
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<LightningId> OBJ_ID = new State<LightningId>("Name", LightningId.class);
        public static final State<War3Real> ART_COLOR_ALPHA = new State<War3Real>("A", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_COLOR_BLUE = new State<War3Real>("B", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_COLOR_GREEN = new State<War3Real>("G", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_COLOR_RED = new State<War3Real>("R", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_DURATION = new State<War3Real>("Duration", War3Real.class, War3Real.valueOf(1.0f));
        public static final State<War3Real> ART_NOISE_SCALE = new State<War3Real>("NoiseScale", War3Real.class, War3Real.valueOf(0.02f));
        public static final State<War3String> ART_TEX_DIR = new State<War3String>("Dir", War3String.class);
        public static final State<War3String> ART_TEX_FILE = new State<War3String>("file", War3String.class);
        public static final State<War3Real> ART_SEG_LEN_AVG = new State<War3Real>("AvgSegLen", War3Real.class, War3Real.valueOf(10.0f));
        public static final State<War3Real> ART_TEX_COORD_SCALE = new State<War3Real>("TexCoordScale", War3Real.class);
        public static final State<War3Real> ART_WIDTH = new State<War3Real>("Width", War3Real.class, War3Real.valueOf(10.0f));
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

