/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeTuple
extends WurstType {
    private final TupleDef tupleDef;

    public WurstTypeTuple(TupleDef tupleDef) {
        Preconditions.checkNotNull((Object)tupleDef);
        this.tupleDef = tupleDef;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (other instanceof WurstTypeTuple) {
            WurstTypeTuple otherTuple = (WurstTypeTuple)other;
            if (this.tupleDef == otherTuple.tupleDef) {
                return mapping;
            }
        }
        return null;
    }

    public TupleDef getTupleDef() {
        return this.tupleDef;
    }

    @Override
    public String getName() {
        return this.tupleDef.getName();
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        ArrayList types = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        for (WParameter p : this.tupleDef.getParameters()) {
            ImType pt = p.attrTyp().imTranslateType(tr);
            types.add(pt);
            names.add(p.getName());
        }
        return JassIm.ImTupleType(types, names);
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        ImExprs exprs = JassIm.ImExprs(new ImExpr[0]);
        for (WParameter p : this.tupleDef.getParameters()) {
            exprs.add((ImExpr)p.attrTyp().getDefaultValue(tr));
        }
        return JassIm.ImTupleExpr(exprs);
    }

    @Override
    protected boolean isNullable() {
        return false;
    }

    public int getTupleIndex(VarDef varDef) {
        WParameter v = (WParameter)varDef;
        int index = this.tupleDef.getParameters().indexOf(v);
        if (index < 0) {
            throw new CompileError(varDef.getSource(), "Could not determine tuple index of " + Utils.printElementWithSource(Optional.of(varDef)) + " in tuple " + this);
        }
        return index;
    }
}

