/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.peeeq.wurstscript.ast.AstElementWithFuncName;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrInterface;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.ast.NamedScope;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeArguments;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtojass.TypeRewriteMatcher;
import de.peeeq.wurstscript.translation.imtojass.TypeRewriter;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.OverrideUtils;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBool;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeClassOrInterface;
import de.peeeq.wurstscript.types.WurstTypeCode;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClosureTranslator {
    private final ExprClosure e;
    private final ImTranslator tr;
    private final ImFunction f;
    private final Map<ImVar, ImVar> closureVars = Maps.newLinkedHashMap();
    private Map<ImTypeVar, ImTypeVar> typeVars;
    private ImFunction impl;
    private ImClass c;

    public ClosureTranslator(ExprClosure e, ImTranslator tr, ImFunction f) {
        this.e = e;
        this.tr = tr;
        this.f = f;
    }

    public ImExpr translate() {
        if (this.e.attrExpectedTypAfterOverloading() instanceof WurstTypeCode) {
            return this.translateAnonFunc();
        }
        ImClass c = this.createClass();
        ImClassType ct = JassIm.ImClassType(c, this.getClassTypeArguments());
        ImVar clVar = JassIm.ImVar(this.e, ct, "clVar", false);
        this.f.getLocals().add(clVar);
        ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
        stmts.add(JassIm.ImSet(this.e, JassIm.ImVarAccess(clVar), JassIm.ImAlloc(this.e, ct)));
        this.callSuperConstructor(clVar, stmts, c);
        for (Map.Entry<ImVar, ImVar> entry : this.closureVars.entrySet()) {
            ImVar orig = entry.getKey();
            ImVar v = entry.getValue();
            stmts.add(JassIm.ImSet(this.e, JassIm.ImMemberAccess(this.e, JassIm.ImVarAccess(clVar), JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(new ImExpr[0])), JassIm.ImVarAccess(orig)));
        }
        return JassIm.ImStatementExpr(stmts, JassIm.ImVarAccess(clVar));
    }

    private ImTypeArguments getClassTypeArguments() {
        ImTypeArguments res = JassIm.ImTypeArguments(new ImTypeArgument[0]);
        for (ImTypeVar typeVar : this.typeVars.keySet()) {
            res.add(JassIm.ImTypeArgument(JassIm.ImTypeVarRef(typeVar), Collections.emptyMap()));
        }
        return res;
    }

    private void callSuperConstructor(ImVar clVar, ImStmts stmts, ImClass c) {
        WurstType t = this.e.attrExpectedTypAfterOverloading();
        if (t instanceof WurstTypeClass) {
            WurstTypeClass ct = (WurstTypeClass)t;
            ClassDef cd = ct.getClassDef();
            for (ConstructorDef constr : cd.getConstructors()) {
                if (!constr.getParameters().isEmpty()) continue;
                this.callSuperConstructor(clVar, stmts, c, constr);
                return;
            }
            throw new CompileError(this.e.attrErrorPos(), "Cannot construct closure. Superclass has no default constructor.");
        }
    }

    private void callSuperConstructor(ImVar clVar, ImStmts stmts, ImClass c, ConstructorDef constr) {
        ImFunction cn = this.tr.getConstructFunc(constr);
        ImExprs arguments = JassIm.ImExprs(JassIm.ImVarAccess(clVar));
        stmts.add(JassIm.ImFunctionCall(this.e, cn, JassIm.ImTypeArguments(new ImTypeArgument[0]), arguments, false, CallType.NORMAL));
    }

    private ImExpr translateAnonFunc() {
        this.impl = this.tr.getFuncFor(this.e);
        this.impl.setName("code_" + this.makeNameSuffix());
        this.impl.getParameters().clear();
        ImExpr translated = this.e.getImplementation().imTranslateExpr(this.tr, this.impl);
        this.verifyTranslatedAnonfunc(translated);
        if (this.e.getImplementation().attrTyp() instanceof WurstTypeBool) {
            this.impl.getBody().add(JassIm.ImReturn(this.e, translated));
            this.impl.setReturnType(WurstTypeBool.instance().imTranslateType(this.tr));
        } else {
            this.impl.getBody().add(translated);
            this.impl.setReturnType(WurstTypeVoid.instance().imTranslateType(this.tr));
        }
        return JassIm.ImFuncRef(this.e, this.impl);
    }

    private void verifyTranslatedAnonfunc(ImExpr translated) {
        translated.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                super.visit(va);
                if (ClosureTranslator.this.isLocalToOtherFunc(va.getVar())) {
                    throw new CompileError(va.attrTrace().attrSource(), "Anonymous functions used as 'code' cannot capture variables. Captured " + va.getVar().getName());
                }
            }

            @Override
            public void visit(ImSet s) {
                super.visit(s);
                if (ClosureTranslator.this.isLocalToOtherFunc(s.getLeft())) {
                    throw new CompileError(s.attrTrace().attrSource(), "Anonymous functions used as 'code' cannot capture variables. Captured " + s.getLeft());
                }
            }
        });
    }

    private ImClass createClass() {
        ImClassType superClass = this.getSuperClass();
        FuncDef superMethod = this.getSuperMethod();
        this.c = this.tr.getClassForClosure(this.e);
        this.c.setName(this.makeClassName(superClass));
        this.c.setSuperClasses(Collections.singletonList(superClass));
        this.tr.imProg().getClasses().add(this.c);
        this.impl = this.tr.getFuncFor(this.e);
        this.impl.setName(this.makeFuncName(superMethod));
        this.tr.getImProg().getFunctions().remove(this.impl);
        this.c.getFunctions().add(this.impl);
        ImClassType methodClass = JassIm.ImClassType(this.c, JassIm.ImTypeArguments(new ImTypeArgument[0]));
        ImMethod m = JassIm.ImMethod(this.e, methodClass, superMethod.getName(), this.impl, JassIm.ImMethods(new ImMethod[0]), false);
        this.c.getMethods().add(m);
        OverrideUtils.addOverrideClosure(this.tr, superMethod, m, this.e);
        ImExpr translated = this.e.getImplementation().imTranslateExpr(this.tr, this.impl);
        if (this.e.getImplementation().attrTyp().isVoid()) {
            this.impl.getBody().add(translated);
        } else {
            this.impl.getBody().add(JassIm.ImReturn(this.e, translated));
        }
        this.transformTranslated(translated);
        this.typeVars = this.rewriteTypeVars(this.c);
        return this.c;
    }

    private String makeClassName(ImClassType superClass) {
        return superClass.getClassDef().getName() + this.makeNameSuffix();
    }

    private String makeNameSuffix() {
        StringBuilder sb = new StringBuilder();
        for (Element elem = this.e; elem != null; elem = elem.getParent()) {
            if (elem instanceof NamedScope) {
                sb.append("_");
                sb.append(((NamedScope)elem).getName());
                continue;
            }
            if (!(elem instanceof AstElementWithFuncName)) continue;
            sb.append("_");
            sb.append(((AstElementWithFuncName)elem).getFuncNameId().getName());
        }
        return sb.toString();
    }

    private String makeFuncName(FuncDef superClass) {
        return superClass.getName() + this.makeNameSuffix();
    }

    private Map<ImTypeVar, ImTypeVar> rewriteTypeVars(ImClass c) {
        LinkedHashMap<ImTypeVar, ImTypeVar> result = new LinkedHashMap<ImTypeVar, ImTypeVar>();
        ImClassType thisType = JassIm.ImClassType(c, JassIm.ImTypeArguments(new ImTypeArgument[0]));
        TypeRewriter.rewriteTypes(c, t -> this.rewriteType(thisType, (Map<ImTypeVar, ImTypeVar>)result, (ImType)t));
        return result;
    }

    private ImType rewriteType(final ImClassType thisType, final Map<ImTypeVar, ImTypeVar> result, ImType type) {
        return type.match(new TypeRewriteMatcher(){

            @Override
            public ImType case_ImClassType(ImClassType t) {
                if (t.getClassDef() == ClosureTranslator.this.c) {
                    return thisType;
                }
                return super.case_ImClassType(t);
            }

            @Override
            public ImType case_ImTypeVarRef(ImTypeVarRef t) {
                ImTypeVar oldTypevar = t.getTypeVariable();
                ImTypeVar newTypevar = (ImTypeVar)result.get(oldTypevar);
                if (newTypevar == null) {
                    newTypevar = JassIm.ImTypeVar(oldTypevar.getName() + "_captured");
                    result.put(oldTypevar, newTypevar);
                    ClosureTranslator.this.c.getTypeVariables().add(newTypevar);
                    thisType.getTypeArguments().add(JassIm.ImTypeArgument(JassIm.ImTypeVarRef(newTypevar), Collections.emptyMap()));
                }
                return JassIm.ImTypeVarRef(newTypevar);
            }
        });
    }

    private void transformTranslated(ImExpr t) {
        final ArrayList vas = Lists.newArrayList();
        t.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                super.visit(va);
                if (ClosureTranslator.this.isLocalToOtherFunc(va.getVar())) {
                    vas.add(va);
                }
            }
        });
        for (ImVarAccess va : vas) {
            ImVar v = this.getClosureVarFor(va.getVar());
            va.replaceBy(JassIm.ImMemberAccess(this.e, this.closureThis(), JassIm.ImTypeArguments(new ImTypeArgument[0]), v, JassIm.ImExprs(new ImExpr[0])));
        }
    }

    private ImVarAccess closureThis() {
        return JassIm.ImVarAccess(this.tr.getThisVar(this.e));
    }

    private ImVar getClosureVarFor(ImVar var) {
        ImVar v = this.closureVars.get(var);
        if (v == null) {
            v = JassIm.ImVar(this.e, var.getType(), var.getName(), false);
            this.c.getFields().add(v);
            this.closureVars.put(var, v);
        }
        return v;
    }

    private boolean isLocalToOtherFunc(ImVar v) {
        if (v.getParent() == null || v.getParent().getParent() == null) {
            return false;
        }
        if (v.getParent().getParent() instanceof ImFunction) {
            boolean r = v.getParent().getParent() != this.impl;
            return r;
        }
        return false;
    }

    private boolean isLocalToOtherFunc(ImLExpr e) {
        if (e instanceof ImVarAccess) {
            return this.isLocalToOtherFunc(((ImVarAccess)e).getVar());
        }
        if (e instanceof ImTupleSelection) {
            ImTupleSelection ts = (ImTupleSelection)e;
            return this.isLocalToOtherFunc((ImLExpr)ts.getTupleExpr());
        }
        return false;
    }

    private FuncDef getSuperMethod() {
        FuncLink nl = this.e.attrClosureAbstractMethod();
        return (FuncDef)((NameLink)nl).getDef();
    }

    private ImClassType getSuperClass() {
        WurstTypeClassOrInterface t = (WurstTypeClassOrInterface)this.e.attrExpectedTypAfterOverloading();
        ClassOrInterface classDef = t.getDef();
        t = (WurstTypeClassOrInterface)classDef.attrTyp();
        VariableBinding mapping = VariableBinding.emptyMapping().withTypeVariables(classDef.getTypeParameters());
        WurstType closureType = this.e.attrTyp();
        VariableBinding mapping2 = closureType.matchAgainstSupertype(t, this.e, mapping, VariablePosition.RIGHT);
        if (mapping2 == null) {
            throw new CompileError(this.e, "Could not translate closure: type " + closureType + " does not match " + t);
        }
        WurstType t2 = t.setTypeArgs(mapping2);
        return (ImClassType)t2.imTranslateType(this.tr);
    }
}

