/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.AstElementWithSource;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.NoExpr;
import de.peeeq.wurstscript.ast.NoTypeExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExprArray;
import de.peeeq.wurstscript.ast.TypeExprResolved;
import de.peeeq.wurstscript.ast.TypeExprSimple;
import de.peeeq.wurstscript.ast.TypeExprThis;
import de.peeeq.wurstscript.attributes.AttrExprType;
import de.peeeq.wurstscript.types.NativeTypes;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.types.WurstTypeNamedScope;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Utils;

public class AttrTypeExprType {
    public static WurstType calculate(TypeExprSimple node) {
        WurstType baseType = AttrTypeExprType.getBaseType(node);
        if (node.getTypeArgs().size() > 0) {
            if (baseType instanceof WurstTypeNamedScope) {
                WurstTypeNamedScope ns = (WurstTypeNamedScope)baseType;
                return ns.replaceTypeVarsUsingTypeArgs(node.getTypeArgs());
            }
            node.addError("Type " + baseType + " cannot have type args");
        }
        return baseType;
    }

    public static WurstType calculate(TypeExprThis node) {
        AstElementWithSource scope;
        WurstType scopeType = node.getScopeType().attrTyp();
        if (scopeType instanceof WurstTypeNamedScope) {
            WurstTypeNamedScope wtns = (WurstTypeNamedScope)scopeType;
            scope = wtns.getDef();
        } else {
            scope = node;
        }
        return AttrExprType.caclulateThistype(scope, false, "thistype");
    }

    public static WurstType calculate(NoTypeExpr optType) {
        return WurstTypeVoid.instance();
    }

    public static WurstType calculate(TypeExprArray typeExprArray) {
        WurstType baseType = typeExprArray.getBase().attrTyp().dynamic();
        if (typeExprArray.getArraySize() instanceof NoExpr) {
            return new WurstTypeArray(baseType);
        }
        Expr arSize = (Expr)typeExprArray.getArraySize();
        return new WurstTypeArray(baseType, arSize);
    }

    private static WurstType getBaseType(TypeExprSimple node) {
        String typename = node.getTypeName();
        boolean isJassCode = Utils.isJassCode(node);
        TypeDef t = node.attrTypeDef();
        if (t == null) {
            WurstType nativeType = NativeTypes.nativeType(typename, isJassCode);
            if (nativeType != null) {
                return nativeType;
            }
            node.addError("Unknown type " + typename);
            return new WurstTypeUnknown(typename);
        }
        return t.attrTyp();
    }

    public static WurstType normalizedType(OptTypeExpr e) {
        return e.attrTypRaw().normalize();
    }

    public static WurstType calculate(TypeExprResolved e) {
        return e.getResolvedType();
    }
}

