/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.Id;

public abstract class State<FieldIdType extends FieldId, T extends DataType> {
    private final T _defVal;
    private final FieldIdType _field;
    private DataTypeInfo _info;
    private static final Map<Class<? extends State>, ClassAssignment> _typeValues = new LinkedHashMap<Class<? extends State>, ClassAssignment>();
    private static final Set<Class> _loadedClasses = new LinkedHashSet<Class>();
    private static Map<Class<? extends State>, Collection<? extends State>> _values = new LinkedHashMap<Class<? extends State>, Collection<? extends State>>();

    @Nullable
    public T getDefVal() {
        return this._defVal;
    }

    @Nonnull
    public FieldIdType getFieldId() {
        return this._field;
    }

    public String toString() {
        return ((War3String)this._field).toString();
    }

    @Nonnull
    public DataTypeInfo getInfo() {
        return this._info;
    }

    public T getVal(@Nullable DataType val) {
        if (this.getInfo().getType().isInstance(val)) {
            return (T)this.getInfo().getType().cast(val);
        }
        return null;
    }

    public T tryCastVal(DataType val) throws DataTypeInfo.CastException {
        return (T)this.getInfo().tryCastVal(val);
    }

    public T tryCastVal(DataType val, @Nullable T defVal) {
        try {
            return (T)this.getInfo().tryCastVal(val);
        }
        catch (DataTypeInfo.CastException e) {
            return defVal;
        }
    }

    private static void initializeClass(Class c) {
        if (_loadedClasses.contains(c)) {
            return;
        }
        _loadedClasses.add(c);
        try {
            Class superClass;
            Class.forName(c.getName(), true, c.getClassLoader());
            Class<?> enclosingClass = c.getEnclosingClass();
            if (enclosingClass != null) {
                State.initializeClass(enclosingClass);
            }
            if ((superClass = c.getSuperclass()) != null) {
                State.initializeClass(superClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nonnull
    public static <T extends State> Collection<State> allValues(@Nonnull Class<T> specificClass) {
        State.initializeClass(specificClass);
        LinkedHashSet<State> ret = new LinkedHashSet<State>();
        for (Map.Entry<Class<? extends State>, ClassAssignment> entry : _typeValues.entrySet()) {
            Class<? extends State> otherClass = entry.getKey();
            if (!otherClass.isAssignableFrom(specificClass)) continue;
            Collection<State> states = entry.getValue()._states.values();
            ret.addAll(states);
        }
        return ret;
    }

    @Nonnull
    public static <T extends State> Collection<T> values(@Nonnull Class<T> specificClass) {
        State.initializeClass(specificClass);
        LinkedHashSet<State> ret = new LinkedHashSet<State>();
        for (Map.Entry<Class<? extends State>, ClassAssignment> entry : _typeValues.entrySet()) {
            Class<? extends State> otherClass = entry.getKey();
            if (!otherClass.isAssignableFrom(specificClass)) continue;
            Collection<State> states = entry.getValue()._states.values();
            for (State state : states) {
                if (!specificClass.isInstance(state)) continue;
                ret.add((State)specificClass.cast(state));
            }
        }
        if (!_values.containsKey(specificClass)) {
            _values.put(specificClass, ret);
        }
        return _values.get(specificClass);
    }

    @Nullable
    public static State valueByField(@Nonnull Class<? extends State> specificClass, @Nonnull FieldId fieldId) {
        for (State state : State.values(specificClass)) {
            if (!((Id)state.getFieldId()).equals(fieldId)) continue;
            return state;
        }
        return null;
    }

    public State(@Nonnull FieldIdType fieldId, @Nonnull DataTypeInfo info, @Nullable T defVal) {
        this._field = fieldId;
        this._info = info;
        this._defVal = defVal;
        Class<?> specificClass = this.getClass();
        if (!_typeValues.containsKey(specificClass)) {
            _typeValues.put(specificClass, new ClassAssignment());
        }
        _typeValues.get(specificClass).addState((FieldId)this.getFieldId(), this);
    }

    private static class ClassAssignment {
        private final Map<FieldId, State> _states = new LinkedHashMap<FieldId, State>();

        private void addState(@Nonnull FieldId fieldId, @Nonnull State state) {
            this._states.put(fieldId, state);
        }

        private ClassAssignment() {
        }
    }
}

