/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class GameVersion
implements Comparable<GameVersion> {
    private final List<Integer> _versionNumList;
    public static final GameVersion VERSION_1_29 = new GameVersion(Arrays.asList(1, 29));
    public static final GameVersion VERSION_1_31 = new GameVersion(Arrays.asList(1, 31));
    public static final GameVersion VERSION_1_32 = new GameVersion(Arrays.asList(1, 32));
    private static final Pattern pattern = Pattern.compile("(\\d+)", 32);

    public GameVersion(@Nonnull List<Integer> versionNumList) {
        this._versionNumList = new ArrayList<Integer>(versionNumList);
    }

    public GameVersion(@Nonnull String versionS) {
        Matcher matcher = pattern.matcher(versionS);
        int start = 0;
        ArrayList<Integer> versionNumList = new ArrayList<Integer>();
        while (start < versionS.length() && matcher.find(start)) {
            int version = Integer.parseInt(matcher.group(1));
            start = matcher.end() + 1;
            versionNumList.add(version);
        }
        this._versionNumList = versionNumList;
    }

    public String toString() {
        return this._versionNumList.toString();
    }

    @Override
    public int compareTo(@Nonnull GameVersion other) {
        int i = 0;
        while (true) {
            int otherCurNum;
            int curNum = i < this._versionNumList.size() ? this._versionNumList.get(i) : 0;
            int n = otherCurNum = i < other._versionNumList.size() ? other._versionNumList.get(i) : 0;
            if (curNum > otherCurNum) {
                return 1;
            }
            if (curNum < otherCurNum) {
                return -1;
            }
            if (i == this._versionNumList.size() && i == other._versionNumList.size()) {
                return 0;
            }
            ++i;
        }
    }

    public boolean equals(@Nonnull Object other) {
        if (!(other instanceof GameVersion)) {
            return false;
        }
        return this.compareTo((GameVersion)other) == 0;
    }
}

