/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.utils;

import com.google.common.base.Charsets;
import de.peeeq.wurstscript.WLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.mozilla.universalchardet.UniversalDetector;

public class FileReading {
    private static final UniversalDetector detector = new UniversalDetector();

    private static Reader getFileReader(File file, Charset cs) throws IOException {
        return Files.newBufferedReader(file.toPath(), cs);
    }

    public static Reader getFileReader(File file) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int nread;
            byte[] buf = new byte[4096];
            while ((nread = fis.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, nread);
            }
            detector.dataEnd();
            String encoding = detector.getDetectedCharset();
            detector.reset();
            if (encoding == null) {
                WLogger.severe("Could not get encoding for " + file.getAbsolutePath());
                Reader reader = FileReading.getFileReader(file, Charsets.UTF_8);
                return reader;
            }
            Reader reader = FileReading.getFileReader(file, Charset.forName(encoding));
            return reader;
        }
    }
}

