/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.security;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import systems.crigges.jmpq3.security.CryptographicLUT;

public class MPQEncryption {
    private static final int BLOCK_SIZE = 4;
    private int seed;
    private int key;
    private boolean decrypt;

    public MPQEncryption(int key, boolean invert) {
        this.changeKey(key, invert);
    }

    public void changeKey(int key, boolean invert) {
        this.key = key;
        this.decrypt = invert;
        this.seed = -286331154;
    }

    public boolean process(ByteBuffer src, ByteBuffer dst) {
        src.order(ByteOrder.LITTLE_ENDIAN);
        dst.order(ByteOrder.LITTLE_ENDIAN);
        for (int blocks = Math.min(src.remaining(), dst.remaining()) / 4; blocks > 0; --blocks) {
            this.seed += CryptographicLUT.ENCRYPTION.lookup((byte)this.key);
            int block = this.key + this.seed;
            int in = src.getInt();
            int out = in ^ block;
            dst.putInt(out);
            this.seed += (this.decrypt ? out : in) + (this.seed << 5) + 3;
            this.key = (~this.key << 21) + 0x11111111 | this.key >>> 11;
        }
        return dst.remaining() >= 4;
    }

    public boolean processFinal(ByteBuffer src, ByteBuffer dst) {
        this.process(src, dst);
        if (src.remaining() < 4) {
            while (src.hasRemaining() && dst.hasRemaining()) {
                dst.put(src.get());
            }
        }
        return src.hasRemaining();
    }

    public void processSingle(ByteBuffer buff) {
        ByteBuffer dst = buff.duplicate();
        this.processFinal(buff, dst);
    }
}

