/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.lua.translation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.validation.TRVEHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RemoveGarbage {
    public static void removeGarbage(ImProg prog) {
        Used used = new Used();
        for (ImFunction f2 : ImHelper.calculateFunctionsOfProg(prog)) {
            if (!f2.getName().equals("main") && !f2.getName().equals("config")) continue;
            RemoveGarbage.visitFunction(f2, used);
        }
        prog.getClasses().removeIf(c -> !used.getClasses().contains(c));
        prog.getGlobals().removeIf(g -> !used.getVars().contains(g) && !TRVEHelper.protectedVariables.contains(g.getName()));
        prog.getFunctions().removeIf(f -> !used.getFunctions().contains(f));
        for (ImClass c2 : prog.getClasses()) {
            c2.getFields().removeIf(g -> !used.getVars().contains(g));
            c2.getFunctions().removeIf(f -> !used.getFunctions().contains(f));
            c2.getMethods().removeIf(m -> !used.getMethods().contains(m));
            for (ImMethod m2 : c2.getMethods()) {
                m2.getSubMethods().removeIf(sm -> !used.getMethods().contains(sm));
            }
        }
    }

    private static void visitFunction(ImFunction f, final Used used) {
        if (used.getFunctions().contains(f)) {
            return;
        }
        used.addFunction(f);
        RemoveGarbage.visitType(f.getReturnType(), used);
        f.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFunctionCall e) {
                super.visit(e);
                RemoveGarbage.visitFunction(e.getFunc(), used);
            }

            @Override
            public void visit(ImVar e) {
                super.visit(e);
                RemoveGarbage.visitType(e.getType(), used);
            }

            @Override
            public void visit(ImFuncRef e) {
                super.visit(e);
                RemoveGarbage.visitFunction(e.getFunc(), used);
            }

            @Override
            public void visit(ImCast e) {
                super.visit(e);
                RemoveGarbage.visitType(e.getToType(), used);
            }

            @Override
            public void visit(ImVarAccess e) {
                super.visit(e);
                used.addVar(e.getVar());
            }

            @Override
            public void visit(ImVarArrayAccess e) {
                super.visit(e);
                used.addVar(e.getVar());
            }

            @Override
            public void visit(ImAlloc e) {
                super.visit(e);
                RemoveGarbage.visitClass(e.getClazz().getClassDef(), used);
            }

            @Override
            public void visit(ImDealloc e) {
                super.visit(e);
                RemoveGarbage.visitClass(e.getClazz().getClassDef(), used);
            }

            @Override
            public void visit(ImInstanceof e) {
                super.visit(e);
                RemoveGarbage.visitClass(e.getClazz().getClassDef(), used);
            }

            @Override
            public void visit(ImTypeIdOfObj e) {
                super.visit(e);
                RemoveGarbage.visitClass(e.getClazz().getClassDef(), used);
            }

            @Override
            public void visit(ImTypeIdOfClass e) {
                super.visit(e);
                RemoveGarbage.visitClass(e.getClazz().getClassDef(), used);
            }

            @Override
            public void visit(ImMethodCall e) {
                super.visit(e);
                RemoveGarbage.visitMethod(e.getMethod(), used);
            }

            @Override
            public void visit(ImMemberAccess e) {
                super.visit(e);
                used.addVar(e.getVar());
            }
        });
    }

    private static void visitMethod(ImMethod m, Used used) {
        if (used.getMethods().contains(m)) {
            return;
        }
        used.addMethod(m);
        RemoveGarbage.visitClass(m.getMethodClass().getClassDef(), used);
        RemoveGarbage.visitFunction(m.getImplementation(), used);
        for (ImMethod subMethod : m.getSubMethods()) {
            used.maybeVisitMethod(subMethod);
        }
    }

    private static void visitClass(ImClass c, Used used) {
        if (used.getClasses().contains(c)) {
            return;
        }
        used.addClass(c);
        for (ImClassType superClass : c.getSuperClasses()) {
            RemoveGarbage.visitClass(superClass.getClassDef(), used);
        }
    }

    private static void visitType(ImType t, final Used used) {
        t.match(new ImType.MatcherVoid(){

            @Override
            public void case_ImAnyType(ImAnyType imAnyType) {
            }

            @Override
            public void case_ImTupleType(ImTupleType tt) {
                for (ImType type : tt.getTypes()) {
                    RemoveGarbage.visitType(type, used);
                }
            }

            @Override
            public void case_ImTypeVarRef(ImTypeVarRef tt) {
            }

            @Override
            public void case_ImVoid(ImVoid tt) {
            }

            @Override
            public void case_ImSimpleType(ImSimpleType tt) {
            }

            @Override
            public void case_ImArrayTypeMulti(ImArrayTypeMulti tt) {
                RemoveGarbage.visitType(tt.getEntryType(), used);
            }

            @Override
            public void case_ImClassType(ImClassType tt) {
                RemoveGarbage.visitClass(tt.getClassDef(), used);
                for (ImTypeArgument ta : tt.getTypeArguments()) {
                    RemoveGarbage.visitType(ta.getType(), used);
                }
            }

            @Override
            public void case_ImArrayType(ImArrayType tt) {
                RemoveGarbage.visitType(tt.getEntryType(), used);
            }
        });
    }

    private static class Used {
        private final Set<ImFunction> functions = new HashSet<ImFunction>();
        private final Set<ImMethod> methods = new HashSet<ImMethod>();
        private final Multimap<ImClass, ImMethod> waitingMethods = HashMultimap.create();
        private final Set<ImClass> classes = new HashSet<ImClass>();
        private final Set<ImVar> vars = new HashSet<ImVar>();

        private Used() {
        }

        public void addMethod(ImMethod m) {
            this.methods.add(m);
        }

        public void maybeVisitMethod(ImMethod m) {
            ImClass c = m.attrClass();
            if (this.classes.contains(c)) {
                RemoveGarbage.visitMethod(m, this);
            } else {
                this.waitingMethods.put((Object)c, (Object)m);
            }
        }

        public Set<ImFunction> getFunctions() {
            return this.functions;
        }

        public Set<ImMethod> getMethods() {
            return this.methods;
        }

        public Set<ImClass> getClasses() {
            return this.classes;
        }

        public Set<ImVar> getVars() {
            return this.vars;
        }

        public void addFunction(ImFunction f) {
            this.functions.add(f);
        }

        public void addVar(ImVar var) {
            this.vars.add(var);
        }

        public void addClass(ImClass c) {
            this.classes.add(c);
            Collection imMethods = this.waitingMethods.get((Object)c);
            Iterator it = imMethods.iterator();
            while (it.hasNext()) {
                ImMethod m = (ImMethod)it.next();
                RemoveGarbage.visitMethod(m, this);
                it.remove();
            }
        }
    }
}

