/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.gui;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class WurstGui {
    private final List<CompileError> errors = Lists.newArrayList();

    public abstract void sendProgress(String var1);

    public abstract void sendFinished();

    public abstract void showInfoMessage(String var1);

    public void sendError(CompileError err) {
        this.errors.add(err);
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public final int getErrorCount() {
        return this.getErrorList().size();
    }

    public final String getErrors() {
        return Utils.join(this.errors, "\n");
    }

    public final List<CompileError> getErrorList() {
        return this.errors.stream().filter(e -> e.getErrorType() == CompileError.ErrorType.ERROR).collect(Collectors.toList());
    }

    public final List<CompileError> getWarningList() {
        return this.errors.stream().filter(e -> e.getErrorType() == CompileError.ErrorType.WARNING).collect(Collectors.toList());
    }

    public final List<CompileError> getErrorsAndWarnings() {
        return Collections.unmodifiableList(this.errors);
    }
}

