function defaultArray(d) 
	local t = {}
	local mt = {__index = function (table, key)
	    local v = d()
	    table[key] = v
	    return v
	end}
	setmetatable(t, mt)
	return t
end

function stringConcat(x, y) 
	if x then
	    if y then return x .. y else return x end
	else
	    return y
	end
end

function isInstanceOf(x, A) 
	return x ~= nil and x.__wurst_supertypes[A]
end

__wurst_objectIndexMap = ({counter=0, })
__wurst_number_wrapper_map = ({counter=0, })

function objectToIndex(x) 
	if x == nil then
	    return 0
	end
	if type(x) == "number" then
	    if __wurst_number_wrapper_map[x] then
	        x = __wurst_number_wrapper_map[x]
	    else
	        local obj = {__wurst_boxed_number = x}
	        __wurst_number_wrapper_map[x] = obj
	        x = obj
	    end
	end
	if __wurst_objectIndexMap[x] then
	    return __wurst_objectIndexMap[x]
	else
	   local r = __wurst_objectIndexMap.counter + 1
	   __wurst_objectIndexMap.counter = r
	   __wurst_objectIndexMap[r] = x
	   __wurst_objectIndexMap[x] = r
	   return r
	end
end

function objectFromIndex(x) 
	if type(x) == "number" then
	    x = __wurst_objectIndexMap[x]
	end
	if type(x) == "table" and x.__wurst_boxed_number then
	    return x.__wurst_boxed_number
	end
	return x
end

function intEnsure(x) 
	if x == nil then
	    return 0
	else
	    return math.tointeger(x)
	end
end

function boolEnsure(x) 
	if x == nil then
	    return false
	else
	    return x
	end
end

function realEnsure(x) 
	if x == nil then
	    return 0.0
	else
	    return x
	end
end

function stringEnsure(x) 
	if x == nil then
	    return ""
	else
	    return x
	end
end

Angle_RADTODEG = 0.
Basics_ANIMATION_PERIOD = 0.
ClosureTimers_x = 0
Colors_hexs = defaultArray(function () 
		return nil
	end)
Colors_decs = nil
Colors_COLOR_WHITE = ({0, 0, 0, 0, })
Colors_COLOR_BLACK = ({0, 0, 0, 0, })
Colors_COLOR_GOLD = ({0, 0, 0, 0, })
ErrorHandling_MUTE_ERROR_DURATION = 0
ErrorHandling_PRIMARY_ERROR_KEY = 0
ErrorHandling_HT = nil
ErrorHandling_suppressErrorMessages = false
Framehandle_GAME_UI = nil
Framehandle_BLZ_FRAMENAME_MAXLENGTH = 0
GameTimer_currentTime = 0.
HashList_ht = nil
HashList_occurences = nil
MagicFunctions_compiletime = false
Player_players = defaultArray(function () 
		return nil
	end)
Player_localPlayer = nil
Printing_DEBUG_LEVEL = 0
Printing_DEBUG_MSG_DURATION = 0.
String_charset = nil
String_numberset = nil
Table_ht = nil
Test_intMap = nil
Test_realMap = nil
Test_boolMap = nil
Test_strMap = nil
Test_unitMap = nil
TimerUtils_freeTimers = defaultArray(function () 
		return nil
	end)
TimerUtils_freeTimersCount = 0
TimerUtils_timerData = nil
TimerUtils_HELD = 0
TypeCasting_typecastdata = nil
TypeCasting_R2I_PRECISION = 0.
hashtable_compiletime = nil
hashtable_compiletime1 = nil
hashtable_compiletime2 = nil
hashtable_compiletime3 = nil
CallbackSingle = ({})
HashMap = ({})
Table = ({})
CallbackSingle_doAfter_Test = ({})

function CallbackSingle:create() 
	local new_inst = ({CallbackSingle_t=nil, })
	setmetatable(new_inst, ({__index=CallbackSingle, }))
	return new_inst
end

function CallbackSingle_CallbackSingle_start(this, whichTimer, time) 
	local receiver = nil
	local receiver1 = nil
	receiver = whichTimer
	timer_setData(receiver, objectToIndex(this))
	receiver1 = receiver
	timer_start(receiver1, time, function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = code__start_CallbackSingle_ClosureTimers(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end)
	this.CallbackSingle_t = receiver1
end

function CallbackSingle_CallbackSingle_call(this3) 
end

function CallbackSingle_construct_CallbackSingle(this4) 
	CallbackSingle_CallbackSingle_init(this4)
end

function CallbackSingle_destroyCallbackSingle(this6) 
	CallbackSingle_CallbackSingle_onDestroy(this6)
end

function CallbackSingle_CallbackSingle_init(this5) 
end

function CallbackSingle_CallbackSingle_onDestroy(this7) 
	timer_release(this7.CallbackSingle_t)
end

function HashMap:create1() 
	local new_inst = ({HashMap_size=0, })
	setmetatable(new_inst, ({__index=HashMap, }))
	return new_inst
end

function HashMap_HashMap_has1(this9, key) 
	return this9:Table_Table_hasInt(objectToIndex(key))
end

function HashMap_HashMap_put1(this10, key1, value) 
	if not(this10:HashMap_HashMap_has(key1)) then
		this10.HashMap_size = (this10.HashMap_size + 1)
	end
	this10:Table_Table_saveInt(objectToIndex(key1), objectToIndex(value))
end

function HashMap_HashMap_get1(this11, key2) 
	return objectFromIndex(this11:Table_Table_loadInt(objectToIndex(key2)))
end

function HashMap_HashMap_init(this12) 
	this12.HashMap_size = 0
end

function HashMap_new_HashMap() 
	local this13 = nil
	this13 = HashMap:create1()
	HashMap_construct_HashMap(this13)
	return this13
end

function HashMap_construct_HashMap(this14) 
	Table_construct_Table(this14)
	HashMap_HashMap_init(this14)
end

function Table:create2() 
	local new_inst = ({})
	setmetatable(new_inst, ({__index=Table, }))
	return new_inst
end

function Table_Table_hasInt1(this16, parentKey) 
	return hashtable_hasInt(Table_ht, objectToIndex(this16), parentKey)
end

function Table_Table_hasString1(this18, parentKey2) 
	return hashtable_hasString(Table_ht, objectToIndex(this18), parentKey2)
end

function Table_Table_loadInt1(this20, parentKey4) 
	return hashtable_loadInt(Table_ht, objectToIndex(this20), parentKey4)
end

function Table_Table_saveInt1(this22, parentKey6, value1) 
	hashtable_saveInt(Table_ht, objectToIndex(this22), parentKey6, value1)
end

function Table_Table_loadString1(this24, parentKey8) 
	return hashtable_loadString(Table_ht, objectToIndex(this24), parentKey8)
end

function Table_Table_saveString1(this26, parentKey10, value3) 
	hashtable_saveString(Table_ht, objectToIndex(this26), parentKey10, value3)
end

function Table_Table_loadUnit1(this28, parentKey12) 
	return hashtable_loadUnitHandle(Table_ht, objectToIndex(this28), parentKey12)
end

function Table_Table_saveFogState1(this30, parentKey14, value5) 
	hashtable_saveFogStateHandle(Table_ht, objectToIndex(this30), parentKey14, value5)
end

function Table_Table_init(this32) 
end

function Table_new_Table() 
	local this33 = nil
	this33 = Table:create2()
	Table_construct_Table(this33)
	return this33
end

function Table_construct_Table(this15) 
	Table_Table_init(this15)
end

function CallbackSingle_doAfter_Test:create3() 
	local new_inst = ({})
	setmetatable(new_inst, ({__index=CallbackSingle_doAfter_Test, }))
	return new_inst
end

function CallbackSingle_doAfter_Test_call_doAfter_Test(this34) 
	foo()
end

function initGlobals() 
end

function main() 
	local initTrig = nil
	initGlobals()
	initCompiletimeState()
	initTrig = CreateTrigger()
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_AbilityIds(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package AbilityIds.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Real(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Real.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Integer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Integer.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Angle(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Angle.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_String(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package String.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Vectors(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Vectors.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Destructable(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Destructable.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Player(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Player.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Basics(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Basics.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_MagicFunctions(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package MagicFunctions.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Table(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Table.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Playercolor(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Playercolor.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Maths(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Maths.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Colors(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Colors.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Printing(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Printing.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_GameTimer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package GameTimer.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_ErrorHandling(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package ErrorHandling.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_HashList(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package HashList.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Matrices(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Matrices.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Quaternion(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Quaternion.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Framehandle(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Framehandle.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Group(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Group.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Lightning(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Lightning.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_WeatherEffects(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package WeatherEffects.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_TypeCasting(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package TypeCasting.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_TimerUtils(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package TimerUtils.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_ClosureTimers(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package ClosureTimers.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_EventHelper(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package EventHelper.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Test(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Test.")
	end
	TriggerClearConditions(initTrig)
	DestroyTrigger(initTrig)
end

function config() 
end

function init_AbilityIds() 
	return true
end

function init_Angle() 
	Angle_RADTODEG = 57.295779513
	return true
end

function angle_degrees(this35) 
	return (this35[1] * Angle_RADTODEG)
end

function init_Basics() 
	Basics_ANIMATION_PERIOD = 0.030
	return true
end

function init_ClosureTimers() 
	ClosureTimers_x = 200
	return true
end

function timer_doAfter(this36, timeToWait, cb) 
	cb:ClosureTimers_CallbackSingle_start(this36, timeToWait)
	return cb
end

function doAfter(timeToWait1, cb1) 
	return timer_doAfter(getTimer(), timeToWait1, cb1)
end

function code__start_CallbackSingle_ClosureTimers() 
	CallbackSingle_staticCallback()
end

function CallbackSingle_staticCallback() 
	local t = nil
	local cb2 = nil
	t = GetExpiredTimer()
	cb2 = objectFromIndex(timer_getData(t))
	cb2:ClosureTimers_CallbackSingle_call()
	cb2:destroyCallbackSingle()
end

function init_Colors() 
	Colors_hexs[0] = "0"
	Colors_hexs[1] = "1"
	Colors_hexs[2] = "2"
	Colors_hexs[3] = "3"
	Colors_hexs[4] = "4"
	Colors_hexs[5] = "5"
	Colors_hexs[6] = "6"
	Colors_hexs[7] = "7"
	Colors_hexs[8] = "8"
	Colors_hexs[9] = "9"
	Colors_hexs[10] = "A"
	Colors_hexs[11] = "B"
	Colors_hexs[12] = "C"
	Colors_hexs[13] = "D"
	Colors_hexs[14] = "E"
	Colors_hexs[15] = "F"
	Colors_decs = Table_new_Table()
	Colors_COLOR_WHITE = ({255, 255, 255, 255, })
	Colors_COLOR_BLACK = ({0, 0, 0, 0, })
	Colors_COLOR_GOLD = ({255, 204, 0, 255, })
	colorA_toColorString(Colors_COLOR_WHITE)
	colorA_toColorString(Colors_COLOR_BLACK)
	colorA_toColorString(Colors_COLOR_GOLD)
	initializeTable()
	return true
end

function colorA_toColorString(this38) 
	return stringConcat(stringConcat(stringConcat(stringConcat("|c", toHex(this38[4])), toHex(this38[1])), toHex(this38[2])), toHex(this38[3]))
end

function toHex(number) 
	local firstpart = nil
	local secondpart = nil
	firstpart = (number // 16)
	secondpart = (number - (firstpart * 16))
	return stringConcat(Colors_hexs[firstpart], Colors_hexs[secondpart])
end

function initializeTable() 
	local i = nil
	i = 0
	while true do
		if (i > 15) then
			break
		end
		Colors_decs:Table_Table_saveInt(string_getHash(Colors_hexs[i]), i)
		i = (i + 1)
	end
end

function init_Destructable() 
	return true
end

function init_ErrorHandling() 
	ErrorHandling_MUTE_ERROR_DURATION = 60
	ErrorHandling_PRIMARY_ERROR_KEY = -1
	ErrorHandling_HT = hashtable_compiletime2
	ErrorHandling_suppressErrorMessages = false
	return true
end

function error1(msg) 
	local hash = nil
	if MagicFunctions_compiletime then
		compileError(stringConcat("ERROR: ", msg))
	else
		if not(ErrorHandling_suppressErrorMessages) then
			hash = string_getHash(msg)
			if hashtable_hasInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) then
				if ((hashtable_loadInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) + ErrorHandling_MUTE_ERROR_DURATION) < GameTimer_currentTime) then
					Log_error(stringConcat(msg, "$Stacktrace$"))
					hashtable_saveInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, real_toInt(GameTimer_currentTime))
					hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, false)
				elseif hashtable_hasBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) then
					if not(hashtable_loadBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash)) then
						Log_error("|cffFF3A29Excessive repeating errors are being omitted")
						hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, true)
					end
				else
					Log_error("|cffFF3A29Excessive repeating errors are being omitted")
					hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, true)
				end
			else
				hashtable_saveInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, real_toInt(GameTimer_currentTime))
				Log_error(stringConcat(stringConcat("Message: ", msg), "$Stacktrace$"))
			end
		end
		tostring((1 // 0))
	end
end

function init_EventHelper() 
	HashMap_new_HashMap()
	HashMap_new_HashMap()
	Table_new_Table()
	return true
end

function init_Framehandle() 
	local receiver2 = nil
	Framehandle_GAME_UI = BlzGetOriginFrame(ORIGIN_FRAME_GAME_UI, 0)
	BlzGetOriginFrame(ORIGIN_FRAME_WORLD_FRAME, 0)
	Framehandle_BLZ_FRAMENAME_MAXLENGTH = 560
	receiver2 = createFrame("FRAME", "SetMousePositionCage", Framehandle_GAME_UI, "", 0)
	framehandle_setSize(receiver2, 0.0001, 0.0001)
	return true
end

function verifyFrameNameLength(name1) 
	if (string_length(name1) > Framehandle_BLZ_FRAMENAME_MAXLENGTH) then
		error1(stringConcat(stringConcat(stringConcat("Trying to address frame with exceeding maximum frame name length (", int_toString(Framehandle_BLZ_FRAMENAME_MAXLENGTH)), ") for: "), name1))
		return false
	end
	return true
end

function createFrame(typeName, name, owner, inherits, createContext) 
	verifyFrameNameLength(name)
	return BlzCreateFrameByType(typeName, name, owner, inherits, createContext)
end

function framehandle_setSize(this44, width, height) 
	BlzFrameSetSize(this44, width, height)
end

function init_GameTimer() 
	local receiver3 = nil
	receiver3 = CreateTimer()
	timer_start(receiver3, 100000., nil)
	timer_startPeriodic(CreateTimer(), Basics_ANIMATION_PERIOD, function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = code__startPeriodic_GameTimer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end)
	return true
end

function code__startPeriodic_GameTimer() 
	GameTimer_currentTime = (GameTimer_currentTime + Basics_ANIMATION_PERIOD)
end

function init_Group() 
	CreateGroup()
	return true
end

function init_HashList() 
	HashList_ht = hashtable_compiletime
	HashList_occurences = hashtable_compiletime1
	return true
end

function hashtable_hasBoolean(this42, parentKey17, childKey9) 
	return HaveSavedBoolean(this42, parentKey17, childKey9)
end

function hashtable_hasInt(this17, parentKey1, childKey) 
	return HaveSavedInteger(this17, parentKey1, childKey)
end

function hashtable_hasString(this19, parentKey3, childKey1) 
	return HaveSavedString(this19, parentKey3, childKey1)
end

function hashtable_loadBoolean(this43, parentKey18, childKey10) 
	return LoadBoolean(this43, parentKey18, childKey10)
end

function hashtable_loadInt(this21, parentKey5, childKey2) 
	return LoadInteger(this21, parentKey5, childKey2)
end

function hashtable_loadString(this25, parentKey9, childKey4) 
	return LoadStr(this25, parentKey9, childKey4)
end

function hashtable_loadUnitHandle(this29, parentKey13, childKey6) 
	return LoadUnitHandle(this29, parentKey13, childKey6)
end

function hashtable_saveBoolean(this41, parentKey16, childKey8, value7) 
	SaveBoolean(this41, parentKey16, childKey8, value7)
end

function hashtable_saveFogStateHandle(this31, parentKey15, childKey7, value6) 
	SaveFogStateHandle(this31, parentKey15, childKey7, value6)
end

function hashtable_saveInt(this23, parentKey7, childKey3, value2) 
	SaveInteger(this23, parentKey7, childKey3, value2)
end

function hashtable_saveString(this27, parentKey11, childKey5, value4) 
	SaveStr(this27, parentKey11, childKey5, value4)
end

function init_Integer() 
	return true
end

function int_toString(this46) 
	return tostring(this46)
end

function init_Lightning() 
	return true
end

function init_MagicFunctions() 
	MagicFunctions_compiletime = false
	return true
end

function compileError(msg1) 
end

function init_Maths() 
	return true
end

function init_Matrices() 
	return true
end

function init_Player() 
	Player_localPlayer = GetLocalPlayer()
	initPlayerArray()
	return true
end

function initPlayerArray() 
	local i1 = nil
	local temp = nil
	i1 = 0
	temp = (bj_MAX_PLAYER_SLOTS - 1)
	while true do
		if (i1 > temp) then
			break
		end
		Player_players[i1] = Player(i1)
		i1 = (i1 + 1)
	end
end

function init_Playercolor() 
	ConvertPlayerColor(24)
	ConvertPlayerColor(25)
	ConvertPlayerColor(26)
	ConvertPlayerColor(27)
	return true
end

function init_Printing() 
	Printing_DEBUG_LEVEL = 2
	Printing_DEBUG_MSG_DURATION = 45.
	return true
end

function Loglevel_getTag(this48) 
	local temp1 = nil
	temp1 = this48
	if (temp1 == 0) then
		return "|cffADADADtrace|r"
	elseif (temp1 == 1) then
		return "|cff2685DCdebug|r"
	elseif (temp1 == 2) then
		return "|cffFFCC00info|r"
	elseif (temp1 == 3) then
		return "|cffF47E3Ewarning|r"
	else
		return "|cffFB2700error|r"
	end
end

function printLog(showTo, loglvl, msg3) 
	local compositeMsg = nil
	if (Printing_DEBUG_LEVEL <= loglvl) then
		compositeMsg = stringConcat(stringConcat(Loglevel_getTag(loglvl), " - "), msg3)
		DisplayTimedTextToPlayer(showTo, 0., 0., Printing_DEBUG_MSG_DURATION, compositeMsg)
	end
end

function print1(msg4) 
	DisplayTimedTextToPlayer(Player_localPlayer, 0., 0., Printing_DEBUG_MSG_DURATION, msg4)
end

function print2(msg5) 
	print1(tostring(msg5))
end

function print3(msg6) 
	print1(R2S(msg6))
end

function print4(msg7) 
	local msgString = nil
	msgString = "False"
	if msg7 then
		msgString = "True"
	end
	print1(msgString)
end

function Log_error(msg2) 
	printLog(Player_localPlayer, 4, msg2)
end

function init_Quaternion() 
	return true
end

function init_Real() 
	return true
end

function real_toInt(this40) 
	return R2I(this40)
end

function init_String() 
	String_charset = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	String_numberset = "0123456789"
	string_length(String_numberset)
	string_length(String_charset)
	return true
end

function string_length(this45) 
	return StringLength(this45)
end

function string_getHash(this39) 
	return StringHash(this39)
end

function init_Table() 
	Table_ht = hashtable_compiletime3
	return true
end

function init_Test() 
	local clVar = nil
	Test_intMap = HashMap_new_HashMap()
	Test_realMap = HashMap_new_HashMap()
	Test_boolMap = HashMap_new_HashMap()
	Test_strMap = HashMap_new_HashMap()
	Test_unitMap = HashMap_new_HashMap()
	HashMap_new_HashMap()
	clVar = CallbackSingle_doAfter_Test:create3()
	CallbackSingle_construct_CallbackSingle(clVar)
	doAfter(0.0, clVar)
	return true
end

function foo() 
	local aString = nil
	local s = nil
	local u = nil
	local i2 = nil
	local r = nil
	local b = nil
	local u1 = nil
	Test_strMap:HashMap_HashMap_put(stringToIndex("a"), stringToIndex("some string"))
	print1(stringFromIndex(intEnsure(Test_strMap:HashMap_HashMap_get(stringToIndex("a")))))
	aString = stringFromIndex(intEnsure(Test_strMap:HashMap_HashMap_get(stringToIndex("a"))))
	s = stringConcat("hjgf", stringFromIndex(intEnsure(Test_strMap:HashMap_HashMap_get(stringToIndex("a")))))
	print1(s)
	s = stringConcat("hjgf", aString)
	print1(s)
	s = stringConcat(stringFromIndex(intEnsure(Test_strMap:HashMap_HashMap_get(stringToIndex("a")))), stringFromIndex(intEnsure(Test_strMap:HashMap_HashMap_get(stringToIndex("a")))))
	print1(s)
	if not(MagicFunctions_compiletime) then
		u = unitFromIndex(intEnsure(Test_unitMap:HashMap_HashMap_get(unitToIndex(nil))))
		print1(unit_getName(u))
	end
	i2 = intEnsure(Test_intMap:HashMap_HashMap_get(0))
	print2(i2)
	r = realFromIndex(intEnsure(Test_realMap:HashMap_HashMap_get(realToIndex(0.0))))
	print3(r)
	b = booleanFromIndex(intEnsure(Test_boolMap:HashMap_HashMap_get(booleanToIndex(true))))
	print4(b)
	if not(MagicFunctions_compiletime) then
		Test_unitMap:HashMap_HashMap_put(unitToIndex(nil), unitToIndex(createUnit(Player_players[0], 1751543663, ({0., 0., }), ({0., }))))
		u1 = unitFromIndex(intEnsure(Test_unitMap:HashMap_HashMap_get(unitToIndex(nil))))
		print1(unit_getName(u1))
	end
	Test_intMap:HashMap_HashMap_put(4, 8)
	i2 = intEnsure(Test_intMap:HashMap_HashMap_get(4))
	print2(i2)
	Test_realMap:HashMap_HashMap_put(realToIndex(3.7754), realToIndex(591.53))
	r = realFromIndex(intEnsure(Test_realMap:HashMap_HashMap_get(realToIndex(3.7754))))
	print3(r)
	Test_boolMap:HashMap_HashMap_put(booleanToIndex(true), booleanToIndex(true))
	b = booleanFromIndex(intEnsure(Test_boolMap:HashMap_HashMap_get(booleanToIndex(true))))
	print4(b)
end

function init_TimerUtils() 
	TimerUtils_freeTimersCount = 0
	TimerUtils_timerData = Table_new_Table()
	TimerUtils_HELD = 679645218
	HashMap_new_HashMap()
	return true
end

function timer_setData(this1, data) 
	TimerUtils_timerData:Table_Table_saveInt(timer_getHandleId(this1), data)
end

function timer_getData(this37) 
	return TimerUtils_timerData:Table_Table_loadInt(timer_getHandleId(this37))
end

function getTimer() 
	local receiver4 = nil
	if (TimerUtils_freeTimersCount > 0) then
		TimerUtils_freeTimersCount = (TimerUtils_freeTimersCount - 1)
		timer_setData(TimerUtils_freeTimers[TimerUtils_freeTimersCount], 0)
		return TimerUtils_freeTimers[TimerUtils_freeTimersCount]
	else
		receiver4 = CreateTimer()
		timer_setData(receiver4, 0)
		return receiver4
	end
end

function timer_release(this8) 
	if (this8 == nil) then
		error1("Trying to release a null timer")
		return 
	end
	if (timer_getData(this8) == TimerUtils_HELD) then
		error1("ReleaseTimer: Double free!")
		return 
	end
	timer_setData(this8, TimerUtils_HELD)
	timer_pause(this8)
	TimerUtils_freeTimers[TimerUtils_freeTimersCount] = this8
	TimerUtils_freeTimersCount = (TimerUtils_freeTimersCount + 1)
end

function timer_getHandleId(this50) 
	return GetHandleId(this50)
end

function timer_pause(this51) 
	PauseTimer(this51)
end

function timer_start(this2, time1, timerCallBack) 
	TimerStart(this2, time1, false, timerCallBack)
end

function timer_startPeriodic(this47, time2, timerCallBack1) 
	TimerStart(this47, time2, true, timerCallBack1)
end

function init_TypeCasting() 
	TypeCasting_typecastdata = Table_new_Table()
	TypeCasting_R2I_PRECISION = 1000.
	initTypecastData()
	return true
end

function initTypecastData() 
	TypeCasting_typecastdata:Table_Table_saveString(0, "")
end

function realToIndex(r1) 
	return real_toInt((r1 * TypeCasting_R2I_PRECISION))
end

function realFromIndex(index2) 
	return (index2 / TypeCasting_R2I_PRECISION)
end

function stringToIndex(s1) 
	local hash1 = nil
	hash1 = string_getHash(s1)
	while true do
		if not(true) then
			break
		end
		if TypeCasting_typecastdata:Table_Table_hasString(hash1) then
			if (TypeCasting_typecastdata:Table_Table_loadString(hash1) == s1) then
				if true then
					break
				end
			end
		else
			TypeCasting_typecastdata:Table_Table_saveString(hash1, s1)
			if true then
				break
			end
		end
		hash1 = (hash1 + 1)
	end
	return hash1
end

function stringFromIndex(index) 
	local str = nil
	str = TypeCasting_typecastdata:Table_Table_loadString(index)
	return str
end

function unitFromIndex(index1) 
	TypeCasting_typecastdata:Table_Table_saveFogState(0, ConvertFogState(index1))
	return TypeCasting_typecastdata:Table_Table_loadUnit(0)
end

function unitToIndex(object) 
	return handle_getHandleId(object)
end

function booleanToIndex(u2) 
	local cond_result = nil
	if u2 then
		cond_result = 1
	else
		cond_result = 0
	end
	return cond_result
end

function booleanFromIndex(index3) 
	return (index3 == 1)
end

function createUnit(p, unitId, pos, facing) 
	return CreateUnit(p, unitId, pos[1], pos[2], angle_degrees(facing))
end

function handle_getHandleId(this52) 
	return GetHandleId(this52)
end

function unit_getName(this49) 
	return GetUnitName(this49)
end

function init_Vectors() 
	Location(0., 0.)
	return true
end

function init_WeatherEffects() 
	return true
end

function initCompiletimeState() 
	initCompiletimeState_0()
end

function initCompiletimeState_0() 
	hashtable_compiletime3 = InitHashtable()
	hashtable_compiletime2 = InitHashtable()
	hashtable_compiletime1 = InitHashtable()
	hashtable_compiletime = InitHashtable()
	SaveInteger(hashtable_compiletime3, 1, -242600650, 0)
	SaveInteger(hashtable_compiletime3, 1, 1132341824, 1)
	SaveInteger(hashtable_compiletime3, 1, -647782241, 2)
	SaveInteger(hashtable_compiletime3, 1, -854572045, 3)
	SaveInteger(hashtable_compiletime3, 1, -680649701, 4)
	SaveInteger(hashtable_compiletime3, 1, -943650483, 5)
	SaveInteger(hashtable_compiletime3, 1, -671760605, 6)
	SaveInteger(hashtable_compiletime3, 1, 349230650, 7)
	SaveInteger(hashtable_compiletime3, 1, -1894922563, 8)
	SaveInteger(hashtable_compiletime3, 1, -1474492777, 9)
	SaveInteger(hashtable_compiletime3, 1, -1587459251, 10)
	SaveInteger(hashtable_compiletime3, 1, -1676716706, 11)
	SaveInteger(hashtable_compiletime3, 1, -1559655710, 12)
	SaveInteger(hashtable_compiletime3, 1, -1663695754, 13)
	SaveInteger(hashtable_compiletime3, 1, 597637742, 14)
	SaveInteger(hashtable_compiletime3, 1, 789744696, 15)
	SaveStr(hashtable_compiletime3, 2, 0, "")
	SaveStr(hashtable_compiletime3, 2, -1587459251, "a")
	SaveStr(hashtable_compiletime3, 2, -848360345, "some string")
	SaveInteger(hashtable_compiletime3, 3, -1587459251, -848360345)
	SaveInteger(hashtable_compiletime3, 4, 4, 8)
	SaveInteger(hashtable_compiletime3, 5, 3775, 591530)
	SaveInteger(hashtable_compiletime3, 6, 1, 1)
end

CallbackSingle.destroyCallbackSingle = CallbackSingle_destroyCallbackSingle
CallbackSingle.ClosureTimers_CallbackSingle_start = CallbackSingle_CallbackSingle_start
CallbackSingle.__wurst_supertypes = ({[CallbackSingle] = true, })
CallbackSingle.__typeId__ = 1
HashMap.HashMap_HashMap_has = HashMap_HashMap_has1
HashMap.HashMap_HashMap_put = HashMap_HashMap_put1
HashMap.HashMap_HashMap_get = HashMap_HashMap_get1
HashMap.Table_Table_hasInt = Table_Table_hasInt1
HashMap.Table_Table_hasString = Table_Table_hasString1
HashMap.Table_Table_loadInt = Table_Table_loadInt1
HashMap.Table_Table_saveInt = Table_Table_saveInt1
HashMap.Table_Table_loadString = Table_Table_loadString1
HashMap.Table_Table_saveString = Table_Table_saveString1
HashMap.Table_Table_loadUnit = Table_Table_loadUnit1
HashMap.Table_Table_saveFogState = Table_Table_saveFogState1
HashMap.__wurst_supertypes = ({[HashMap] = true, [Table] = true, })
HashMap.__typeId__ = 4
Table.Table_Table_hasInt = Table_Table_hasInt1
Table.Table_Table_hasString = Table_Table_hasString1
Table.Table_Table_loadInt = Table_Table_loadInt1
Table.Table_Table_saveInt = Table_Table_saveInt1
Table.Table_Table_loadString = Table_Table_loadString1
Table.Table_Table_saveString = Table_Table_saveString1
Table.Table_Table_loadUnit = Table_Table_loadUnit1
Table.Table_Table_saveFogState = Table_Table_saveFogState1
Table.__wurst_supertypes = ({[Table] = true, })
Table.__typeId__ = 3
CallbackSingle_doAfter_Test.ClosureTimers_CallbackSingle_call = CallbackSingle_doAfter_Test_call_doAfter_Test
CallbackSingle_doAfter_Test.destroyCallbackSingle = CallbackSingle_destroyCallbackSingle
CallbackSingle_doAfter_Test.ClosureTimers_CallbackSingle_start = CallbackSingle_CallbackSingle_start
CallbackSingle_doAfter_Test.__wurst_supertypes = ({[CallbackSingle_doAfter_Test] = true, [CallbackSingle] = true, })
CallbackSingle_doAfter_Test.__typeId__ = 2
