function defaultArray(d) 
	local t = {}
	local mt = {__index = function (table, key)
	    local v = d()
	    table[key] = v
	    return v
	end}
	setmetatable(t, mt)
	return t
end

function stringConcat(x, y) 
	if x then
	    if y then return x .. y else return x end
	else
	    return y
	end
end

function isInstanceOf(x, A) 
	return x ~= nil and x.__wurst_supertypes[A]
end

__wurst_objectIndexMap = ({counter=0, })
__wurst_number_wrapper_map = ({counter=0, })

function objectToIndex(x) 
	if x == nil then
	    return 0
	end
	if type(x) == "number" then
	    if __wurst_number_wrapper_map[x] then
	        x = __wurst_number_wrapper_map[x]
	    else
	        local obj = {__wurst_boxed_number = x}
	        __wurst_number_wrapper_map[x] = obj
	        x = obj
	    end
	end
	if __wurst_objectIndexMap[x] then
	    return __wurst_objectIndexMap[x]
	else
	   local r = __wurst_objectIndexMap.counter + 1
	   __wurst_objectIndexMap.counter = r
	   __wurst_objectIndexMap[r] = x
	   __wurst_objectIndexMap[x] = r
	   return r
	end
end

function objectFromIndex(x) 
	if type(x) == "number" then
	    x = __wurst_objectIndexMap[x]
	end
	if type(x) == "table" and x.__wurst_boxed_number then
	    return x.__wurst_boxed_number
	end
	return x
end

function intEnsure(x) 
	if x == nil then
	    return 0
	else
	    return math.tointeger(x)
	end
end

function boolEnsure(x) 
	if x == nil then
	    return false
	else
	    return x
	end
end

function realEnsure(x) 
	if x == nil then
	    return 0.0
	else
	    return x
	end
end

function stringEnsure(x) 
	if x == nil then
	    return ""
	else
	    return x
	end
end

Basics_ANIMATION_PERIOD = 0.
Colors_hexs = defaultArray(function () 
		return nil
	end)
Colors_decs = nil
Colors_COLOR_WHITE = ({0, 0, 0, 0, })
Colors_COLOR_BLACK = ({0, 0, 0, 0, })
Colors_COLOR_GOLD = ({0, 0, 0, 0, })
ErrorHandling_MUTE_ERROR_DURATION = 0
ErrorHandling_PRIMARY_ERROR_KEY = 0
ErrorHandling_HT = nil
ErrorHandling_suppressErrorMessages = false
Framehandle_GAME_UI = nil
Framehandle_BLZ_FRAMENAME_MAXLENGTH = 0
GameTimer_currentTime = 0.
MagicFunctions_compiletime = false
Player_localPlayer = nil
Printing_DEBUG_LEVEL = 0
Printing_DEBUG_MSG_DURATION = 0.
String_charset = nil
String_numberset = nil
Table_ht = nil
Test_nullA1 = nil
Test_nullA2 = nil
Test_nullA3 = nil
Test_nullA4 = nil
Test_zeroInt0 = 0
Test_zeroInt1 = 0
Test_zeroInt2 = 0
Test_zeroInt3 = 0
Test_zeroInt4 = 0
hashtable_compiletime = nil
hashtable_compiletime1 = nil
Table = ({})
A = ({})

function Table:create() 
	local new_inst = ({})
	setmetatable(new_inst, ({__index=Table, }))
	return new_inst
end

function Table_Table_saveInt1(this, parentKey, value) 
	hashtable_saveInt(Table_ht, objectToIndex(this), parentKey, value)
end

function Table_Table_init(this2) 
end

function Table_new_Table() 
	local this3 = nil
	this3 = Table:create()
	Table_construct_Table(this3)
	return this3
end

function Table_construct_Table(this4) 
	Table_Table_init(this4)
end

function A:create1() 
	local new_inst = ({})
	setmetatable(new_inst, ({__index=A, }))
	return new_inst
end

function A_A_foo(this5) 
	print1("I am A")
end

function initGlobals() 
end

function main() 
	local initTrig = nil
	initGlobals()
	initCompiletimeState()
	initTrig = CreateTrigger()
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_AbilityIds(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package AbilityIds.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Real(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Real.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Integer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Integer.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Angle(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Angle.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_String(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package String.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Vectors(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Vectors.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Destructable(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Destructable.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Player(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Player.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Basics(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Basics.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_MagicFunctions(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package MagicFunctions.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Table(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Table.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Playercolor(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Playercolor.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Maths(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Maths.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Colors(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Colors.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Printing(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Printing.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_GameTimer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package GameTimer.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_ErrorHandling(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package ErrorHandling.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Framehandle(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Framehandle.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Group(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Group.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Lightning(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Lightning.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Matrices(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Matrices.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Quaternion(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Quaternion.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_WeatherEffects(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package WeatherEffects.")
	end
	TriggerClearConditions(initTrig)
	TriggerAddCondition(initTrig, Condition(function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = init_Test(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end))
	if not(TriggerEvaluate(initTrig)) then
		error1("Could not initialize package Test.")
	end
	TriggerClearConditions(initTrig)
	DestroyTrigger(initTrig)
end

function config() 
end

function init_AbilityIds() 
	return true
end

function init_Angle() 
	return true
end

function init_Basics() 
	Basics_ANIMATION_PERIOD = 0.030
	return true
end

function init_Colors() 
	Colors_hexs[0] = "0"
	Colors_hexs[1] = "1"
	Colors_hexs[2] = "2"
	Colors_hexs[3] = "3"
	Colors_hexs[4] = "4"
	Colors_hexs[5] = "5"
	Colors_hexs[6] = "6"
	Colors_hexs[7] = "7"
	Colors_hexs[8] = "8"
	Colors_hexs[9] = "9"
	Colors_hexs[10] = "A"
	Colors_hexs[11] = "B"
	Colors_hexs[12] = "C"
	Colors_hexs[13] = "D"
	Colors_hexs[14] = "E"
	Colors_hexs[15] = "F"
	Colors_decs = Table_new_Table()
	Colors_COLOR_WHITE = ({255, 255, 255, 255, })
	Colors_COLOR_BLACK = ({0, 0, 0, 0, })
	Colors_COLOR_GOLD = ({255, 204, 0, 255, })
	colorA_toColorString(Colors_COLOR_WHITE)
	colorA_toColorString(Colors_COLOR_BLACK)
	colorA_toColorString(Colors_COLOR_GOLD)
	initializeTable()
	return true
end

function colorA_toColorString(this6) 
	return stringConcat(stringConcat(stringConcat(stringConcat("|c", toHex(this6[4])), toHex(this6[1])), toHex(this6[2])), toHex(this6[3]))
end

function toHex(number) 
	local firstpart = nil
	local secondpart = nil
	firstpart = (number // 16)
	secondpart = (number - (firstpart * 16))
	return stringConcat(Colors_hexs[firstpart], Colors_hexs[secondpart])
end

function initializeTable() 
	local i = nil
	i = 0
	while true do
		if (i > 15) then
			break
		end
		Colors_decs:Table_Table_saveInt(string_getHash(Colors_hexs[i]), i)
		i = (i + 1)
	end
end

function init_Destructable() 
	return true
end

function init_ErrorHandling() 
	ErrorHandling_MUTE_ERROR_DURATION = 60
	ErrorHandling_PRIMARY_ERROR_KEY = -1
	ErrorHandling_HT = hashtable_compiletime
	ErrorHandling_suppressErrorMessages = false
	return true
end

function error1(msg1) 
	local hash = nil
	if MagicFunctions_compiletime then
		compileError(stringConcat("ERROR: ", msg1))
	else
		if not(ErrorHandling_suppressErrorMessages) then
			hash = string_getHash(msg1)
			if hashtable_hasInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) then
				if ((hashtable_loadInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) + ErrorHandling_MUTE_ERROR_DURATION) < GameTimer_currentTime) then
					Log_error(stringConcat(msg1, "$Stacktrace$"))
					hashtable_saveInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, real_toInt(GameTimer_currentTime))
					hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, false)
				elseif hashtable_hasBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash) then
					if not(hashtable_loadBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash)) then
						Log_error("|cffFF3A29Excessive repeating errors are being omitted")
						hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, true)
					end
				else
					Log_error("|cffFF3A29Excessive repeating errors are being omitted")
					hashtable_saveBoolean(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, true)
				end
			else
				hashtable_saveInt(ErrorHandling_HT, ErrorHandling_PRIMARY_ERROR_KEY, hash, real_toInt(GameTimer_currentTime))
				Log_error(stringConcat(stringConcat("Message: ", msg1), "$Stacktrace$"))
			end
		end
		tostring((1 // 0))
	end
end

function init_Framehandle() 
	local receiver = nil
	Framehandle_GAME_UI = BlzGetOriginFrame(ORIGIN_FRAME_GAME_UI, 0)
	BlzGetOriginFrame(ORIGIN_FRAME_WORLD_FRAME, 0)
	Framehandle_BLZ_FRAMENAME_MAXLENGTH = 560
	receiver = createFrame("FRAME", "SetMousePositionCage", Framehandle_GAME_UI, "", 0)
	framehandle_setSize(receiver, 0.0001, 0.0001)
	return true
end

function verifyFrameNameLength(name1) 
	if (string_length(name1) > Framehandle_BLZ_FRAMENAME_MAXLENGTH) then
		error1(stringConcat(stringConcat(stringConcat("Trying to address frame with exceeding maximum frame name length (", int_toString(Framehandle_BLZ_FRAMENAME_MAXLENGTH)), ") for: "), name1))
		return false
	end
	return true
end

function createFrame(typeName, name, owner, inherits, createContext) 
	verifyFrameNameLength(name)
	return BlzCreateFrameByType(typeName, name, owner, inherits, createContext)
end

function framehandle_setSize(this14, width, height) 
	BlzFrameSetSize(this14, width, height)
end

function init_GameTimer() 
	local receiver1 = nil
	receiver1 = CreateTimer()
	timer_start(receiver1, 100000., nil)
	timer_startPeriodic(CreateTimer(), Basics_ANIMATION_PERIOD, function (...) 
			local temp = ...
			local tempRes = nil
			xpcall(function () 
					tempRes = code__startPeriodic_GameTimer(temp)
				end, function(err) xpcall(function() error1(tostring(err)) end, function(err2) BJDebugMsg("error reporting error: " .. tostring(err2)) BJDebugMsg("while reporting: " .. tostring(err))  end) end)
			return tempRes
		end)
	return true
end

function code__startPeriodic_GameTimer() 
	GameTimer_currentTime = (GameTimer_currentTime + Basics_ANIMATION_PERIOD)
end

function init_Group() 
	CreateGroup()
	return true
end

function hashtable_hasBoolean(this12, parentKey5, childKey4) 
	return HaveSavedBoolean(this12, parentKey5, childKey4)
end

function hashtable_hasInt(this8, parentKey2, childKey1) 
	return HaveSavedInteger(this8, parentKey2, childKey1)
end

function hashtable_loadBoolean(this13, parentKey6, childKey5) 
	return LoadBoolean(this13, parentKey6, childKey5)
end

function hashtable_loadInt(this9, parentKey3, childKey2) 
	return LoadInteger(this9, parentKey3, childKey2)
end

function hashtable_saveBoolean(this11, parentKey4, childKey3, value2) 
	SaveBoolean(this11, parentKey4, childKey3, value2)
end

function hashtable_saveInt(this1, parentKey1, childKey, value1) 
	SaveInteger(this1, parentKey1, childKey, value1)
end

function init_Integer() 
	return true
end

function int_toString(this16) 
	return tostring(this16)
end

function init_Lightning() 
	return true
end

function init_MagicFunctions() 
	MagicFunctions_compiletime = false
	return true
end

function compileError(msg2) 
end

function init_Maths() 
	return true
end

function init_Matrices() 
	return true
end

function init_Player() 
	Player_localPlayer = GetLocalPlayer()
	initPlayerArray()
	return true
end

function initPlayerArray() 
	local i1 = nil
	local temp = nil
	i1 = 0
	temp = (bj_MAX_PLAYER_SLOTS - 1)
	while true do
		if (i1 > temp) then
			break
		end
		Player(i1)
		i1 = (i1 + 1)
	end
end

function init_Playercolor() 
	ConvertPlayerColor(24)
	ConvertPlayerColor(25)
	ConvertPlayerColor(26)
	ConvertPlayerColor(27)
	return true
end

function init_Printing() 
	Printing_DEBUG_LEVEL = 2
	Printing_DEBUG_MSG_DURATION = 45.
	return true
end

function Loglevel_getTag(this19) 
	local temp1 = nil
	temp1 = this19
	if (temp1 == 0) then
		return "|cffADADADtrace|r"
	elseif (temp1 == 1) then
		return "|cff2685DCdebug|r"
	elseif (temp1 == 2) then
		return "|cffFFCC00info|r"
	elseif (temp1 == 3) then
		return "|cffF47E3Ewarning|r"
	else
		return "|cffFB2700error|r"
	end
end

function printLog(showTo, loglvl, msg4) 
	local compositeMsg = nil
	if (Printing_DEBUG_LEVEL <= loglvl) then
		compositeMsg = stringConcat(stringConcat(Loglevel_getTag(loglvl), " - "), msg4)
		DisplayTimedTextToPlayer(showTo, 0., 0., Printing_DEBUG_MSG_DURATION, compositeMsg)
	end
end

function Log_error(msg3) 
	printLog(Player_localPlayer, 4, msg3)
end

function init_Quaternion() 
	return true
end

function init_Real() 
	return true
end

function real_toInt(this10) 
	return R2I(this10)
end

function init_String() 
	String_charset = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	String_numberset = "0123456789"
	string_length(String_numberset)
	string_length(String_charset)
	return true
end

function string_length(this15) 
	return StringLength(this15)
end

function string_getHash(this7) 
	return StringHash(this7)
end

function init_Table() 
	Table_ht = hashtable_compiletime1
	return true
end

function init_Test() 
	Test_nullA1 = nil
	Test_nullA2 = nil
	Test_nullA3 = nil
	Test_nullA4 = nil
	Test_zeroInt0 = 0
	Test_zeroInt1 = intEnsure(0)
	Test_zeroInt2 = intEnsure(0)
	Test_zeroInt3 = intEnsure(0)
	Test_zeroInt4 = intEnsure(0)
	Test_nullA1:Test_A_foo()
	Test_nullA2:Test_A_foo()
	Test_nullA3:Test_A_foo()
	Test_nullA4:Test_A_foo()
	print1(tostring(((((Test_zeroInt0 + Test_zeroInt1) + Test_zeroInt2) + Test_zeroInt3) + Test_zeroInt4)))
	return true
end

function print1(msg) 
	DisplayTimedTextToPlayer(GetLocalPlayer(), 0., 0., 45., msg)
end

function timer_start(this17, time, timerCallBack) 
	TimerStart(this17, time, false, timerCallBack)
end

function timer_startPeriodic(this18, time1, timerCallBack1) 
	TimerStart(this18, time1, true, timerCallBack1)
end

function init_Vectors() 
	Location(0., 0.)
	return true
end

function init_WeatherEffects() 
	return true
end

function initCompiletimeState() 
	initCompiletimeState_0()
end

function initCompiletimeState_0() 
	hashtable_compiletime1 = InitHashtable()
	hashtable_compiletime = InitHashtable()
	SaveInteger(hashtable_compiletime1, 1, -242600650, 0)
	SaveInteger(hashtable_compiletime1, 1, 1132341824, 1)
	SaveInteger(hashtable_compiletime1, 1, -647782241, 2)
	SaveInteger(hashtable_compiletime1, 1, -854572045, 3)
	SaveInteger(hashtable_compiletime1, 1, -680649701, 4)
	SaveInteger(hashtable_compiletime1, 1, -943650483, 5)
	SaveInteger(hashtable_compiletime1, 1, -671760605, 6)
	SaveInteger(hashtable_compiletime1, 1, 349230650, 7)
	SaveInteger(hashtable_compiletime1, 1, -1894922563, 8)
	SaveInteger(hashtable_compiletime1, 1, -1474492777, 9)
	SaveInteger(hashtable_compiletime1, 1, -1587459251, 10)
	SaveInteger(hashtable_compiletime1, 1, -1676716706, 11)
	SaveInteger(hashtable_compiletime1, 1, -1559655710, 12)
	SaveInteger(hashtable_compiletime1, 1, -1663695754, 13)
	SaveInteger(hashtable_compiletime1, 1, 597637742, 14)
	SaveInteger(hashtable_compiletime1, 1, 789744696, 15)
end

Table.Table_Table_saveInt = Table_Table_saveInt1
Table.__wurst_supertypes = ({[Table] = true, })
Table.__typeId__ = 2
A.Test_A_foo = A_A_foo
A.__wurst_supertypes = ({[A] = true, })
A.__typeId__ = 1
