function defaultArray(d) 
	local t = {}
	local mt = {__index = function (table, key)
	    local v = d()
	    table[key] = v
	    return v
	end}
	setmetatable(t, mt)
	return t
end

function stringConcat(x, y) 
	if x then
	    if y then return x .. y else return x end
	else
	    return y
	end
end

function isInstanceOf(x, A) 
	return x ~= nil and x.__wurst_supertypes[A]
end

__wurst_objectIndexMap = ({counter=0, })
__wurst_number_wrapper_map = ({counter=0, })

function objectToIndex(x) 
	if x == nil then
	    return 0
	end
	if type(x) == "number" then
	    if __wurst_number_wrapper_map[x] then
	        x = __wurst_number_wrapper_map[x]
	    else
	        local obj = {__wurst_boxed_number = x}
	        __wurst_number_wrapper_map[x] = obj
	        x = obj
	    end
	end
	if __wurst_objectIndexMap[x] then
	    return __wurst_objectIndexMap[x]
	else
	   local r = __wurst_objectIndexMap.counter + 1
	   __wurst_objectIndexMap.counter = r
	   __wurst_objectIndexMap[r] = x
	   __wurst_objectIndexMap[x] = r
	   return r
	end
end

function objectFromIndex(x) 
	if type(x) == "number" then
	    x = __wurst_objectIndexMap[x]
	end
	if type(x) == "table" and x.__wurst_boxed_number then
	    return x.__wurst_boxed_number
	end
	return x
end

function intEnsure(x) 
	if x == nil then
	    return 0
	else
	    return math.tointeger(x)
	end
end

function boolEnsure(x) 
	if x == nil then
	    return false
	else
	    return x
	end
end

function realEnsure(x) 
	if x == nil then
	    return 0.0
	else
	    return x
	end
end

function stringEnsure(x) 
	if x == nil then
	    return ""
	else
	    return x
	end
end

C = ({})

function C:create() 
	local new_inst = ({})
	setmetatable(new_inst, ({__index=C, }))
	return new_inst
end

function C_C_init(this) 
end

function C_new_C() 
	local this1 = nil
	this1 = C:create()
	C_construct_C(this1)
	return this1
end

function C_construct_C(this2) 
	C_C_init(this2)
end

function initGlobals() 
end

function main() 
	initGlobals()
	init_Test()
end

function config() 
end

function init_Test() 
	testEnum()
	testClass()
end

function testEnum() 
	local zeroEnum = nil
	local zeroInt = nil
	local zeroEnum2 = nil
	zeroEnum = 0
	zeroInt = zeroEnum
	zeroEnum2 = zeroInt
	takesInt(zeroEnum)
	takesInt(zeroInt)
	takesInt(zeroEnum2)
end

if takesInt then
else
	takesInt = function (i) 
			error("The native 'takesInt' is not implemented.")
		end
end

function testClass() 
	local cObj = nil
	local cInt = nil
	local cObj2 = nil
	cObj = C_new_C()
	cInt = objectToIndex(cObj)
	cObj2 = objectFromIndex(cInt)
	takesC(cObj)
	takesInt(cInt)
	takesC(cObj2)
end

if takesC then
else
	takesC = function (c) 
			error("The native 'takesC' is not implemented.")
		end
end

C.__wurst_supertypes = ({[C] = true, })
C.__typeId__ = 1
