// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array IntList_elements
integer array IntList_nextFree
integer IntList_firstFree=0
integer IntList_maxIndex=0
integer array IntList_typeId
integer array IntListIterator_nextFree
integer IntListIterator_firstFree=0
integer IntListIterator_maxIndex=0
integer array IntListIterator_typeId
integer array IntList_size
integer array IntListIterator_list
integer array IntListIterator_pos
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set IntList_firstFree = 0
	set IntList_maxIndex = 0
	set IntListIterator_firstFree = 0
	set IntListIterator_maxIndex = 0
endfunction

function IntListIterator_hasNext takes integer this returns boolean
	return IntListIterator_pos[this] < IntList_size[IntListIterator_list[this]]
endfunction

function IntList_getOffset takes integer this returns integer
	return 64 * (this - 1)
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dispatch_IntList_test_IntList_getOffset takes integer this returns integer
	local integer test_IntList_getOffset_result
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.getOffset")
		else
			call error("Called IntList.getOffset on invalid object.")
		endif
	endif
	set test_IntList_getOffset_result = IntList_getOffset(this)
	return test_IntList_getOffset_result
endfunction

function IntList_get takes integer this, integer i returns integer
	return IntList_elements[dispatch_IntList_test_IntList_getOffset(this) + i]
endfunction

function dispatch_IntList_test_IntList_get takes integer this, integer i returns integer
	local integer test_IntList_get_result
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.get")
		else
			call error("Called IntList.get on invalid object.")
		endif
	endif
	set test_IntList_get_result = IntList_get(this, i)
	return test_IntList_get_result
endfunction

function IntListIterator_next takes integer this returns integer
	set IntListIterator_pos[this] = IntListIterator_pos[this] + 1
	return dispatch_IntList_test_IntList_get(IntListIterator_list[this], IntListIterator_pos[this] - 1)
endfunction

function IntListIterator_onDestroy takes integer this returns nothing
endfunction

function dealloc_IntListIterator takes integer obj returns nothing
	if IntListIterator_typeId[obj] == 0 then
		call error("Double free: object of type IntListIterator")
	else
		set IntListIterator_nextFree[IntListIterator_firstFree] = obj
		set IntListIterator_firstFree = IntListIterator_firstFree + 1
		set IntListIterator_typeId[obj] = 0
	endif
endfunction

function destroyIntListIterator takes integer this returns nothing
	call IntListIterator_onDestroy(this)
	call dealloc_IntListIterator(this)
endfunction

function dispatch_IntListIterator_destroyIntListIterator takes integer this returns nothing
	if IntListIterator_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntListIterator.IntListIterator")
		else
			call error("Called IntListIterator.IntListIterator on invalid object.")
		endif
	endif
	call destroyIntListIterator(this)
endfunction

function IntListIterator_close takes integer this returns nothing
	call dispatch_IntListIterator_destroyIntListIterator(this)
endfunction

function dispatch_IntListIterator_test_IntListIterator_close takes integer this returns nothing
	if IntListIterator_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntListIterator.close")
		else
			call error("Called IntListIterator.close on invalid object.")
		endif
	endif
	call IntListIterator_close(this)
endfunction

function IntList_add takes integer this, integer x returns integer
	set IntList_elements[dispatch_IntList_test_IntList_getOffset(this) + IntList_size[this]] = x
	set IntList_size[this] = IntList_size[this] + 1
	return this
endfunction

function dispatch_IntList_test_IntList_add takes integer this, integer x returns integer
	local integer test_IntList_add_result
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.add")
		else
			call error("Called IntList.add on invalid object.")
		endif
	endif
	set test_IntList_add_result = IntList_add(this, x)
	return test_IntList_add_result
endfunction

function alloc_IntListIterator takes nothing returns integer
	local integer this
	if IntListIterator_firstFree == 0 then
		if IntListIterator_maxIndex < 32768 then
			set IntListIterator_maxIndex = IntListIterator_maxIndex + 1
			set this = IntListIterator_maxIndex
			set IntListIterator_typeId[this] = 2
		else
			call error("Out of memory: Could not create IntListIterator.")
			set this = 0
		endif
	else
		set IntListIterator_firstFree = IntListIterator_firstFree - 1
		set this = IntListIterator_nextFree[IntListIterator_firstFree]
		set IntListIterator_typeId[this] = 2
	endif
	return this
endfunction

function IntListIterator_init takes integer this returns nothing
	set IntListIterator_pos[this] = 0
endfunction

function construct_IntListIterator takes integer this, integer list returns nothing
	call IntListIterator_init(this)
	set IntListIterator_list[this] = list
endfunction

function new_IntListIterator takes integer list returns integer
	local integer this = alloc_IntListIterator()
	call construct_IntListIterator(this, list)
	return this
endfunction

function IntList_iterator takes integer this returns integer
	return new_IntListIterator(this)
endfunction

function dispatch_IntList_test_IntList_iterator takes integer this returns integer
	local integer test_IntList_iterator_result
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.iterator")
		else
			call error("Called IntList.iterator on invalid object.")
		endif
	endif
	set test_IntList_iterator_result = IntList_iterator(this)
	return test_IntList_iterator_result
endfunction

function alloc_IntList takes nothing returns integer
	local integer this
	if IntList_firstFree == 0 then
		if IntList_maxIndex < 32768 then
			set IntList_maxIndex = IntList_maxIndex + 1
			set this = IntList_maxIndex
			set IntList_typeId[this] = 1
		else
			call error("Out of memory: Could not create IntList.")
			set this = 0
		endif
	else
		set IntList_firstFree = IntList_firstFree - 1
		set this = IntList_nextFree[IntList_firstFree]
		set IntList_typeId[this] = 1
	endif
	return this
endfunction

function IntList_init takes integer this returns nothing
	set IntList_size[this] = 0
endfunction

function construct_IntList takes integer this returns nothing
	call IntList_init(this)
endfunction

function new_IntList takes nothing returns integer
	local integer this = alloc_IntList()
	call construct_IntList(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer list = dispatch_IntList_test_IntList_add(dispatch_IntList_test_IntList_add(dispatch_IntList_test_IntList_add(new_IntList(), 7), 3), 5)
	local integer sum = 0
	local integer listIterator = dispatch_IntList_test_IntList_iterator(list)
	local integer from = listIterator
	local integer i
	loop
		exitwhen  not IntListIterator_hasNext(from)
		set i = IntListIterator_next(from)
		set sum = sum + i
	endloop
	call dispatch_IntListIterator_test_IntListIterator_close(listIterator)
	if sum == 15 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

