// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
real vec3_moveTowards_return_x=0.
real vec3_moveTowards_return_y=0.
real vec3_moveTowards_return_z=0.
real vec3_op_plus_return_x=0.
real vec3_op_plus_return_y=0.
real vec3_op_plus_return_z=0.
real vec3_op_minus_return_x=0.
real vec3_op_minus_return_y=0.
real vec3_op_minus_return_z=0.
real vec3_op_mult_return_x=0.
real vec3_op_mult_return_y=0.
real vec3_op_mult_return_z=0.
real real_op_mult_return_x=0.
real real_op_mult_return_y=0.
real real_op_mult_return_z=0.
real vec3_normalizedPointerTo_return_x=0.
real vec3_normalizedPointerTo_return_y=0.
real vec3_normalizedPointerTo_return_z=0.
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function vec3_approxEq takes real this_x, real this_y, real this_z, real o_x, real o_y, real o_z returns boolean
	return this_x - 0.01 < o_x and o_x < this_x + 0.01 and this_y - 0.01 < o_y and o_y < this_y + 0.01 and this_z - 0.01 < o_z and o_z < this_z + 0.01
endfunction

function real_op_mult takes real this, real v_x, real v_y, real v_z returns real
	set real_op_mult_return_x = v_x * this
	set real_op_mult_return_y = v_y * this
	set real_op_mult_return_z = v_z * this
	return real_op_mult_return_x
endfunction

function vec3_length takes real this_x, real this_y, real this_z returns real
	return SquareRoot(this_x * this_x + this_y * this_y + this_z * this_z)
endfunction

function vec3_op_minus takes real this_x, real this_y, real this_z, real v_x, real v_y, real v_z returns real
	set vec3_op_minus_return_x = this_x - v_x
	set vec3_op_minus_return_y = this_y - v_y
	set vec3_op_minus_return_z = this_z - v_z
	return vec3_op_minus_return_x
endfunction

function vec3_op_mult takes real this_x, real this_y, real this_z, real factor returns real
	set vec3_op_mult_return_x = this_x * factor
	set vec3_op_mult_return_y = this_y * factor
	set vec3_op_mult_return_z = this_z * factor
	return vec3_op_mult_return_x
endfunction

function vec3_normalizedPointerTo takes real this_x, real this_y, real this_z, real target_x, real target_y, real target_z returns real
	local real tuple_temp = vec3_op_minus(target_x, target_y, target_z, this_x, this_y, this_z)
	local real tuple_temp_1 = vec3_op_minus_return_y
	local real tuple_temp_2 = vec3_op_minus_return_z
	local real diff_x = tuple_temp
	local real diff_y = tuple_temp_1
	local real diff_z = tuple_temp_2
	local real len = vec3_length(diff_x, diff_y, diff_z)
	local real tuple_temp_3
	local real tuple_temp_4
	local real tuple_temp_5
	local real tuple_temp_6
	local real tuple_temp_7
	local real tuple_temp_8
	if len > 0. then
		set tuple_temp_3 = vec3_op_mult(diff_x, diff_y, diff_z, 1. / len)
		set tuple_temp_4 = vec3_op_mult_return_y
		set tuple_temp_5 = vec3_op_mult_return_z
		set diff_x = tuple_temp_3
		set diff_y = tuple_temp_4
		set diff_z = tuple_temp_5
	else
		set tuple_temp_6 = 1.
		set tuple_temp_7 = 0.
		set tuple_temp_8 = 0.
		set diff_x = tuple_temp_6
		set diff_y = tuple_temp_7
		set diff_z = tuple_temp_8
	endif
	set vec3_normalizedPointerTo_return_x = diff_x
	set vec3_normalizedPointerTo_return_y = diff_y
	set vec3_normalizedPointerTo_return_z = diff_z
	return vec3_normalizedPointerTo_return_x
endfunction

function vec3_op_plus takes real this_x, real this_y, real this_z, real v_x, real v_y, real v_z returns real
	set vec3_op_plus_return_x = this_x + v_x
	set vec3_op_plus_return_y = this_y + v_y
	set vec3_op_plus_return_z = this_z + v_z
	return vec3_op_plus_return_x
endfunction

function vec3_moveTowards takes real this_x, real this_y, real this_z, real target_x, real target_y, real target_z, real dist returns real
	set vec3_moveTowards_return_x = vec3_op_plus(this_x, this_y, this_z, real_op_mult(dist, vec3_normalizedPointerTo(this_x, this_y, this_z, target_x, target_y, target_z), vec3_normalizedPointerTo_return_y, vec3_normalizedPointerTo_return_z), real_op_mult_return_y, real_op_mult_return_z)
	set vec3_moveTowards_return_y = vec3_op_plus_return_y
	set vec3_moveTowards_return_z = vec3_op_plus_return_z
	return vec3_moveTowards_return_x
endfunction

function init_test takes nothing returns nothing
	local real tuple_temp = vec3_moveTowards(0., 0., 0., 1., 2., 3., 10.)
	local real tuple_temp_1 = vec3_moveTowards_return_y
	local real tuple_temp_2 = vec3_moveTowards_return_z
	local real a_x = tuple_temp
	local real a_y = tuple_temp_1
	local real a_z = tuple_temp_2
	local real tuple_temp_3 = vec3_moveTowards(0., 0., 0., 6., 5., 4., 10.)
	local real tuple_temp_4 = vec3_moveTowards_return_y
	local real tuple_temp_5 = vec3_moveTowards_return_z
	local real b_x = tuple_temp_3
	local real b_y = tuple_temp_4
	local real b_z = tuple_temp_5
	if vec3_approxEq(a_x, a_y, a_z, 2.673, 5.345, 8.018) and vec3_approxEq(b_x, b_y, b_z, 6.838, 5.698, 4.558) then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

