// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array A_nextFree
integer A_firstFree=0
integer A_maxIndex=0
integer array A_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set A_firstFree = 0
	set A_maxIndex = 0
endfunction

function A_onDestroy takes integer this returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_A takes integer obj returns nothing
	if A_typeId[obj] == 0 then
		call error("Double free: object of type A")
	else
		set A_nextFree[A_firstFree] = obj
		set A_firstFree = A_firstFree + 1
		set A_typeId[obj] = 0
	endif
endfunction

function destroyA takes integer this returns nothing
	call A_onDestroy(this)
	call dealloc_A(this)
endfunction

function B_onDestroy takes integer this returns nothing
	call testSuccess()
	call A_onDestroy(this)
endfunction

function dealloc_B takes integer obj returns nothing
	if A_typeId[obj] == 0 then
		call error("Double free: object of type B")
	else
		set A_nextFree[A_firstFree] = obj
		set A_firstFree = A_firstFree + 1
		set A_typeId[obj] = 0
	endif
endfunction

function destroyB takes integer this returns nothing
	call B_onDestroy(this)
	call dealloc_B(this)
endfunction

function dispatch_A_destroyA takes integer this returns nothing
	if A_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling A.A")
		else
			call error("Called A.A on invalid object.")
		endif
	endif
	if A_typeId[this] <= 1 then
		call destroyA(this)
	else
		call destroyB(this)
	endif
endfunction

function alloc_B takes nothing returns integer
	local integer this
	if A_firstFree == 0 then
		if A_maxIndex < 32768 then
			set A_maxIndex = A_maxIndex + 1
			set this = A_maxIndex
			set A_typeId[this] = 2
		else
			call error("Out of memory: Could not create B.")
			set this = 0
		endif
	else
		set A_firstFree = A_firstFree - 1
		set this = A_nextFree[A_firstFree]
		set A_typeId[this] = 2
	endif
	return this
endfunction

function construct_B_OnDestroy takes integer this returns nothing
endfunction

function B_init takes integer this returns nothing
	call construct_B_OnDestroy(this)
endfunction

function A_init takes integer this returns nothing
endfunction

function construct_A takes integer this returns nothing
	call A_init(this)
endfunction

function construct_B takes integer this returns nothing
	call construct_A(this)
	call B_init(this)
endfunction

function new_B takes nothing returns integer
	local integer this = alloc_B()
	call construct_B(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer b = new_B()
	call dispatch_A_destroyA(b)
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

