// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
integer array C_typeId
integer array Iterator_nextFree
integer Iterator_firstFree=0
integer Iterator_maxIndex=0
integer array Iterator_i
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function new_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
			set C_typeId[this] = 1
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
		set C_typeId[this] = 1
	endif
	return this
endfunction

function new_Iterator takes nothing returns integer
	local integer this
	if Iterator_firstFree == 0 then
		if Iterator_maxIndex < 32768 then
			set Iterator_maxIndex = Iterator_maxIndex + 1
			set this = Iterator_maxIndex
		else
			call error("Out of memory: Could not create Iterator.")
			set this = 0
		endif
	else
		set Iterator_firstFree = Iterator_firstFree - 1
		set this = Iterator_nextFree[Iterator_firstFree]
	endif
	set Iterator_i[this] = 0
	return this
endfunction

function init_test takes nothing returns nothing
	local integer c = new_C()
	if C_typeId[c] == 0 then
		if c == 0 then
			call error("Nullpointer exception when calling C.iterator")
		else
			call error("Called C.iterator on invalid object.")
		endif
	endif
	set c = new_Iterator()
	loop
		exitwhen Iterator_i[c] >= 10
		set Iterator_i[c] = Iterator_i[c] + 1
		if Iterator_i[c] == 5 then
			call testSuccess()
		endif
	endloop
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

