// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array Person_nextFree
integer Person_firstFree=0
integer Person_maxIndex=0
integer array Person_typeId
string array Person_name
endglobals
native testFail takes string msg returns nothing
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set Person_firstFree = 0
	set Person_maxIndex = 0
endfunction

function Person_getName takes integer this returns string
	return Person_name[this]
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dispatch_Person_test_Person_getName takes integer this returns string
	local string test_Person_getName_result
	if Person_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Person.getName")
		else
			call error("Called Person.getName on invalid object.")
		endif
	endif
	set test_Person_getName_result = Person_getName(this)
	return test_Person_getName_result
endfunction

function Person_setName takes integer this, string n returns nothing
	set Person_name[this] = n
endfunction

function dispatch_Person_test_Person_setName takes integer this, string n returns nothing
	if Person_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Person.setName")
		else
			call error("Called Person.setName on invalid object.")
		endif
	endif
	call Person_setName(this, n)
endfunction

function alloc_Person takes nothing returns integer
	local integer this
	if Person_firstFree == 0 then
		if Person_maxIndex < 32768 then
			set Person_maxIndex = Person_maxIndex + 1
			set this = Person_maxIndex
			set Person_typeId[this] = 1
		else
			call error("Out of memory: Could not create Person.")
			set this = 0
		endif
	else
		set Person_firstFree = Person_firstFree - 1
		set this = Person_nextFree[Person_firstFree]
		set Person_typeId[this] = 1
	endif
	return this
endfunction

function Person_init takes integer this returns nothing
endfunction

function construct_Person takes integer this, string n returns nothing
	call Person_init(this)
	set Person_name[this] = n
endfunction

function new_Person takes string n returns integer
	local integer this = alloc_Person()
	call construct_Person(this, n)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer p = new_Person("peq")
	if dispatch_Person_test_Person_getName(p) != "peq" then
		call testFail("name != peq")
	else
		call dispatch_Person_test_Person_setName(p, "Frotty")
		if dispatch_Person_test_Person_getName(p) == "Frotty" then
			call testSuccess()
		else
			call testFail("name != Frotty.")
		endif
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

