// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
string test_s=null
integer array T_nextFree
integer T_firstFree=0
integer T_maxIndex=0
integer array T_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set T_firstFree = 0
	set T_maxIndex = 0
endfunction

function A_onDestroy takes integer this returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_A takes integer obj returns nothing
	if T_typeId[obj] == 0 then
		call error("Double free: object of type A")
	else
		set T_nextFree[T_firstFree] = obj
		set T_firstFree = T_firstFree + 1
		set T_typeId[obj] = 0
	endif
endfunction

function destroyA takes integer this returns nothing
	call A_onDestroy(this)
	call dealloc_A(this)
endfunction

function B_onDestroy takes integer this returns nothing
	set test_s = test_s + "B"
endfunction

function dealloc_B takes integer obj returns nothing
	if T_typeId[obj] == 0 then
		call error("Double free: object of type B")
	else
		set T_nextFree[T_firstFree] = obj
		set T_firstFree = T_firstFree + 1
		set T_typeId[obj] = 0
	endif
endfunction

function destroyB takes integer this returns nothing
	call B_onDestroy(this)
	call dealloc_B(this)
endfunction

function dealloc_T takes integer obj returns nothing
	if T_typeId[obj] == 0 then
		call error("Double free: object of type T")
	else
		set T_nextFree[T_firstFree] = obj
		set T_firstFree = T_firstFree + 1
		set T_typeId[obj] = 0
	endif
endfunction

function destroyT takes integer this returns nothing
	call dealloc_T(this)
endfunction

function dispatch_T_destroyT takes integer this returns nothing
	if T_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling T.T")
		else
			call error("Called T.T on invalid object.")
		endif
	endif
	if T_typeId[this] <= 2 then
		if T_typeId[this] <= 1 then
			call destroyT(this)
		else
			call destroyA(this)
		endif
	else
		call destroyB(this)
	endif
endfunction

function alloc_A takes nothing returns integer
	local integer this
	if T_firstFree == 0 then
		if T_maxIndex < 32768 then
			set T_maxIndex = T_maxIndex + 1
			set this = T_maxIndex
			set T_typeId[this] = 2
		else
			call error("Out of memory: Could not create A.")
			set this = 0
		endif
	else
		set T_firstFree = T_firstFree - 1
		set this = T_nextFree[T_firstFree]
		set T_typeId[this] = 2
	endif
	return this
endfunction

function A_init takes integer this returns nothing
endfunction

function construct_A takes integer this returns nothing
	call A_init(this)
endfunction

function new_A takes nothing returns integer
	local integer this = alloc_A()
	call construct_A(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer t
	set test_s = ""
	set t = new_A()
	call dispatch_T_destroyT(t)
	if test_s == "" then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

