// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
integer array C_v_0
integer array C_v_1
integer array C_v_2
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function C_v_get takes integer index1, integer index2 returns integer
	local integer returnVal
	if index2 < 0 or index2 >= 3 then
		call error("Index out of Bounds")
	elseif index2 <= 1 then
		if index2 <= 0 then
			set returnVal = C_v_0[index1]
		else
			set returnVal = C_v_1[index1]
		endif
	else
		set returnVal = C_v_2[index1]
	endif
	return returnVal
endfunction

function alloc_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
	endif
	return this
endfunction

function C_v_set takes integer instanceId, integer arrayIndex, integer value returns nothing
	if arrayIndex < 0 or arrayIndex >= 3 then
		call error("Index out of Bounds")
	elseif arrayIndex <= 1 then
		if arrayIndex <= 0 then
			set C_v_0[instanceId] = value
		else
			set C_v_1[instanceId] = value
		endif
	else
		set C_v_2[instanceId] = value
	endif
endfunction

function C_init takes integer this returns nothing
	call C_v_set(this, 0, 7)
	call C_v_set(this, 1, 8)
	call C_v_set(this, 2, 9)
endfunction

function construct_C takes integer this returns nothing
	call C_init(this)
endfunction

function new_C takes nothing returns integer
	local integer this = alloc_C()
	call construct_C(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer c = new_C()
	if C_v_get(c, 0) == 7 and C_v_get(c, 1) == 8 and C_v_get(c, 2) == 9 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

