//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
class LuaTableNamedFieldImpl implements LuaTableNamedField{
    LuaTableNamedFieldImpl(String fieldName, LuaExpr val) {
        if (fieldName == null)
            throw new IllegalArgumentException("Element fieldName must not be null.");
        if (val == null)
            throw new IllegalArgumentException("Element val must not be null.");
        this.fieldName = fieldName;
        this.val = val;
        val.setParent(this);
    }

    private Element parent;
    public Element getParent() { return parent; }
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree."
                + "Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    public void replaceBy(Element other) {
        if (parent == null)
            throw new RuntimeException("Node not attached to tree.");
        for (int i=0; i<parent.size(); i++) {
            if (parent.get(i) == this) {
                parent.set(i, other);
                return;
            }
        }
    }

    private String fieldName;
    public void setFieldName(String fieldName) {
        if (fieldName == null) throw new IllegalArgumentException();
        this.fieldName = fieldName;
    } 
    public String getFieldName() { return fieldName; }

    private LuaExpr val;
    public void setVal(LuaExpr val) {
        if (val == null) throw new IllegalArgumentException();
        this.val.setParent(null);
        val.setParent(this);
        this.val = val;
    } 
    public LuaExpr getVal() { return val; }

    public Element get(int i) {
        switch (i) {
            case 0: return val;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }
    public Element set(int i, Element newElem) {
        Element oldElem;
        switch (i) {
            case 0: oldElem = val; setVal((LuaExpr) newElem); return oldElem;
            default: throw new IllegalArgumentException("Index out of range: " + i);
        }
    }

    @Override
    public void forEachElement(java.util.function.Consumer<? super Element> action) {
        action.accept(this.val);
    }
    public int size() {
        return 1;
    }
    @Override public LuaTableNamedField copy() {
        LuaTableNamedField result = new LuaTableNamedFieldImpl(fieldName, (LuaExpr) this.val.copy());
        return result;
    }

    @Override public LuaTableNamedField copyWithRefs() {
        LuaTableNamedField res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    @Override public void clearAttributes() {
        val.clearAttributes();
        clearAttributesLocal();
    }
    @Override public void clearAttributesLocal() {
    }
    @Override public void accept(Visitor v) {
        v.visit(this);
    }
    @Override public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaTableNamedField(this);
    }
    @Override public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaTableNamedField(this);
    }

    @Override public <T> T match(LuaTableField.Matcher<T> matcher) {
        return matcher.case_LuaTableNamedField(this);
    }
    @Override public void match(LuaTableField.MatcherVoid matcher) {
        matcher.case_LuaTableNamedField(this);
    }

    @Override public String toString() {
        return "LuaTableNamedField(" + fieldName + ", " +val+")";
    }
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaTableNamedField) {
            LuaTableNamedField o = (LuaTableNamedField) e;
            return java.util.Objects.equals(fieldName, o.getFieldName())
                && this.val.structuralEquals(o.getVal());
        } else {
            return false;
        }
    }
    /** */
    public void print(StringBuilder sb, int indent) {
        de.peeeq.wurstscript.translation.lua.printing.LuaPrinter.print((LuaTableNamedField)this, sb, indent);
    }
}
