//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

@SuppressWarnings({"cast", "unused", "rawtypes"})
public abstract class LuaCompilationUnit extends AsgList<LuaStatement> implements Element{
    public LuaCompilationUnit copy() {
        LuaCompilationUnit result = new LuaCompilationUnitImpl();
        for (LuaStatement elem : this) {
            result.add((LuaStatement) elem.copy());
        }
        return result;
    }

    @Override public LuaCompilationUnit copyWithRefs() {
        LuaCompilationUnit res = copy();
        Element self = this;
        res.accept(new Element.DefaultVisitor() {
            @Override public void visit(LuaExprMethodCall e) {
                super.visit(e);
                // check reference method
                {
                    Element elem = e.getMethod();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setMethod((LuaMethod) res.followPath(self.pathTo(e.getMethod())));
                    }
                }
            }
            @Override public void visit(LuaExprFunctionCall e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
            @Override public void visit(LuaExprVarAccess e) {
                super.visit(e);
                // check reference var
                {
                    Element elem = e.getVar();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setVar((LuaVariable) res.followPath(self.pathTo(e.getVar())));
                    }
                }
            }
            @Override public void visit(LuaExprFuncRef e) {
                super.visit(e);
                // check reference func
                {
                    Element elem = e.getFunc();
                    while (elem != self && elem != null) {
                        elem = elem.getParent();
                    }
                    if (elem == self) {
                        e.setFunc((LuaFunction) res.followPath(self.pathTo(e.getFunc())));
                    }
                }
            }
        });
        return res;
    }

    /** */
    public abstract void print(StringBuilder sb, int indent);
}
