//generated by abstract-syntax-gen
package de.peeeq.wurstscript.luaAst;
import java.util.*;

public interface Element {
    Element getParent();
    Element copy();
    Element copyWithRefs();
    int size();
    void clearAttributes();
    void clearAttributesLocal();
    Element get(int i);
    Element set(int i, Element newElement);
    void forEachElement(java.util.function.Consumer<? super Element> action);
    default void trimToSize() {        forEachElement(Element::trimToSize);    }    void setParent(Element parent);
    void replaceBy(Element other);
    boolean structuralEquals(Element elem);
    default List<Integer> pathTo(Element  elem) {
        List<Integer> path = new ArrayList<>();
        while (elem != this) {
            if (elem == null) {
                throw new RuntimeException("Element " + elem + " is not a parent of " + this);
            }
            Element parent = elem.getParent();
            for (int i = 0; i < parent.size(); i++) {
                if (parent.get(i) == elem) {
                    path.add(i);
                    break;
                }
            }
            elem = parent;
        }
        Collections.reverse(path);
        return path;
    }

    default Element followPath(Iterable<Integer> path) {
        Element elem = this;
        for (Integer i : path) {
            elem = elem.get(i);
        }
        return elem;
    }
    <T> T match(Matcher<T> s);
    void match(MatcherVoid s);
    public interface Matcher<T> {
        T case_LuaExprRealVal(LuaExprRealVal luaExprRealVal);
        T case_LuaOpUnequals(LuaOpUnequals luaOpUnequals);
        T case_LuaAssignment(LuaAssignment luaAssignment);
        T case_LuaExprFunctionAbstraction(LuaExprFunctionAbstraction luaExprFunctionAbstraction);
        T case_LuaOpDiv(LuaOpDiv luaOpDiv);
        T case_LuaExprMethodCall(LuaExprMethodCall luaExprMethodCall);
        T case_LuaVariable(LuaVariable luaVariable);
        T case_LuaExprlist(LuaExprlist luaExprlist);
        T case_LuaExprArrayAccess(LuaExprArrayAccess luaExprArrayAccess);
        T case_LuaOpAnd(LuaOpAnd luaOpAnd);
        T case_LuaOpEquals(LuaOpEquals luaOpEquals);
        T case_LuaTableConstructor(LuaTableConstructor luaTableConstructor);
        T case_LuaOpMod(LuaOpMod luaOpMod);
        T case_LuaExprFunctionCall(LuaExprFunctionCall luaExprFunctionCall);
        T case_LuaTableNamedField(LuaTableNamedField luaTableNamedField);
        T case_LuaExprStringVal(LuaExprStringVal luaExprStringVal);
        T case_LuaExprNull(LuaExprNull luaExprNull);
        T case_LuaExprBoolVal(LuaExprBoolVal luaExprBoolVal);
        T case_LuaStatements(LuaStatements luaStatements);
        T case_LuaOpGreater(LuaOpGreater luaOpGreater);
        T case_LuaOpMult(LuaOpMult luaOpMult);
        T case_LuaExprUnary(LuaExprUnary luaExprUnary);
        T case_LuaOpMinus(LuaOpMinus luaOpMinus);
        T case_LuaWhile(LuaWhile luaWhile);
        T case_LuaReturn(LuaReturn luaReturn);
        T case_LuaExprFieldAccess(LuaExprFieldAccess luaExprFieldAccess);
        T case_LuaOpOr(LuaOpOr luaOpOr);
        T case_LuaExprVarAccess(LuaExprVarAccess luaExprVarAccess);
        T case_LuaOpLessEq(LuaOpLessEq luaOpLessEq);
        T case_LuaOpLess(LuaOpLess luaOpLess);
        T case_LuaExprBinary(LuaExprBinary luaExprBinary);
        T case_LuaFunction(LuaFunction luaFunction);
        T case_LuaOpNot(LuaOpNot luaOpNot);
        T case_LuaExprFunctionCallByName(LuaExprFunctionCallByName luaExprFunctionCallByName);
        T case_LuaMethod(LuaMethod luaMethod);
        T case_LuaExprIntVal(LuaExprIntVal luaExprIntVal);
        T case_LuaOpConcatString(LuaOpConcatString luaOpConcatString);
        T case_LuaLiteral(LuaLiteral luaLiteral);
        T case_LuaBreak(LuaBreak luaBreak);
        T case_LuaParams(LuaParams luaParams);
        T case_LuaExprFunctionCallE(LuaExprFunctionCallE luaExprFunctionCallE);
        T case_LuaModel(LuaModel luaModel);
        T case_LuaNoExpr(LuaNoExpr luaNoExpr);
        T case_LuaOpPlus(LuaOpPlus luaOpPlus);
        T case_LuaExprFuncRef(LuaExprFuncRef luaExprFuncRef);
        T case_LuaTableExprField(LuaTableExprField luaTableExprField);
        T case_LuaCompilationUnit(LuaCompilationUnit luaCompilationUnit);
        T case_LuaTableFields(LuaTableFields luaTableFields);
        T case_LuaTableSingleField(LuaTableSingleField luaTableSingleField);
        T case_LuaIf(LuaIf luaIf);
        T case_LuaOpFloorDiv(LuaOpFloorDiv luaOpFloorDiv);
        T case_LuaOpGreaterEq(LuaOpGreaterEq luaOpGreaterEq);
    }

    public interface MatcherVoid {
        void case_LuaExprRealVal(LuaExprRealVal luaExprRealVal);
        void case_LuaOpUnequals(LuaOpUnequals luaOpUnequals);
        void case_LuaAssignment(LuaAssignment luaAssignment);
        void case_LuaExprFunctionAbstraction(LuaExprFunctionAbstraction luaExprFunctionAbstraction);
        void case_LuaOpDiv(LuaOpDiv luaOpDiv);
        void case_LuaExprMethodCall(LuaExprMethodCall luaExprMethodCall);
        void case_LuaVariable(LuaVariable luaVariable);
        void case_LuaExprlist(LuaExprlist luaExprlist);
        void case_LuaExprArrayAccess(LuaExprArrayAccess luaExprArrayAccess);
        void case_LuaOpAnd(LuaOpAnd luaOpAnd);
        void case_LuaOpEquals(LuaOpEquals luaOpEquals);
        void case_LuaTableConstructor(LuaTableConstructor luaTableConstructor);
        void case_LuaOpMod(LuaOpMod luaOpMod);
        void case_LuaExprFunctionCall(LuaExprFunctionCall luaExprFunctionCall);
        void case_LuaTableNamedField(LuaTableNamedField luaTableNamedField);
        void case_LuaExprStringVal(LuaExprStringVal luaExprStringVal);
        void case_LuaExprNull(LuaExprNull luaExprNull);
        void case_LuaExprBoolVal(LuaExprBoolVal luaExprBoolVal);
        void case_LuaStatements(LuaStatements luaStatements);
        void case_LuaOpGreater(LuaOpGreater luaOpGreater);
        void case_LuaOpMult(LuaOpMult luaOpMult);
        void case_LuaExprUnary(LuaExprUnary luaExprUnary);
        void case_LuaOpMinus(LuaOpMinus luaOpMinus);
        void case_LuaWhile(LuaWhile luaWhile);
        void case_LuaReturn(LuaReturn luaReturn);
        void case_LuaExprFieldAccess(LuaExprFieldAccess luaExprFieldAccess);
        void case_LuaOpOr(LuaOpOr luaOpOr);
        void case_LuaExprVarAccess(LuaExprVarAccess luaExprVarAccess);
        void case_LuaOpLessEq(LuaOpLessEq luaOpLessEq);
        void case_LuaOpLess(LuaOpLess luaOpLess);
        void case_LuaExprBinary(LuaExprBinary luaExprBinary);
        void case_LuaFunction(LuaFunction luaFunction);
        void case_LuaOpNot(LuaOpNot luaOpNot);
        void case_LuaExprFunctionCallByName(LuaExprFunctionCallByName luaExprFunctionCallByName);
        void case_LuaMethod(LuaMethod luaMethod);
        void case_LuaExprIntVal(LuaExprIntVal luaExprIntVal);
        void case_LuaOpConcatString(LuaOpConcatString luaOpConcatString);
        void case_LuaLiteral(LuaLiteral luaLiteral);
        void case_LuaBreak(LuaBreak luaBreak);
        void case_LuaParams(LuaParams luaParams);
        void case_LuaExprFunctionCallE(LuaExprFunctionCallE luaExprFunctionCallE);
        void case_LuaModel(LuaModel luaModel);
        void case_LuaNoExpr(LuaNoExpr luaNoExpr);
        void case_LuaOpPlus(LuaOpPlus luaOpPlus);
        void case_LuaExprFuncRef(LuaExprFuncRef luaExprFuncRef);
        void case_LuaTableExprField(LuaTableExprField luaTableExprField);
        void case_LuaCompilationUnit(LuaCompilationUnit luaCompilationUnit);
        void case_LuaTableFields(LuaTableFields luaTableFields);
        void case_LuaTableSingleField(LuaTableSingleField luaTableSingleField);
        void case_LuaIf(LuaIf luaIf);
        void case_LuaOpFloorDiv(LuaOpFloorDiv luaOpFloorDiv);
        void case_LuaOpGreaterEq(LuaOpGreaterEq luaOpGreaterEq);
    }

    public abstract void accept(Visitor v);
    public interface Visitor {
        void visit(LuaFunction luaFunction);
        void visit(LuaMethod luaMethod);
        void visit(LuaVariable luaVariable);
        void visit(LuaAssignment luaAssignment);
        void visit(LuaWhile luaWhile);
        void visit(LuaIf luaIf);
        void visit(LuaBreak luaBreak);
        void visit(LuaReturn luaReturn);
        void visit(LuaNoExpr luaNoExpr);
        void visit(LuaExprBinary luaExprBinary);
        void visit(LuaExprUnary luaExprUnary);
        void visit(LuaExprFunctionAbstraction luaExprFunctionAbstraction);
        void visit(LuaTableConstructor luaTableConstructor);
        void visit(LuaExprFieldAccess luaExprFieldAccess);
        void visit(LuaExprArrayAccess luaExprArrayAccess);
        void visit(LuaExprFunctionCall luaExprFunctionCall);
        void visit(LuaExprMethodCall luaExprMethodCall);
        void visit(LuaExprFunctionCallByName luaExprFunctionCallByName);
        void visit(LuaExprFunctionCallE luaExprFunctionCallE);
        void visit(LuaTableNamedField luaTableNamedField);
        void visit(LuaTableExprField luaTableExprField);
        void visit(LuaTableSingleField luaTableSingleField);
        void visit(LuaExprIntVal luaExprIntVal);
        void visit(LuaExprRealVal luaExprRealVal);
        void visit(LuaExprStringVal luaExprStringVal);
        void visit(LuaExprBoolVal luaExprBoolVal);
        void visit(LuaExprFuncRef luaExprFuncRef);
        void visit(LuaExprNull luaExprNull);
        void visit(LuaLiteral luaLiteral);
        void visit(LuaExprVarAccess luaExprVarAccess);
        void visit(LuaOpOr luaOpOr);
        void visit(LuaOpAnd luaOpAnd);
        void visit(LuaOpEquals luaOpEquals);
        void visit(LuaOpUnequals luaOpUnequals);
        void visit(LuaOpLessEq luaOpLessEq);
        void visit(LuaOpLess luaOpLess);
        void visit(LuaOpGreaterEq luaOpGreaterEq);
        void visit(LuaOpGreater luaOpGreater);
        void visit(LuaOpPlus luaOpPlus);
        void visit(LuaOpConcatString luaOpConcatString);
        void visit(LuaOpMinus luaOpMinus);
        void visit(LuaOpMult luaOpMult);
        void visit(LuaOpDiv luaOpDiv);
        void visit(LuaOpMod luaOpMod);
        void visit(LuaOpFloorDiv luaOpFloorDiv);
        void visit(LuaOpNot luaOpNot);
        void visit(LuaModel luaModel);
        void visit(LuaCompilationUnit luaCompilationUnit);
        void visit(LuaParams luaParams);
        void visit(LuaStatements luaStatements);
        void visit(LuaExprlist luaExprlist);
        void visit(LuaTableFields luaTableFields);
    }
    public static abstract class DefaultVisitor implements Visitor {
        @Override public void visit(LuaFunction luaFunction) {
          luaFunction.getParams().accept(this);
          luaFunction.getBody().accept(this);
     }
        @Override public void visit(LuaMethod luaMethod) {
          luaMethod.getReceiver().accept(this);
          luaMethod.getParams().accept(this);
          luaMethod.getBody().accept(this);
     }
        @Override public void visit(LuaVariable luaVariable) {
          luaVariable.getInitialValue().accept(this);
     }
        @Override public void visit(LuaAssignment luaAssignment) {
          luaAssignment.getLeft().accept(this);
          luaAssignment.getRight().accept(this);
     }
        @Override public void visit(LuaWhile luaWhile) {
          luaWhile.getCond().accept(this);
          luaWhile.getBody().accept(this);
     }
        @Override public void visit(LuaIf luaIf) {
          luaIf.getCond().accept(this);
          luaIf.getThenStmts().accept(this);
          luaIf.getElseStmts().accept(this);
     }
        @Override public void visit(LuaBreak luaBreak) {
     }
        @Override public void visit(LuaReturn luaReturn) {
          luaReturn.getRetVal().accept(this);
     }
        @Override public void visit(LuaNoExpr luaNoExpr) {
     }
        @Override public void visit(LuaExprBinary luaExprBinary) {
          luaExprBinary.getLeftExpr().accept(this);
          luaExprBinary.getOp().accept(this);
          luaExprBinary.getRight().accept(this);
     }
        @Override public void visit(LuaExprUnary luaExprUnary) {
          luaExprUnary.getOpU().accept(this);
          luaExprUnary.getRight().accept(this);
     }
        @Override public void visit(LuaExprFunctionAbstraction luaExprFunctionAbstraction) {
          luaExprFunctionAbstraction.getParams().accept(this);
          luaExprFunctionAbstraction.getBody().accept(this);
     }
        @Override public void visit(LuaTableConstructor luaTableConstructor) {
          luaTableConstructor.getTableFields().accept(this);
     }
        @Override public void visit(LuaExprFieldAccess luaExprFieldAccess) {
          luaExprFieldAccess.getReceiver().accept(this);
     }
        @Override public void visit(LuaExprArrayAccess luaExprArrayAccess) {
          luaExprArrayAccess.getLeft().accept(this);
          luaExprArrayAccess.getIndexes().accept(this);
     }
        @Override public void visit(LuaExprFunctionCall luaExprFunctionCall) {
          luaExprFunctionCall.getArguments().accept(this);
     }
        @Override public void visit(LuaExprMethodCall luaExprMethodCall) {
          luaExprMethodCall.getReceiver().accept(this);
          luaExprMethodCall.getArguments().accept(this);
     }
        @Override public void visit(LuaExprFunctionCallByName luaExprFunctionCallByName) {
          luaExprFunctionCallByName.getArguments().accept(this);
     }
        @Override public void visit(LuaExprFunctionCallE luaExprFunctionCallE) {
          luaExprFunctionCallE.getFuncExpr().accept(this);
          luaExprFunctionCallE.getArguments().accept(this);
     }
        @Override public void visit(LuaTableNamedField luaTableNamedField) {
          luaTableNamedField.getVal().accept(this);
     }
        @Override public void visit(LuaTableExprField luaTableExprField) {
          luaTableExprField.getFieldKey().accept(this);
          luaTableExprField.getVal().accept(this);
     }
        @Override public void visit(LuaTableSingleField luaTableSingleField) {
          luaTableSingleField.getVal().accept(this);
     }
        @Override public void visit(LuaExprIntVal luaExprIntVal) {
     }
        @Override public void visit(LuaExprRealVal luaExprRealVal) {
     }
        @Override public void visit(LuaExprStringVal luaExprStringVal) {
     }
        @Override public void visit(LuaExprBoolVal luaExprBoolVal) {
     }
        @Override public void visit(LuaExprFuncRef luaExprFuncRef) {
     }
        @Override public void visit(LuaExprNull luaExprNull) {
     }
        @Override public void visit(LuaLiteral luaLiteral) {
     }
        @Override public void visit(LuaExprVarAccess luaExprVarAccess) {
     }
        @Override public void visit(LuaOpOr luaOpOr) {
     }
        @Override public void visit(LuaOpAnd luaOpAnd) {
     }
        @Override public void visit(LuaOpEquals luaOpEquals) {
     }
        @Override public void visit(LuaOpUnequals luaOpUnequals) {
     }
        @Override public void visit(LuaOpLessEq luaOpLessEq) {
     }
        @Override public void visit(LuaOpLess luaOpLess) {
     }
        @Override public void visit(LuaOpGreaterEq luaOpGreaterEq) {
     }
        @Override public void visit(LuaOpGreater luaOpGreater) {
     }
        @Override public void visit(LuaOpPlus luaOpPlus) {
     }
        @Override public void visit(LuaOpConcatString luaOpConcatString) {
     }
        @Override public void visit(LuaOpMinus luaOpMinus) {
     }
        @Override public void visit(LuaOpMult luaOpMult) {
     }
        @Override public void visit(LuaOpDiv luaOpDiv) {
     }
        @Override public void visit(LuaOpMod luaOpMod) {
     }
        @Override public void visit(LuaOpFloorDiv luaOpFloorDiv) {
     }
        @Override public void visit(LuaOpNot luaOpNot) {
     }
        @Override public void visit(LuaModel luaModel) {
          for (LuaCompilationUnit i : luaModel ) {
              i.accept(this);
          }
     }
        @Override public void visit(LuaCompilationUnit luaCompilationUnit) {
          for (LuaStatement i : luaCompilationUnit ) {
              i.accept(this);
          }
     }
        @Override public void visit(LuaParams luaParams) {
          for (LuaVariable i : luaParams ) {
              i.accept(this);
          }
     }
        @Override public void visit(LuaStatements luaStatements) {
          for (LuaStatement i : luaStatements ) {
              i.accept(this);
          }
     }
        @Override public void visit(LuaExprlist luaExprlist) {
          for (LuaExpr i : luaExprlist ) {
              i.accept(this);
          }
     }
        @Override public void visit(LuaTableFields luaTableFields) {
          for (LuaTableField i : luaTableFields ) {
              i.accept(this);
          }
     }
    }
    /** */
    public abstract void print(StringBuilder sb, int indent);
}

