/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eB3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\u0010\u0013B?\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0015\u001a\u00020\t\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%H\u0016R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Ldorkbox/util/NamedThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "poolNamePrefix", "", "(Ljava/lang/String;)V", "group", "Ljava/lang/ThreadGroup;", "(Ljava/lang/String;Ljava/lang/ThreadGroup;)V", "isDaemon", "", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;Ljava/lang/ThreadGroup;Z)V", "threadPriority", "", "(Ljava/lang/String;Ljava/lang/ThreadGroup;IZ)V", "actionOnNewThread", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "(Ljava/lang/String;Ljava/lang/ThreadGroup;ZLkotlin/jvm/functions/Function1;)V", "namePrefix", "daemon", "(Ljava/lang/String;Ljava/lang/ThreadGroup;IZLkotlin/jvm/functions/Function1;)V", "getActionOnNewThread", "()Lkotlin/jvm/functions/Function1;", "getDaemon", "()Z", "getGroup", "()Ljava/lang/ThreadGroup;", "getNamePrefix", "()Ljava/lang/String;", "poolId", "Ljava/util/concurrent/atomic/AtomicInteger;", "getThreadPriority", "()I", "newThread", "r", "Ljava/lang/Runnable;", "Companion", "Utilities"})
public final class NamedThreadFactory
implements ThreadFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String namePrefix;
    @NotNull
    private final ThreadGroup group;
    private final int threadPriority;
    private final boolean daemon;
    @NotNull
    private final Function1<Thread, Unit> actionOnNewThread;
    @NotNull
    private final AtomicInteger poolId;
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();

    public NamedThreadFactory(@NotNull String namePrefix, @NotNull ThreadGroup group, int threadPriority, boolean daemon, @NotNull Function1<? super Thread, Unit> actionOnNewThread) {
        Intrinsics.checkNotNullParameter((Object)namePrefix, (String)"namePrefix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(actionOnNewThread, (String)"actionOnNewThread");
        this.namePrefix = namePrefix;
        this.group = group;
        this.threadPriority = threadPriority;
        this.daemon = daemon;
        this.actionOnNewThread = actionOnNewThread;
        this.poolId = new AtomicInteger();
        if (!(this.threadPriority >= 1)) {
            boolean $i$a$-require-NamedThreadFactory$82 = false;
            String string = "Thread priority (%s) must be >= %s";
            Object[] objectArray = new Object[]{this.threadPriority, 1};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String $i$a$-require-NamedThreadFactory$82 = string2;
            throw new IllegalArgumentException($i$a$-require-NamedThreadFactory$82.toString());
        }
        if (!(this.threadPriority <= 10)) {
            boolean bl = false;
            String string = "Thread priority (%s) must be <= %s";
            Object[] objectArray = new Object[]{this.threadPriority, 10};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String string4 = string3;
            throw new IllegalArgumentException(string4.toString());
        }
    }

    public /* synthetic */ NamedThreadFactory(String string, ThreadGroup threadGroup, int n, boolean bl, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            Intrinsics.checkNotNullExpressionValue((Object)threadGroup2, (String)"currentThread().threadGroup");
            threadGroup = threadGroup2;
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(string, threadGroup, n, bl, (Function1<? super Thread, Unit>)function1);
    }

    @NotNull
    public final String getNamePrefix() {
        return this.namePrefix;
    }

    @NotNull
    public final ThreadGroup getGroup() {
        return this.group;
    }

    public final int getThreadPriority() {
        return this.threadPriority;
    }

    public final boolean getDaemon() {
        return this.daemon;
    }

    @NotNull
    public final Function1<Thread, Unit> getActionOnNewThread() {
        return this.actionOnNewThread;
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Intrinsics.checkNotNullExpressionValue((Object)threadGroup, (String)"currentThread().threadGroup");
        this(poolNamePrefix, threadGroup, 5, true, (Function1<? super Thread, Unit>)((Function1)1.INSTANCE));
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix, @NotNull ThreadGroup group) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this(poolNamePrefix, group, 5, true, (Function1<? super Thread, Unit>)((Function1)2.INSTANCE));
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix, boolean isDaemon) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Intrinsics.checkNotNullExpressionValue((Object)threadGroup, (String)"currentThread().threadGroup");
        this(poolNamePrefix, threadGroup, isDaemon, (Function1<? super Thread, Unit>)((Function1)3.INSTANCE));
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix, @NotNull ThreadGroup group, boolean isDaemon) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this(poolNamePrefix, group, 5, isDaemon, (Function1<? super Thread, Unit>)((Function1)4.INSTANCE));
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix, @NotNull ThreadGroup group, int threadPriority, boolean isDaemon) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this(poolNamePrefix, group, threadPriority, isDaemon, (Function1<? super Thread, Unit>)((Function1)5.INSTANCE));
    }

    public NamedThreadFactory(@NotNull String poolNamePrefix, @NotNull ThreadGroup group, boolean isDaemon, @NotNull Function1<? super Thread, Unit> actionOnNewThread) {
        Intrinsics.checkNotNullParameter((Object)poolNamePrefix, (String)"poolNamePrefix");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(actionOnNewThread, (String)"actionOnNewThread");
        this(poolNamePrefix, group, 5, isDaemon, actionOnNewThread);
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread t2 = new Thread(this.group, r, this.namePrefix + '-' + this.poolId.incrementAndGet());
        t2.setDaemon(this.daemon);
        t2.setPriority(this.threadPriority);
        this.actionOnNewThread.invoke((Object)t2);
        return t2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldorkbox/util/NamedThreadFactory$Companion;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

